#!/bin/sh
# 
# f-cpu/install.sh
# created dim mar 31 01:31:08 2002 by whygee@f-cpu.org
# updated Tue Jun 25 15:35:04 2002
# updated Fri Jun 28 07:33:08 2002 : sourcing vhdl_tools.sh
#       instead of defining its own set of display functions
# updated Sat Jun 29 03:32:16 2002 : adding $EXHAUSTIVE_TEST


echo
echo "     Hello, this is a little configuration and setup script"
echo "     for the F-CPU source code tree. It will run some detection"
echo "     and sanity checks to ensure that you can compile the sources."
echo "     DON'T PANIC ! depending on your computer and installed tools,"
echo "     it will take more or less time..."
echo

VHDL_TOOLNAMES="no" # prevents tool detection at this time
source vhdl/tools.desc/vhdl_tools.sh

function test_all_EUs () {
  for EU in common clock registers eu_rop2 eu_asu eu_imu eu_shl
  do
    (
      cd $EU &&
      ln -f -s ../$TOOLNAMES_FILE &&
      source test.sh
    ) || {
      echo_failure " OOOOPS ! $EU doesn't work ! "
      return 1
    }
  done
}

# hint : parenthesis now are used to create subshells, so there is
# no problem with environment variables or directories. Things
# could even be parallelized if it was possible.
# They are also used to perform implicit IF/THEN/ELSE along
# with the || and && keywords. Ugly but light.
(

# step 1 : configuration
 (
  echo_warning "re-generating the configuration"
  cd configuration &&
  make &&
  echo_success "configuration ok"
 ) && (

# step 2 : generate and test YGASM
# (nasm is used by fromfs but a custom replacement is needed)
  cd ygasm
 ) && (

# step 3 : create and test the fromfs utilities
  echo_warning "fromfs utilities"
  cd fromfs &&
  . fromfs.sh &&
  echo_success "fromfs ok"
 ) && (

# step 4 : tool detection
  echo_warning "(re)detecting VHDL tools"
  unset VHDL_TOOLNAMES # no '&&' here or it won't work in some cases
  cd vhdl &&
#  rm -f .vhdl_tools &&
  source tools.desc/vhdl_tools.sh

# step 5 : run all the units' testbenches
  echo_success "Testing all the EUs"
  test_all_EUs
 ) && (

# step 6 : compile the whole CPU
  echo_warning "Compiling the whole core"
  cd vhdl &&
  source fc0.sh


# step 7 : running a sample program
 )

# The end.
) && (
  echo_success "Looks like it works :-)"
  if [ -z "$EXHAUSTIVE_TEST" ]
  then
    echo
    echo -n "If you want to run some exhaustive ALU tests (not necessary)
then type "
    $SETCOLOR_WARNING
    echo -n "'export EXHAUSTIVE_TEST=yes'"
    $SETCOLOR_NORMAL
    echo -n " at the prompt
and rerun install.sh. This is potentially excessively "
    $SETCOLOR_FAILURE
    echo -n 'slow'
    $SETCOLOR_NORMAL
    echo
    echo '(hours) on some machines or with some VHDL simulators.'
  fi
) || ( echo_failure "OOooopsss....." )
