/*
  f-cpu/c/xbar/xbar.c
  c simulation of the F-CPU xbar unit
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30
Tue Jul 23 12:32:42 CEST 2002 JWS: added some comments
Fri Jul 26 23:28:32 CEST 2002 JWS: removed: reg mov code
Mon Jul 29 10:28:54 CEST 2002 JWS: added display_color and display_normal

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
--
-- PC to/from an EU ?  -> sort of bypass ?
-- intermediate data to/from an EU !  -> sort of bypass ?
-- also register to tegister bypass for faster register movements ?
--
-- Xbar needs to claer bits in 8 / 16 / 32 bit write mode ?
--
*/

/* defines the constants, inputs and outputs : */
#include <xbar.h>


void xbar_view(void){
  printf("xbar unit input:\n");
  printf("xbar_use_r0     = %s  ",    display_bool[xbar_use_r0] );
  printf("xbar_use_r1     = %s  ",    display_bool[xbar_use_r1] );
  printf("xbar_use_r2     = %s\n",    display_bool[xbar_use_r2] );
  printf("xbar_r0_port_nr    = %s%2X%s  ", display_color, xbar_r0_port_nr, display_normal );
  printf("xbar_r1_port_nr    = %s%2X%s  ", display_color, xbar_r1_port_nr, display_normal );
  printf("xbar_r2_port_nr    = %s%2X%s\n", display_color, xbar_r2_port_nr, display_normal );
  printf("xbar_sch_bypass_r0 = %s%2X%s  ", display_color, xbar_sch_bypass_r0, display_normal );
  printf("xbar_sch_bypass_r1 = %s%2X%s  ", display_color, xbar_sch_bypass_r1, display_normal );
  printf("xbar_sch_bypass_r2 = %s%2X%s\n", display_color, xbar_sch_bypass_r2, display_normal );
  printf("xbar_reg_R0      = %s%16llX%s  ", display_color, xbar_reg_R0, display_normal );
  printf("xbar_reg_R1      = %s%16llX%s\n", display_color, xbar_reg_R1, display_normal );
  printf("xbar_reg_R2      = %s%16llX%s  ", display_color, xbar_reg_R2, display_normal );
  printf("xbar_EU_nr       = %s%2X%s\n",    display_color, xbar_EU_nr, display_normal );
  printf("xbar_w0_port_nr  = %s%2X%s                ", display_color, xbar_w0_port_nr, display_normal );
  printf("xbar_w1_port_nr  = %s%2X%s\n", display_color, xbar_w1_port_nr, display_normal );
  printf("xbar unit output:\n");
  printf("xbar_reg_W0      = %s%16llX%s  ", display_color, xbar_reg_W0, display_normal );
  printf("xbar_reg_W1      = %s%16llX%s\n", display_color, xbar_reg_W1, display_normal );
// xbar_read_to_port_r0[0..15];/* connected to the input 0 of the EU's */
// xbar_read_to_port_r1[0..15];/* connected to the input 1 of the EU's */
// xbar_read_to_port_r2[0..15];/* connected to the input 2 of the EU's */
// xbar_write_from_port[0..24];/* connected to the outputs of the EU's */
}


static inline void xbar_cycle(void) {

  UMAX xbar_bus_R0; /* these are the actual x-bar busses */
  UMAX xbar_bus_R1; /* other units can only acces xbar ports, */
  UMAX xbar_bus_R2; /* not directly these values ! */
  UMAX xbar_bus_W0;
  UMAX xbar_bus_W1;


  /* transfer the control signals from the decoder to the EU's: */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

  xbar_ADD_out               = xbar_ADD_in;
  xbar_SUB_out               = xbar_SUB_in;
  xbar_INC_out               = xbar_INC_in;
  xbar_DEC_out               = xbar_DEC_in;
  xbar_rop2_function_out     = xbar_rop2_function_in;
//do the pre-calculation for rop2_function here ??
  xbar_rop2_mode_out         = xbar_rop2_mode_in;
  xbar_rop2_combine_size_out = xbar_rop2_combine_size_in;
  xbar_size_out              = xbar_size_in;
  xbar_simd_out              = xbar_size_in;
  xbar_high_out              = xbar_size_in;

  /* -- add more UE control signals here -- */

  /* Xbar stage */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

  /* check if a bypass is needed: */
  /* (combine data from scheduler and decoder) */
  /* i.e. obly bypass if we are reding from resgisters !! */

  if ( xbar_use_r0 ) { xbar_r0_port_nr = xbar_sch_bypass_r0; }
  if ( xbar_use_r1 ) { xbar_r1_port_nr = xbar_sch_bypass_r1; }
  if ( xbar_use_r2 ) { xbar_r2_port_nr = xbar_sch_bypass_r2; }

  /* copy EU output ports to write bus: */
  xbar_bus_W0 = xbar_write_from_port[xbar_w0_port_nr];
  xbar_bus_W1 = xbar_write_from_port[xbar_w1_port_nr];
  /* write to registers: */
  xbar_reg_W0 = xbar_bus_W0;  /* not if we write to IP / data mem !?! */
  xbar_reg_W1 = xbar_bus_W1;  /* not if we write to IP / data mem !?! */

  /* read bus (with normal register read): */
  if (xbar_r0_port_nr==PORT_READ_FROM_REGISTER){ xbar_bus_R0 = xbar_reg_R0; }
  if (xbar_r1_port_nr==PORT_READ_FROM_REGISTER){ xbar_bus_R1 = xbar_reg_R1; }
  if (xbar_r2_port_nr==PORT_READ_FROM_REGISTER){ xbar_bus_R2 = xbar_reg_R2; }

  /* read bus (with bypass): */
  if (xbar_r0_port_nr==PORT_READ_FROM_BYPASS_0){ xbar_bus_R0 = xbar_bus_W0; }
  if (xbar_r0_port_nr==PORT_READ_FROM_BYPASS_1){ xbar_bus_R0 = xbar_bus_W1; }
  if (xbar_r1_port_nr==PORT_READ_FROM_BYPASS_0){ xbar_bus_R1 = xbar_bus_W0; }
  if (xbar_r1_port_nr==PORT_READ_FROM_BYPASS_1){ xbar_bus_R1 = xbar_bus_W1; }
  if (xbar_r2_port_nr==PORT_READ_FROM_BYPASS_0){ xbar_bus_R2 = xbar_bus_W0; }
  if (xbar_r2_port_nr==PORT_READ_FROM_BYPASS_1){ xbar_bus_R2 = xbar_bus_W1; }

  /* read bus (with delayed bypass): */
  if (xbar_r0_port_nr==PORT_READ_FROM_BYPASS_0_BIS){ xbar_bus_R0 = tmp_xbar_bus_W0; }
  if (xbar_r0_port_nr==PORT_READ_FROM_BYPASS_1_BIS){ xbar_bus_R0 = tmp_xbar_bus_W1; }
  if (xbar_r1_port_nr==PORT_READ_FROM_BYPASS_0_BIS){ xbar_bus_R1 = tmp_xbar_bus_W0; }
  if (xbar_r1_port_nr==PORT_READ_FROM_BYPASS_1_BIS){ xbar_bus_R1 = tmp_xbar_bus_W1; }
  if (xbar_r2_port_nr==PORT_READ_FROM_BYPASS_0_BIS){ xbar_bus_R2 = tmp_xbar_bus_W0; }
  if (xbar_r2_port_nr==PORT_READ_FROM_BYPASS_1_BIS){ xbar_bus_R2 = tmp_xbar_bus_W1; }

  /* read bus (with 2x delayed bypass): */
  if (xbar_r0_port_nr==PORT_READ_FROM_BYPASS_0_BI2){ xbar_bus_R0 = tmp_tmp_xbar_bus_W0; }
  if (xbar_r0_port_nr==PORT_READ_FROM_BYPASS_1_BI2){ xbar_bus_R0 = tmp_tmp_xbar_bus_W1; }
  if (xbar_r1_port_nr==PORT_READ_FROM_BYPASS_0_BI2){ xbar_bus_R1 = tmp_tmp_xbar_bus_W0; }
  if (xbar_r1_port_nr==PORT_READ_FROM_BYPASS_1_BI2){ xbar_bus_R1 = tmp_tmp_xbar_bus_W1; }
  if (xbar_r2_port_nr==PORT_READ_FROM_BYPASS_0_BI2){ xbar_bus_R2 = tmp_tmp_xbar_bus_W0; }
  if (xbar_r2_port_nr==PORT_READ_FROM_BYPASS_1_BI2){ xbar_bus_R2 = tmp_tmp_xbar_bus_W1; }

  /* clear al (other) EU input ports ? -> this is not needed ! */
  xbar_read_to_port_r0[EU_type_ASU] = 0;
  xbar_read_to_port_r1[EU_type_ASU] = 0;
  xbar_read_to_port_r2[EU_type_ASU] = 0;
  xbar_read_to_port_r0[EU_type_INC] = 0;
  xbar_read_to_port_r1[EU_type_INC] = 0;
  xbar_read_to_port_r2[EU_type_INC] = 0;


 /* copy read bus to EU input ports: */
  xbar_read_to_port_r0[xbar_EU_nr] = xbar_bus_R0;
  xbar_read_to_port_r1[xbar_EU_nr] = xbar_bus_R1;
  xbar_read_to_port_r2[xbar_EU_nr] = xbar_bus_R2;

  /* 1 and 2 cycle delayed write bus value:  */
  tmp_tmp_xbar_bus_W0 = tmp_xbar_bus_W0;
  tmp_tmp_xbar_bus_W1 = tmp_xbar_bus_W1;
      tmp_xbar_bus_W0 = xbar_bus_W0;
      tmp_xbar_bus_W1 = xbar_bus_W1;

}
