/*
  f-cpu/c/scheduler/scheduler.h - scheduler ports for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
           19 July 2002 13:30
Sun Jul 21 12:32:58 CEST 2002 JWS: added write queue
Sun Jul 21 15:46:47 CEST 2002 JWS: added sch_reg_W*_nr and sch_xbar_W*_nr
Mon Jul 22 15:07:09 CEST 2002 JWS: complete rewrite, along with other units
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update
Sun Jul 28 11:24:35 CEST 2002 JWS: added MAX_EU_LATENCY
Mon Jul 29 13:46:40 CEST 2002 JWS: split dec_latency into _w0 and _w1

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef SCHEDULER_H
#define SCHEDULER_H

#include <f-cpu_config.h>

#define true     1
#define false    0

/* inputs: */     
u8   sch_operand_1;        /* opcodes from fetcher */
u8   sch_operand_2;        /* used for detecting bypass */
u8   sch_operand_dst;
/* ----------- */
bool sch_use_r0;          /* from the decoder */
bool sch_use_r1;
bool sch_use_r2;
u8   sch_r0_reg_nr;       /* from the decoder */
u8   sch_r1_reg_nr;
u8   sch_r2_reg_nr;
u8   sch_latency_w0;      /* from the decoder (i.e. inc/dec=1 ) ( mov = 0 )*/
u8   sch_latency_w1;      /* latency for second EU output */
u8   sch_w0_port_nr;      /* from the decoder */
u8   sch_w1_port_nr;
u8   sch_w0_reg_nr;       /* from the decoder ( reg nr 0 = don't write )*/
u8   sch_w1_reg_nr;

/* outputs: */
u8   sch_bypass_r0;       /* bypass info to x-bar */
u8   sch_bypass_r1;       
u8   sch_bypass_r2;       
/* ----------- */
u8   sch_xbar_w0_reg_nr;  /* x-bar write control to x-bar */
u8   sch_xbar_w0_port_nr;
u8   sch_xbar_w1_reg_nr; 
u8   sch_xbar_w1_port_nr;
u8   sch_reg_w0_reg_nr;   /* register write control to registers */
u8   sch_reg_w1_reg_nr; 
// bool stalled;      /* pipeline is stalled (to everywhere !!) */

/* internal: */
bool sch_register_in_use     [MAX_EU_LATENCY+1][64]; /* level 0 and register 0 not used */
u8   sch_Q_write_to_reg_nr   [MAX_EU_LATENCY+1][ 2]; 
u8   sch_Q_write_from_port_nr[MAX_EU_LATENCY+1][ 2]; /* level 0 not used */

u8   sch_Q_write_to_reg_nr_min1[2];

u8   tmp_sch_operand_1;      /* delayed data from the fetcher */
u8   tmp_sch_operand_2;      /* be need this to detect a bypass */
u8   tmp_sch_operand_dst;    /* if there was a stall !!! */

/* problem : they should be enums !! */

static inline void decoder_cycle(void);

#endif /* SCHEDULER_H */
