/*
  f-cpu/c/scheduler/decoder.c
  c simulation of the F-CPU decoder unit
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
           19 July 2002 13:30
Sun Jul 21 11:02:19 CEST 2002 JWS: changed decoder_* into: dec_*
Sun Jul 21 12:55:37 CEST 2002 JWS: need to add queue info !!
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update
Fri Jul 26 11:08:55 CEST 2002 JWS: cleadn up, added rop2 and reg-move
Sun Jul 28 13:49:15 CEST 2002 JWS: added decoder_view.c
Sun Jul 28 13:49:15 CEST 2002 JWS: added display_color and display_normal
Mon Jul 29 13:46:40 CEST 2002 JWS: split dec_latency into _w0 and _w1

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

/* defines the constants, inputs and outputs : */
#include <decoder.h>

void decoder_view(void){
  printf("decoder inputs:\n");
  printf("dec_instr =%s%8lX%s ",      display_color, dec_instr,       display_normal );
  printf("dec_operand_2 =%s%2i%s ",   display_color, dec_operand_2,   display_normal );
  printf("dec_operand_1 =%s%2i%s ",   display_color, dec_operand_1,   display_normal );
  printf("dec_operand_dst =%s%2i%s\n",display_color, dec_operand_dst, display_normal );
  printf("decoder outputs:\n");
  printf("dec_latency_w0= %s%2i%s ",  display_color, dec_latency_w0,  display_normal );
  printf("dec_latency_w1= %s%2i%s ",  display_color, dec_latency_w1,  display_normal );
  printf("dec_imm       = %s%4X%s\n", display_color, dec_imm,         display_normal );
  printf("dec_use_r0    = %s ",       display_bool[dec_use_r0] );
  printf("dec_use_r1 = %s ",          display_bool[dec_use_r1] );
  printf("dec_use_r2 = %s\n",         display_bool[dec_use_r2] );
  printf("dec_r0_reg_nr = %s%2i%s ",  display_color, dec_r0_reg_nr,   display_normal );
  printf("dec_r1_reg_nr = %s%2i%s ",  display_color, dec_r1_reg_nr,   display_normal );
  printf("dec_r2_reg_nr = %s%2i%s\n", display_color, dec_r2_reg_nr,   display_normal );
  printf("dec_read_to_EU_nr = %s%2i%s\n",display_color, dec_read_to_EU_nr, display_normal );
  printf("dec_r0_port_nr= %s%2i%s ",  display_color, dec_r0_port_nr,  display_normal );
  printf("dec_r1_port_nr= %s%2i%s ",  display_color, dec_r1_port_nr,  display_normal );
  printf("dec_r2_port_nr= %s%2i%s\n", display_color, dec_r2_port_nr,  display_normal );
  printf("dec_w0_reg_nr = %s%2i%s ",  display_color, dec_w0_reg_nr,   display_normal );
  printf("dec_w1_reg_nr = %s%2i%s\n", display_color, dec_w1_reg_nr,   display_normal );
  printf("dec_w0_port_nr= %s%2i%s ",  display_color, dec_w0_port_nr,  display_normal );
  printf("dec_w1_port_nr= %s%2i%s\n", display_color, dec_w1_port_nr,  display_normal );
  printf("flags and modes outputs:\n");
  printf("dec_size= %s%2X%s    ",     display_color, dec_size, display_normal );
  printf("dec_simd= %s ",             display_bool[dec_simd] );
  printf("dec_high= %s\n",             display_bool[dec_high] );
  printf("dec_ADD = %s ",             display_bool[dec_ADD] );
  printf("dec_SUB = %s ",             display_bool[dec_SUB] );
  printf("dec_INC = %s ",             display_bool[dec_INC] );
  printf("dec_DEC = %s\n",            display_bool[dec_DEC] );
  printf("dec_rop2_function = %s%2X%s ", display_color, dec_rop2_function, display_normal );
  printf("dec_rop2_mode = %s%2X%s\n", display_color, dec_rop2_mode,   display_normal );
  /* dec_rop2_combine_size ?? */
}


static inline void decoder_cycle (void) {

u8   opcode;
bool use_imm16; /* true=16bit false=8bit */
u16  dec_imm8;
u16  dec_imm16;

  /* decode flags and imm: (this is just wires in hardware !? ) */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

  dec_imm8  = (dec_instr & 0x000FF000LL) >> 12 ;
  dec_imm16 = (dec_instr & 0x003FFFC0LL) >> 6 ;
  use_imm16 = false;

/*
#define     IEEE_FLAG_POS  0  // 1 bit  
#define     SIZE_FLAG_POS 22  // 2 bits 
#define     SIMD_FLAG_POS 21  // 1 bit  
#define   ENDIAN_FLAG_POS 21  // 1 bit  
#define JMP_NCON_FLAG_POS 21  // 1 bit  
#define SATURATE_FLAG_POS 19  // 1 bit  
#define    CARRY_FLAG_POS 18  // 1 bit  
#define   STREAM_FLAG_POS 18  // 3 bits 
#define JMP_COND_FLAG_POS 19  // 2 bits 
#define     SIGN_FLAG_POS 19  // 1 bit  
#define MOV_COND_FLAG_POS 11  // 2 bits 
#define MOV_NCON_FLAG_POS 10  // 1 bit  
#define     HIGH_FLAG_POS 18  // 1 bit  
*/

  dec_size     = (dec_instr >>     SIZE_FLAG_POS) & 0x03;   /* 2 bits */
  dec_simd     = (dec_instr >>     SIMD_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_endian   = (dec_instr >>   ENDIAN_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_satutare = (dec_instr >> SATURATE_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_carry    = (dec_instr >>    CARRY_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_stream   = (dec_instr >>   STREAM_FLAG_POS) & 0x07;   /* 3 bits */
  dec_jmp_cond = (dec_instr >> JMP_COND_FLAG_POS) & 0x03;   /* 2 bits */
  dec_jmp_ncond= (dec_instr >> JMP_NCON_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_mov_cond = (dec_instr >> MOV_COND_FLAG_POS) & 0x03;   /* 2 bits */
  dec_mov_ncond= (dec_instr >> MOV_NCON_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_sign     = (dec_instr >>     SIGN_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_high     = (dec_instr >>     HIGH_FLAG_POS) & 0x01;   /* 1 bit  */

  /* decode instruction: */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  opcode = (dec_instr & 0xFF000000LL) >> 24 ;

  dec_r0_reg_nr = dec_operand_1;   /* dec_use_r0 = false if we don't use it */
  dec_r1_reg_nr = dec_operand_2;   /* dec_use_r1 = false if we don't use it */
  dec_r2_reg_nr = dec_operand_dst; /* dec_use_r2 = false if we don't use it */
  dec_use_r0    = false;           /* "use" = "check for bypass" !! */ 
  dec_use_r1    = false;
  dec_use_r2    = false;
  dec_w0_reg_nr = 0;
  dec_w1_reg_nr = 0;
  dec_w0_port_nr= 0;  /* don't need to clear this */
  dec_w1_port_nr= 0;  /* don't need to clear this */
  dec_latency_w0= 0;
  dec_latency_w1= 0;
  dec_read_to_EU_nr = 0; /* = none (for nop and reg move ??) */
  dec_r0_port_nr= PORT_READ_FROM_REGISTER;
  dec_r1_port_nr= PORT_READ_FROM_REGISTER;
  dec_r2_port_nr= PORT_READ_FROM_REGISTER;

  dec_ADD       = false;
  dec_SUB       = false;
  dec_INC       = false;
  dec_DEC       = false;
  dec_rop2_function = 0;
  dec_rop2_mode = ROP2_DIRECT_MODE; /* =0 */
  dec_rop2_combine_size = 0;

  switch ( opcode ) {
    case OP_ADD:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_ADD           = true;
      dec_read_to_EU_nr = EU_type_ASU;
      dec_use_r0        = true;
      dec_use_r1        = true;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ASU;
      if ( dec_size == 1 ){   /* 01 is a byte on 64 bit F=CPU ??? */
        dec_latency_w0  = 1;
      }else{
        dec_latency_w0  = 2;
      }
      if (dec_carry){
        dec_w1_reg_nr   = dec_operand_dst +1;
        dec_w1_port_nr  = PORT_WRITE_FROM_ASU2;
        dec_latency_w1  = dec_latency_w0;
      }
    break;
    case OP_ADDI:       /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_ADD           = true;
      dec_read_to_EU_nr = EU_type_ASU;
      dec_use_r0        = true;
      dec_r1_port_nr    = PORT_READ_FROM_IMMEDIATE;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ASU;
      if ( dec_size == 1 ){   /* 01 is a byte on 64 bit F=CPU ??? */
        dec_latency_w0  = 1;
      }else{
        dec_latency_w0  = 2;
      }
      if (dec_carry){
        dec_w1_reg_nr   = dec_operand_dst +1;
        dec_w1_port_nr  = PORT_WRITE_FROM_ASU2;
        dec_latency_w1  = dec_latency_w0;
      }
    break;
    case OP_SUB:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_SUB           = true;
      dec_read_to_EU_nr = EU_type_ASU;
      dec_use_r0        = true;
      dec_use_r1        = true;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ASU;
      if ( dec_size == 1 ){   /* 01 is a byte on 64 bit F=CPU ??? */
        dec_latency_w0  = 1;
      }else{
        dec_latency_w0  = 2;
      }
      if (dec_carry){
        dec_w1_reg_nr   = dec_operand_dst +1;
        dec_w1_port_nr  = PORT_WRITE_FROM_ASU2;
        dec_latency_w1  = dec_latency_w0;
      }
    break;
    case OP_SUBI:       /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_SUB           = true;
      dec_read_to_EU_nr = EU_type_ASU;
      dec_use_r0        = true;
      dec_r1_port_nr    = PORT_READ_FROM_IMMEDIATE;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ASU;
      if ( dec_size == 1 ){   /* 01 is a byte on 64 bit F=CPU ??? */
        dec_latency_w0  = 1;
      }else{
        dec_latency_w0  = 2;
      }
      if (dec_carry){
        dec_w1_reg_nr   = dec_operand_dst +1;
        dec_w1_port_nr  = PORT_WRITE_FROM_ASU2;
        dec_latency_w1  = dec_latency_w0;
      }
    break;
    case OP_AND:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
    case OP_OR:         /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
    case OP_XOR:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_read_to_EU_nr = EU_type_ROP2;
      if ( opcode== OP_AND ) dec_rop2_function = FUNCTION_AND;
      if ( opcode== OP_OR  ) dec_rop2_function = FUNCTION_OR;
      if ( opcode== OP_XOR ) dec_rop2_function = FUNCTION_XOR;
      dec_use_r0        = true;
      dec_use_r1        = true;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ROP2;
      dec_latency_w0    = 1;
      if (dec_rop2_mode != ROP2_DIRECT_MODE) {
        dec_use_r2        = true;
        dec_r2_reg_nr     = dec_operand_dst ^ 1;  /* please check !! */
      }
    break;
    case OP_MOV:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_read_to_EU_nr = EU_type_MOV;                   /* a 0 latency EU */
              /* we could just add an extra output port to an existing EU, */
              /* so we don't need a seperate 0-cycle unit !!               */
      dec_use_r0        = true;                 /* i.e.: check for bypass! */
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_MOV;       /* (the 0 latency EU) */
      dec_latency_w0    = 0;      /* put it strait at the end of the queue */
    break;
    case OP_MUL:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_read_to_EU_nr = EU_type_IMU;
      dec_use_r0        = true;
      dec_use_r1        = true;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_IMU0;
      if (dec_size == 0) dec_latency_w0 = 6;
      if (dec_size == 1) dec_latency_w0 = 5;
      if (dec_size == 2) dec_latency_w0 = 4;
      if (dec_size == 3) dec_latency_w0 = 3;
      if ( dec_high ) {
        dec_w1_reg_nr     = dec_operand_dst+1;
        dec_w1_port_nr    = PORT_WRITE_FROM_IMU1;
        if (dec_size == 0) dec_latency_w1 = 6;
        if (dec_size == 1) dec_latency_w1 = 5;
        if (dec_size == 2) dec_latency_w1 = 5;
        if (dec_size == 3) dec_latency_w1 = 4;
      }
    break;

    /* -- add more here! -- */


    case OP_NOP:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      /* ok, that's easy */
    break;
    default:            /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      /* exception !! (for now: ignore) */
    break;
  }

  /* correct imm if it's 8 bit: */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( use_imm16 ) {
    dec_imm = dec_imm16;
  }else{
    dec_imm = dec_imm8;
  }

}
