/* 
  f-cpu/c/fcpusim/fcpusim.c - F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
           19 July 2002 13:30
    Jul 21 02:26:00 CEST 2002 JWS: extracted from old fcpusim.c
Sun Jul 21 11:02:19 CEST 2002 JWS: cganged decoder_* into: dec_*
Sun Jul 21 12:06:17 CEST 2002 JWS: added "notes" view
Sun Jul 21 16:05:09 CEST 2002 JWS: wrong keys won't couse a redraw.
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update
Fri Jul 26 13:25:35 CEST 2002 JWS: removed notes_view, added rop2_view
Sun Jul 28 11:39:34 CEST 2002 JWS: added display_color and display_normal
                                   to print_true_false.
Mon Jul 29 10:17:09 CEST 2002 JWS: removed: g(); n(); print_true_false();

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

#include <toplevel.c>
#include <getkey.c>

#include <mem_view.c>
#include <jaap_view.c>

void status_view(void){
  printf("________________________________________");
  printf("_______________________________________\n");
  printf("status after cycle %s%d%s :   ", display_color, cycle_counter, display_normal );
  printf("(during the next cycle, \"stalled\" will be: %s)\n", display_bool[stalled] );
  switch ( view ) {
    case 'm': mem_view();       break;
    case 'f': fetcher_view();   break;
    case 'd': decoder_view();   break;
    case 'r': registers_view(); break;
    case 's': scheduler_view(); break;
    case 'x': xbar_view();      break;
    case 'a': eu_asu_view();    break;
    case '2': eu_rop2_view();   break;
    case 'i': eu_inc_view();    break;
    case 'u': eu_imu_view();    break;
    case 'j': jaap_view();    break;
    default: break;
  }
}

void menu(void){
  int do_next_cycle;
  int redraw;
  redraw = 1;
  quit_fcpusim = 0;
  do {
    if (redraw){    
      status_view();
      printf("Mem Fetcher Decoder Registers Scheduler ");
      printf("Xbar Asu rop2 Inc imU enter=cycle Quit ");
      /*  "secret keys": <space> = no vieuw,    'j' = jaap's view  */
    }    
    c = getkey();
    printf("\n");
    do_next_cycle = 0;
    redraw = 0;
    if  (c==10 )           { do_next_cycle = 1; redraw = 1;}
    if ((c=='m')|(c=='M')) { view = 'm'; redraw = 1;} /* memory */
    if ((c=='f')|(c=='F')) { view = 'f'; redraw = 1;} /* fetcher */
    if ((c=='d')|(c=='D')) { view = 'd'; redraw = 1;} /* decoder */
    if ((c=='r')|(c=='R')) { view = 'r'; redraw = 1;} /* registers */
    if ((c=='s')|(c=='S')) { view = 's'; redraw = 1;} /* scheduler */
    if ((c=='x')|(c=='X')) { view = 'x'; redraw = 1;} /* xbar */
    if ((c=='a')|(c=='A')) { view = 'a'; redraw = 1;} /* asu */
    if  (c=='2')           { view = '2'; redraw = 1;} /* rop2 */
    if ((c=='i')|(c=='I')) { view = 'i'; redraw = 1;} /* inc */
    if ((c=='u')|(c=='U')) { view = 'u'; redraw = 1;} /* imu */
    if ((c=='j')|(c=='J')) { view = 'j'; redraw = 1;} /* jaap's view */
    if  (c==' ')           { view = ' '; redraw = 1;} /* no view */
    if ((c=='q')|(c=='Q')) { quit_fcpusim = 1; do_next_cycle = 1; }
  } while (do_next_cycle==0);
}


int main(int argc, char **argv) {

  printf("\n\n\n\n\n");
  printf("       F-CPU Simulator      (GNU General Public License)\n");
  printf(" (c) Yann GUIDON (YG) whygee@f-cpu.org\n");
  printf(" (c) Jaap Stolk (JWS) jwstolk@yahoo.com\n");
  printf(" (c) Thomas Geroudet  gertom_fcpu@yahoo.fr\n");
  printf("\n");
  printf("use: fcpusim <binary_filename>  ( or just: fcpusim )\n");
  printf("\n");
  printf("WARNING: only some parts work !!  read jaap.txt and source :-) \n");

  if ( argc > 2){
    printf("WARNING: to many command-line arguments!\n");
  }

  /* clear memory: */
  for(mem_cnt=0; mem_cnt<10240; mem_cnt++){
    sim_memory[mem_cnt]=0;
  }

  /* load (code) memory img from file: */
  if ( argc > 1){
    read=fopen(argv[1], "rb");
    if (read == NULL){
      printf("WARNING: can\'t open binary input file: \"%s\"\n",argv[1]);
    }else{
      printf("loading binary input file: \"%s\" ... ",argv[1]);
      mem_cnt = 0;
      while( (fread(&sim_memory[mem_cnt],1,1,read) == 1) && ( (mem_cnt+1)<SIM_MEMORY_SIZE ) ){
        mem_cnt ++;
      }
      fclose(read);
      printf("... %i bytes read from file.\n",mem_cnt);
      if ( (mem_cnt+1) == SIM_MEMORY_SIZE ){
        printf("WARNING: file to long !\n");
      }

    }
  }

  /* cycle_counter is NOT used by the simulator ! */
  cycle_counter=0;

  /* clear pipeline stages, etc. */
  printf("starting BIST ... "); 
  bist_active = true;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  bist_active = false;
  printf("... Done BIST.\n");

  /* fill the registers by hand, as we do not have a LOAD yet.. */
  /* (this will not take a cycle, as no cycle is simulated) */
  register_value[10] = 0x0012312312312312ll;  
  register_value[60] = 0x0000000000000001ll;  
  register_value[61] = 0x0000000100000000ll;  
  register_value[62] = 0x0000000000000003ll;  

  /* for winograd dct: */
  register_value[41] = 46341;  // = m1 =  cos(4pi/16)                * 0x10000
  register_value[42] = 25080;  // = m2 =  cos(6pi/16)                * 0x10000
  register_value[43] = 35468;  // = m3 = (cos(2pi/16) - cos(6pi/16)) * 0x10000
  register_value[44] = 85626;  // = m4 = (cos(2pi/16) + cos(6pi/16)) * 0x10000
  register_value[20] = 200;    // input a0..a7
  register_value[21] = 128;
  register_value[22] =  10;
  register_value[23] =  50;
  register_value[24] =  60;
  register_value[25] = 255;
  register_value[26] =  30;
  register_value[27] = 184;

  register_value[20] = 100;    // input a0..a7
  register_value[21] =  28;
  register_value[22] =  10;
  register_value[23] =  50;
  register_value[24] =  60;
  register_value[25] = 115;
  register_value[26] =  30;
  register_value[27] =  84;

  /* keep running !: */
  do {
    simulate_one_cycle(); cycle_counter++;
    menu();
  } while (quit_fcpusim == 0);

  return 0; /* nothing can go wrong :-) */
}
