/* 
  f-cpu/c/eu_inc/eu_inc.c - INC Execution Unit for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
           19 July 2002 13:30
Sun Jul 21 11:56:29 CEST 2002 jws: the xbar stage can now be stalled
Fri Jul 26 12:54:38 CEST 2002 JWS: sch_stalled -> stalled

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
--
--   /---------------- inc_INC     > std_ulogic
--   | /-------------- inc_DEC     > std_ulogic
--   | | /------------ inc_ABS     > std_ulogic
--   | | | /---------- inc_NEG     > std_ulogic
--   | | | | /-------- inc_LSB0    > std_ulogic
--   | | | | | /------ inc_LSB1    > std_ulogic
--   | | | | | | /---- inc_simd    > std_ulogic
--   | | | | | | | /-- inc_size    > SIMD_8 / SIMD_16 / SIMD_32 / SIMD_MAX 
--   | | | | | | | |
--   v v v v v v v v
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %%                           Xbar stage                             %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

               the unit can be stalled here

--   | | | | | | | |   t_inc_INC
--   | | | | | | | |   t_inc_DEC
--   | | | | | | | |   t_inc_ABS
--   | | | | | | | |   t_inc_NEG
--   | | | | | | | |   t_inc_LSB0
--   | | | | | | | |   t_inc_LSB1                           inc_in
--   | | | | | | | |   t_inc_simd                              |
--   v v v v v v v v   t_inc_size                              v
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %%                           INC EU stage                           %%
-- %%            do: INC / DEC / ABS / NEG / LSB0 / LSB1               %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--                                                             |
--                                                             v
--                                                          inc_out
--
*/

/* defines the constants, inputs and outputs : */
#include <eu_inc.h>



void eu_inc_view(void){
  printf("INC EU inputs:\n");
  printf(  "inc_in     = "); g(); printf("%16llX",inc_in); n();
  /* add 2nd input ?? (imm) */
  printf("\ninc_INC    = "); print_true_false(inc_INC);
  printf(" (t_inc_INC  = "); print_true_false(t_inc_INC);
  printf(")\n");
  printf(  "inc_DEC    = "); print_true_false(inc_DEC);
  printf(" (t_inc_DEC  = "); print_true_false(t_inc_DEC);
  printf(")\n");
  printf(  "inc_ABS    = "); print_true_false(inc_ABS);
  printf(" (t_inc_ABS  = "); print_true_false(t_inc_ABS);
  printf(")\n");
  printf(  "inc_NEG    = "); print_true_false(inc_NEG);
  printf(" (t_inc_NEG  = "); print_true_false(t_inc_NEG);
  printf(")\n");
  printf(  "inc_LSB0   = "); print_true_false(inc_LSB0);
  printf(" (t_inc_LSB0 = "); print_true_false(t_inc_LSB0);
  printf(")\n");
  printf(  "inc_LSB1   = "); print_true_false(inc_LSB1);
  printf(" (t_inc_LSB1 = "); print_true_false(t_inc_LSB1);
  printf(")\n");
  printf(  "inc_simd   = "); print_true_false(inc_simd);
  printf(" (t_inc_simd = "); print_true_false(t_inc_simd);
  printf(")\n");
  printf(  "inc_size   = "); g(); printf("%d",inc_size); n();
  printf("\n");

  printf("INC EU outputs:\n");
  printf(  "inc_out    = "); g(); printf("%16llX",inc_out); n();
  printf(")\n");

}





static inline void eu_inc_cycle(void) {

  UMAX inc_result;

  /* INC EU stage (run this BEFORE the Xbar stage !) */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if (t_inc_INC){
    inc_result = t_inc_in + 1;
  }else{

    if (t_inc_DEC){
      inc_result = t_inc_in - 1;
    }else{

      if (t_inc_ABS){
        if (t_inc_in & 0x1000000000000000LL) {
          inc_result =  ( ~t_inc_in ) + 1;
        }else{
          inc_result =     t_inc_in;
        }
      }else{

        if (t_inc_NEG){
          inc_result = ~t_inc_in;
        }else{

          if (t_inc_LSB0){
            inc_result = t_inc_in & 0x0000000000000001LL;
          }else{

            if (t_inc_LSB1){
              if (t_inc_in & 0x0000000000000010LL) {
                inc_result = 0x0000000000000001LL;
              }
            }
          }
        }
      }
    }
  }
  /* SIMD version not yet implemented !! */
  /* wrap around on inc/dec ? */
  inc_out = inc_result;

  /* Xbar stage */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( !stalled ) {
    /* needed to lower fanout of NEG signal, witch we don't simulate */
    t_inc_INC  = inc_INC;
    t_inc_DEC  = inc_DEC;
    t_inc_ABS  = inc_ABS;
    t_inc_NEG  = inc_NEG;
    t_inc_LSB0 = inc_LSB0;
    t_inc_LSB1 = inc_LSB1;
    t_inc_simd = inc_simd;
    t_inc_size = inc_size;
  }else{
    t_inc_INC  = false;
    t_inc_DEC  = false;
    t_inc_ABS  = false;
    t_inc_NEG  = false;
  }
}
