/*
  f-cpu/c/eu_asu/eu_asu.h - ASU Execution Unit ports for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
           19 July 2002 13:30
Sun Jul 28 12:36:39 CEST 2002 JWS: cleaned up

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#ifndef EU_ASU_H
#define EU_ASU_H

#include <f-cpu_config.h>

#define SIMD_MAX 0 /* move this to configure ! */
#define SIMD_32  1
#define SIMD_16  2
#define SIMD_8   3
#define true     1
#define false    0

/* inputs: */
UMAX asu_in_A;   /* the 2 operands */
UMAX asu_in_B;
bool asu_ADD;
bool asu_SUB;
bool asu_wrcarry;/* write_carry to next register */
bool asu_simd;
u8   asu_size;

/* outputs : */
UMAX asu_out0;    /* the result */
UMAX asu_out1;    /* the carry */

/* internal: */
/*
bool t_asu_ADD;
bool t_asu_SUB;
bool t_asu_wrcarry; write_carry to next register 
bool t_asu_simd;
u8   t_asu_size;
*/
UMAX tt_asu_in_A; /*mayby some more bits for carrys etc. */
UMAX tt_asu_in_B; /*mayby some more bits for carrys etc. */
bool tt_asu_ADD;
bool tt_asu_SUB;
bool tt_asu_wrcarry;
bool tt_asu_simd;
u8   tt_asu_size;

static inline void eu_asu_cycle (void);

#endif /* EU_ASU_H */
