/* 
  f-cpu/c/eu_asu/eu_asu.c - ASU Execution Unit for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 
           19 July 2002 13:30
Sun Jul 21 11:57:06 CEST 2002 JWS: the xbar stage can now be stalled
Fri Jul 26 12:54:38 CEST 2002 JWS: sch_stalled -> stalled
Sun Jul 28 11:40:25 CEST 2002 JWS: added eu_asu_view
Sun Jul 28 11:40:25 CEST 2002 JWS: added display_color and display_normal

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
--
--   /---------- asu_AND     > std_ulogic
--   | /-------- asu_SUB     > std_ulogic
--   | | /------ asu_wrcarry > std_ulogic
--   | | | /---- asu_simd    > std_ulogic
--   | | | | /-- asu_size    > SIMD_8 / SIMD_16 / SIMD_32 / SIMD_MAX
--   | | | | |
--   v v v v v

     | | | | |   
--   | | | | |   
--   | | | | |                          asu_in_A       asu_in_B
--   | | | | |                             |              |
--   v v v v v                             v              v
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %%                        ASU EU stage 1                            %%
-- %%                   do: 8 bit SIMD ADD / SUB  (MAC?)               %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--   | | | | |   tt_asu_ADD      :         |              |           |
--   | | | | |   tt_asu_SUB      :         |              |           |
--   | | | | |   tt_asu_wrcarry  ?    tt_asu_in_A    tt_asu_in_B      |
--   | | | | |   tt_asu_simd     :         |              |           |
--   v v v v v   tt_asu_size     v         v              v           |
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% |
-- %%               ASU EU stage 2 (only for > 8bit !)             %% |
-- %%      finish 16 / 32 bit SIMD and 64 bit ADD / SUB (MAC?)     %% |
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% |
--                           |                                    |   |
--                           v                                    v   v
--                     asu_carray_out                            asu_out
-- tt_asu_wrcarry is not needed in the EU !!, carry is always computed
-- the instruction decoder must instruct the xbar to not write the carry
--
-- if non-simd+8_bit posible ??
-- add reset signal ??
-- FIXME: we need to enable / disable each stage for writeing to ASU-out
--        to prevent write conflict. ?? (look at SIMD_8bit signal!?)
--     Q: Can we check the high bits for 0, and do 64 bit in 1 stage ?
--        ( 2 - 4 = -2   in one stage ? )
*/

/* defines the constants, inputs and outputs : */
#include <eu_asu.h>


void eu_asu_view(void){
  printf("ASU EU inputs:\n");
  printf("asu_in_A   = %s%16llX%s  ", display_color, asu_in_A, display_normal );
  printf("asu_in_B   = %s%16llX%s\n", display_color, asu_in_B, display_normal );
  printf("asu_ADD    = %s  ",         display_bool[asu_ADD    ] );
  printf("(tt_asu_ADD= %s)\n",        display_bool[tt_asu_ADD ] );
  printf("asu_SUB    = %s  ",         display_bool[asu_SUB    ] );
  printf("(tt_asu_SUB= %s)\n",        display_bool[tt_asu_SUB ] );
  printf("asu_wrcarry= %s\n",         display_bool[asu_wrcarry] );
  printf("asu_simd   = %s\n",         display_bool[asu_simd   ] );
  printf("asu_size   = %s%d%s\n",     display_color, asu_size, display_normal );
  printf("ASU EU outputs:\n");
  printf("asu_out0   = %s%16llX%s  ", display_color, asu_out0, display_normal );
  printf("asu_out1   = %s%16llX%s\n", display_color, asu_out1, display_normal );
}


static inline void eu_asu_cycle(void) {

UMAX asu_result;

  /* ASU EU stage 2 (only for > 8bit !) (run this BEFORE stage 1!) */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if (tt_asu_ADD){
    asu_result = tt_asu_in_A + tt_asu_in_B;
  }else{

    if (tt_asu_SUB){
      asu_result = tt_asu_in_A - tt_asu_in_B;
    }

  }

  if (tt_asu_ADD | tt_asu_SUB){
    asu_out0 = asu_result;
    asu_out1 = 0; /* carry not implemented !! */
  }
  /* SIMD version not yet implemented !! */


  /* ASU EU stage 1 */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if (asu_size==SIMD_8){
    /* do it all in one stage, and skip the next: */
    if (asu_ADD){
      asu_result  = tt_asu_in_A + tt_asu_in_B;
      tt_asu_ADD = false;  /* skip the next stage */
    }
    if (asu_SUB){
      asu_result  = tt_asu_in_A - tt_asu_in_B;
      tt_asu_SUB = false;  /* skip the next stage */
    }
    if (asu_ADD | asu_SUB){
      asu_out0 = asu_result;
      asu_out1 = 0; /* carry not implemented !! */
    }
  }else{
    /* we need two stages to do this: */
    tt_asu_in_A   = asu_in_A;
    tt_asu_in_B   = asu_in_B;
    tt_asu_ADD    = asu_ADD;
    tt_asu_SUB    = asu_SUB;
    tt_asu_wrcarry= asu_wrcarry;
    tt_asu_simd   = asu_simd;
    tt_asu_size   = asu_size;
  }

  if ( !(asu_ADD | asu_SUB) ){
      tt_asu_ADD = false;  /* clear ASU pipeline */
      tt_asu_SUB = false;  /* clear ASU pipeline */
  }

  /* ASU EU xbar stage */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  /*
  if ( !stalled ) {
    t_asu_ADD    = asu_ADD;
    t_asu_SUB    = asu_SUB;
    t_asu_wrcarry= asu_wrcarry;
    t_asu_simd   = asu_simd;
    t_asu_size   = asu_size;
  }else{
    t_asu_ADD    = false;
    t_asu_SUB    = false;
  }
  */


}
