/*
  f-cpu/c/eu_rop2/eu_rop2.c - ROP2 Execution Unit for the F-CPU
  Copyright (C) 2000-2002 Yann GUIDON (whygee@f-cpu.org)
  version Sun Jul  7 00:40:35 CEST 2002 : very dumb, lacks global definitions
  version Sun Jul 21 10:32:00 CEST 2002 : a bit better...
  version Sat Jul 27 05:46:13 CEST 2002 : added eu_rop2_view
  version Sat Jul 27 20:46:12 CEST 2002 : renamed function, added tmp_'s

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

/* defines the constants, inputs and outputs : */
#include <eu_rop2.h>

void eu_rop2_view(void){
  /* ROP2_Combine_size is missing !!*/
  printf("ROP2 EU inputs:\n");
  printf("ROP2 function = %s%d%s, mode = %s%d%s\n",
    display_color, ROP2_function, display_normal,
    display_color, ROP2_mode,     display_normal);
  /* internal _tmp's only for debugging...  */
  printf("tmp_ROP2 function = %s%d%s, mode = %s%d%s\n",
    display_color, tmp_ROP2_function, display_normal,
    display_color, tmp_ROP2_mode,     display_normal);
  printf("ROP2_in_A = %s%.16llX%s\n", display_color, ROP2_in_A, display_normal);
  printf("ROP2_in_B = %s%.16llX%s\n", display_color, ROP2_in_B, display_normal);
  printf("ROP2 EU outputs:\n");
  printf("ROP2_in_C = %s%.16llX%s\n", display_color, ROP2_in_C, display_normal);
}

static inline void eu_rop2_cycle (void) {

  UMAX ROP2_result;

  /* the ROP2 cycle */
  if (tmp_ROP2_mode == ROP2_MUX_MODE) {
    ROP2_out = ( ROP2_in_B &  ROP2_in_C )
             | ( ROP2_in_A & ~ROP2_in_C );
  }
  else {
    switch (tmp_ROP2_function) {
      case FUNCTION_AND:  ROP2_result =   ROP2_in_A &  ROP2_in_B;  break;
      case FUNCTION_ANDN: ROP2_result =   ROP2_in_A & ~ROP2_in_B;  break;
      case FUNCTION_XOR:  ROP2_result =   ROP2_in_A ^  ROP2_in_B;  break;
      case FUNCTION_OR:   ROP2_result =   ROP2_in_A |  ROP2_in_B;  break;
      case FUNCTION_NOR:  ROP2_result = ~(ROP2_in_A |  ROP2_in_B); break;
      case FUNCTION_XNOR: ROP2_result = ~(ROP2_in_A ^  ROP2_in_B); break;
      case FUNCTION_ORN:  ROP2_result =   ROP2_in_A | ~ROP2_in_B;  break;
      case FUNCTION_NAND: ROP2_result = ~(ROP2_in_A &  ROP2_in_B); break;
    }

    if (tmp_ROP2_mode == ROP2_OR_MODE) {
      /* OR combination : */
      ROP2_result |= ROP2_result >> 1;
      ROP2_result |= ROP2_result >> 2;
      ROP2_result |= ROP2_result >> 4;
    }
    if (tmp_ROP2_mode == ROP2_AND_MODE) {
      /* AND combination : */
      ROP2_result &= ROP2_result >> 1;
      ROP2_result &= ROP2_result >> 2;
      ROP2_result &= ROP2_result >> 4;
    }
    if (tmp_ROP2_mode != ROP2_DIRECT_MODE) {
      /* mask useless bits out */
      ROP2_result &= 0x0101010101010101LL;
      /* expand the bit result to a byte */
      ROP2_result |= ROP2_result << 1;
      ROP2_result |= ROP2_result << 2;
      ROP2_result |= ROP2_result << 4;
    }

    ROP2_out = ROP2_result;
  }

  /* the Xbar cycle */
  if ( !stalled ) {
    tmp_ROP2_function    = ROP2_function;
    tmp_ROP2_mode        = ROP2_mode;
    tmp_ROP2_Combine_size= ROP2_Combine_size;
  }else{
    tmp_ROP2_function    = 0; /* can't we disable it ?? */
    tmp_ROP2_mode        = 0;
    tmp_ROP2_Combine_size= 0;
  }

}
