/*
  f-cpu/c/scheduler/decoder.h - decoder ports for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com

  version:
           19 July 2002 13:30
Sun Jul 21 11:02:19 CEST 2002 JWS: cganged decoder_* into: dec_*
Sun Jul 21 12:42:49 CEST 2002 JWS: added dec_need_W0_nr_src
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef DECODER_H
#define DECODER_H

#include <f-cpu_config.h>

#define true     1
#define false    0

/* inputs: */
u32  dec_instr;       /* from fetcher */
u8   dec_operand_2;   /* from fetcher */
u8   dec_operand_1;   /* from fetcher */
u8   dec_operand_dst; /* from fetcher */

/* outputs : */
bool dec_use_r0;      /* to scheduler, read r0 from registers */
bool dec_use_r1;      /* to scheduler, read r1 from registers */
bool dec_use_r2;      /* to scheduler, read r2 from registers */
                      /* used for scoreboard, ONLY if read from registes ! */
u8   dec_r0_reg_nr;   /* to xbar?? AND scheduler */
u8   dec_r1_reg_nr;   /* to xbar?? AND scheduler */
u8   dec_r2_reg_nr;   /* to xbar?? AND scheduler */

u8   dec_r0_port_nr; /* to xbar */  /* and scheduler ?? */
u8   dec_r1_port_nr; /* to xbar */  /* and scheduler ?? */
u8   dec_r2_port_nr; /* to xbar */  /* and scheduler ?? */

u8   dec_w0_reg_nr;  /* to scheduler, for write queue */
u8   dec_w1_reg_nr;
u8   dec_w0_port_nr;
u8   dec_w1_port_nr;
bool dec_ADD;        /* to eu_asu */
bool dec_SUB;        /* to eu_asu */
bool dec_INC;        /* to eu_inc */
bool dec_DEC;        /* to eu_inc */
u8   dec_read_to_EU_nr; /* to xbar */
u8   dec_cycles;
u16  dec_imm;        /* to xbar */

/* problem : they should be enums !! */

static inline void decoder_cycle(void);

#endif /* DECODER_H */
