/*
  f-cpu/c/scheduler/decoder.c
  c simulation of the F-CPU decoder unit
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com

  version:
           19 July 2002 13:30
Sun Jul 21 11:02:19 CEST 2002 JWS: cganged decoder_* into: dec_*
Sun Jul 21 12:55:37 CEST 2002 JWS: need to add queue info !!
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

/* defines the constants, inputs and outputs : */
#include <decoder.h>

static inline void decoder_cycle (void) {

u8   opcode;
bool imm_8bit;

  /* set imm: */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  dec_imm = (dec_instr & 0x003FFFC0LL) >> 6 ;


  /* decode instruction: */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  opcode = (dec_instr & 0xFF000000LL) >> 24 ;

  imm_8bit      = false;
  dec_r0_reg_nr = 0;
  dec_r1_reg_nr = 0;
  dec_r2_reg_nr = 0;
  dec_use_r0    = false;
  dec_use_r1    = false;
  dec_use_r2    = false;
  dec_w0_reg_nr = 0;
  dec_w1_reg_nr = 0;
  dec_w0_port_nr= 0; /* don't need to clear this */
  dec_w1_port_nr= 0; /* don't need to clear this */
  dec_cycles    = 0;
  dec_read_to_EU_nr = 0; /* = none (for nop and reg move ??) */
  dec_ADD = false;
  dec_SUB = false;
  dec_INC = false;
  dec_DEC = false;

  dec_r0_port_nr = PORT_READ_FROM_REGISTER;
  dec_r1_port_nr = PORT_READ_FROM_REGISTER;
  dec_r2_port_nr = PORT_READ_FROM_REGISTER;


  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( opcode==OP_INC ) {
  }

  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( opcode==OP_DEC ) {
  }

  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( opcode==OP_ADD ) {
    dec_ADD       = true;
    dec_read_to_EU_nr = EU_type_ASU;
    dec_use_r0    = true;
    dec_use_r1    = true;
    dec_r0_reg_nr = dec_operand_1;
    dec_r1_reg_nr = dec_operand_2;
    dec_w0_reg_nr = dec_operand_dst ^ 0x01;
    dec_w0_port_nr= PORT_WRITE_FROM_ASU;
    dec_cycles    = 2;       /* 1 cycle for 8 bit !, look at flags here ! */
    /*
      if write carry flag set: 
      dec_write_carry = true;
      dec_w1_reg_nr = (dec_operand_dst ^ 0x01)+1;
      dec_w1_port_nr= PORT_WRITE_FROM_ASU2;
    */ 
  }

  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( opcode==OP_ADDI ) {
    dec_ADD       = true;
    imm_8bit      = true;
    dec_read_to_EU_nr = EU_type_ASU;
    dec_use_r0    = true;
    dec_r0_reg_nr = dec_operand_1;

    // tel xbar to read from imm in stead of registers !? 
    //dec_R0_nr=PORT_READ_FROM_REGISTER;  ??
    //dec_R1_nr=PORT_READ_FROM_IMMEDIATE; ??

    dec_w0_reg_nr = dec_operand_dst ^ 0x01;
    dec_w0_port_nr= PORT_WRITE_FROM_ASU;
    dec_cycles    = 2;       /* 1 cycle for 8 bit !, look at flags here ! */
    /*
      if write carry flag set: 
      dec_write_carry = true;
      dec_w1_reg_nr = (dec_operand_dst ^ 0x01)+1;
      dec_w1_port_nr= PORT_WRITE_FROM_ASU2;
    */ 
  }

  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( opcode==OP_SUB ) {
  }

  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( opcode==OP_SUBI ) {
  }


  /* correct imm if it's 8 bit: */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( imm_8bit ) {
    dec_imm = (dec_instr & 0x000FF000LL) >> 12 ;
  }

}
