/*
  f-cpu/c/xbar/eu_asu.h - Xbar for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Sat Jul 13 22:22:00 CEST 2002 : first test

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef XBAR_H
#define XBAR_H

#include <f-cpu_config.h>

/* inputs and outputs : */

/* external FF of ASI EU: */
UMAX xbar_reg_W0;         /* connected to register write ports */
UMAX xbar_reg_W1;
UMAX xbar_reg_R0;         /* connected to register read ports */
UMAX xbar_reg_R1;
UMAX xbar_reg_R2;
UMAX xbar_write_port[25]; /* connected to the OUTPUTS of the EU's */
UMAX xbar_read_port[25];  /* connected to the INPUTS of the EU's */
u8   xbar_W0_nr;          /* Xbar settings, generated by scheduler */
u8   xbar_W1_nr;          /* i.e. witch EU to read/write using witch R/W bus */
u8   xbar_R0_nr;          /* and when to bypass a read bus to witch write bus */
u8   xbar_R1_nr;
u8   xbar_R2_nr;
u8   xbar_pas_R0;
u8   xbar_pas_R1;
u8   xbar_pas_R2;

/* internal FF between stages: */
/* -none- (Xbar is only 1 stage) */

/* problem : they should be enums !! */

static inline void cycle_asu (void);

#endif /* XBAR_H */
