/* 
  f-cpu/c/toplevel/fcpusim.c - F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Mon Jul 15 02:14:01 CEST 2002 : first test

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

//#include <../eu_rop2/eu_rop2.c>
//#include <../eu_inc/eu_inc.c>
//#include <../eu_asu/eu_asu.c>
//#include <../registers/registers.c>
//#include <../xbar/xbar.c>

void g(void){
  printf("%c[1;33;44m",0x1B);
}

void n(void){
  printf("%c[0;37;40m",0x1B);
}

void show_status(void){
int reg_view_cnt;

  printf("\n");
  printf("________________________________________");
  printf("_______________________________________\n");
  printf("status after cycle ");
  g(); printf("%d" , cycle_counter); n();
  printf(" :\n");

if (view == "r"){
  printf("registers: (1..63)  ");
  for (reg_view_cnt=1;reg_view_cnt<64;reg_view_cnt++){
    printf("%2X=",reg_view_cnt);
    g(); printf("%16llX", register_value[reg_view_cnt]); n();
    if ((reg_view_cnt % 4)==3) { printf("\n"); }else { printf(" "); }
  }
  printf(  " REG_nr_R0="); g(); printf("%2X" ,REG_nr_R0); n();
  printf("   REG_R0="); g(); printf("%16llX" ,REG_R0); n();
  printf( "  REG_nr_W0="); g(); printf("%2X" ,REG_nr_W0); n();
  printf("   REG_W0="); g(); printf("%16llX" ,REG_W0); n();
  printf("\n REG_nr_R1="); g(); printf("%2X" ,REG_nr_R1); n();
  printf("   REG_R1="); g(); printf("%16llX" ,REG_R1); n();
  printf( "  REG_nr_W1="); g(); printf("%2X" ,REG_nr_W1); n();
  printf("   REG_W1="); g(); printf("%16llX",REG_W1); n();
  printf("\n REG_nr_R2="); g(); printf("%2X" ,REG_nr_R2); n();
  printf("   REG_R2="); g(); printf("%16llX",REG_R2); n();
  printf("\n");


}

if (view == "a"){
  printf("ASU EU first stage:\n");
  printf(  "ASU_in_A   = "); g(); printf("%16llX",ASU_in_A); n();
  printf("\nASU_in_B   = "); g(); printf("%16llX",ASU_in_B); n();
  printf("\nASU_ADD    = "); g();
  if     (  ASU_ADD)         {printf("True");}else{printf("False");} n();
  printf("\nASU_SUB    = "); g();
  if     (  ASU_SUB)         {printf("True");}else{printf("False");} n();
  printf("\nASU_wrcarry= "); g();
  if     (  ASU_wrcarry)     {printf("True");}else{printf("False");} n();
  printf("\nASU_simd   = "); g();
  if     (  ASU_simd)        {printf("True");}else{printf("False");} n();
  printf("\nASU_size   = "); g(); printf("%d",ASU_size); n();
  printf("\n");
}

if (view == "x"){
  printf("Xbar:\n");
  printf(  "xbar_reg_R0   = "); g(); printf("%16llX",xbar_reg_R0); n();
  printf("\nxbar_reg_R1   = "); g(); printf("%16llX",xbar_reg_R1); n();
  printf("\nxbar_reg_R2   = "); g(); printf("%16llX",xbar_reg_R2); n();
  printf("\n...etc...\n");
}


}

void menu(void){

int stopme;
do {
  show_status();
  printf("r=registers a=asu, x=xbar <enter>=next_cycle <Ctr>+c=quit");
  scanf("%c",&c);

  stopme=0;
  if  (c==10 )           { stopme=1; }
  if ((c=='r')|(c=='R')) { view = "r"; scanf("%c",&c);}
  if ((c=='a')|(c=='A')) { view = "a"; scanf("%c",&c);}
  if ((c=='x')|(c=='X')) { view = "x"; scanf("%c",&c);}

} while (stopme==0); /* until <enter> */


/*
printf("%c[A",0x1B); // cursor up 
printf("%c[B",0x1B); // cursor dn 
printf("%c",13);     // to begin of line 
printf("%c[5;34;42m",0x1B);
printf("%c[0;37;40m",0x1B);
*/

}



