/* 
  f-cpu/c/toplevel/fcpusim.c - F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Mon Jul 15 02:14:01 CEST 2002 : first test

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

//#include <../eu_rop2/eu_rop2.c>
#include <../eu_inc/eu_inc.c>
#include <../eu_asu/eu_asu.c>
#include <../registers/registers.c>
#include <../xbar/xbar.c>
#include <fcpusim_show.c>

void simulate_one_cycle(void) {
  cycle_counter++;

/* run all the units: (oder sould not matter) */
//  cycle_rop2 ();
  cycle_inc ();
  cycle_asu ();
  cycle_registers ();
  cycle_xbar ();

  /*
  this would also be a nice plase to show the status,
  as we have both the old and new values for every unit!
  */

  /* link all the units (i.e. clock the FF's between them ) 
     according to the data generated by the scheduler. */
  /* link the register unit to the Xbar unit: */
  REG_W0 = xbar_reg_W0; 
  REG_W1 = xbar_reg_W1;
  xbar_reg_R0 = REG_R0;
  xbar_reg_R1 = REG_R1;
  xbar_reg_R2 = REG_R2;
  /* link the ASU EU to the Xbar: (from the list in: /c/xbar/xbar.c) */
  xbar_write_port[0x07] = ASU_out;
//xbar_write_port[0x08] = ASU_out_B; ???
  ASU_in_A = xbar_read_port[0x0A];
  ASU_in_B = xbar_read_port[0x0B];
  /* link the INC EU to the Xbar: (from the list in: /c/xbar/xbar.c) */
  // ther is some problem in the number of operand(s) for the INC EU ??

  /*
  write conflicts (to Xbar, etc) should not hapen if 
  the scheduler dous its job ok. 
  why copy all the in/out data of not used EU's ??
  (let the Xbar directly read/write the variables of the EU's !! )
  */

}


void clear_all_units(void){
int clear_reg_cnt;
  for (clear_reg_cnt=0;clear_reg_cnt<64;clear_reg_cnt++){
    register_value[clear_reg_cnt]=0;  
  }
  INC_INC = false;
  INC_DEC = false;
  INC_ABS = false;
  INC_NEG = false;
  INC_LSB0 = false;
  INC_LSB1 = false;
  INC_simd = false;
  INC_size = SIMD_MAX;
  ASU_ADD = false;
  ASU_SUB = false;
  ASU_wrcarry = false;
  ASU_simd = false;
  ASU_size = SIMD_MAX;
  /* this will be cleared bu the Xbar ..
  REG_W0 = 0; // 0 = no write to register
  REG_W1 = 0; // 0 = no write to register 
  REG_R0 = 0;
  REG_R1 = 0;
  REG_R2 = 0;
  */
  REG_nr_W0 = 0;  /* sat all ports to register 0x00 !?*/
  REG_nr_W1 = 0;
  REG_nr_R0 = 0;
  REG_nr_R1 = 0;
  REG_nr_R2 = 0;
  xbar_W0_nr = 0;
  xbar_W1_nr = 0;
  xbar_R0_nr = 0;
  xbar_R1_nr = 0;
  xbar_R2_nr = 0;
  xbar_pas_R0 = 0; /* 0 = no bypass*/
  xbar_pas_R1 = 0; /* 0 = no bypass*/
  xbar_pas_R2 = 0; /* 0 = no bypass*/
}


int main(int argc, char **argv) {

  printf("\n\n\n\n\n");
  printf("       F-CPU Simulator      (GNU General Public License)\n");
  printf(" (c) Yann GUIDON (YG) whygee@f-cpu.org\n");
  printf(" (c) Jaap Stolk (JWS) jwstolk@yahoo.com\n");
  printf("\n");
  printf("WARNING: manual scheduling is shown out of sinc! \n");
  printf("         it will be ok, when i added the scheduler. \n");
  printf("\n");

  /* now lets see if this CPU runs! */
  /* we have to do the scheduling manualy for now... */
  cycle_counter=0;

  printf("starting BIST ..."); /* to clear internal status of EU's */
  clear_all_units();
  simulate_one_cycle();
  clear_all_units();
  simulate_one_cycle();
  clear_all_units();
  simulate_one_cycle();
  clear_all_units();
  simulate_one_cycle();
  clear_all_units();
  simulate_one_cycle();
  printf("... Done BIST.\n");
  menu();

  printf(" lets try a 64 bit ADD (2 cycle): \n"); 

  /* fill the registers by hand, as we do not have a LOAD yet.. */
  register_value[0x30] = 0x000002FFFFFFFFFFFF;  
  register_value[0x31] = 0x000000000000000005;  
  menu();

  /* instruct the registers to read register 0x30 and 0x31: */
  REG_nr_R0 = 0x30;
  REG_nr_R1 = 0x31;
  simulate_one_cycle();
  menu();
  REG_nr_R0 = 0x00;
  REG_nr_R1 = 0x00;

  /* instruct the Xbar to connect the ASU inputs to the registers: */
  xbar_R0_nr = 0x0A; /* =ASU_in_A */
  xbar_R1_nr = 0x0B; /* =ASU_in_B */
  simulate_one_cycle();
  menu();
  xbar_R0_nr = 0x00;
  xbar_R1_nr = 0x00;

  /* instruct the ASU EU to perform 64 bit ADD: */
  ASU_ADD     = true;
  simulate_one_cycle();
  menu();
  ASU_ADD     = false;

  /* perform the second ASU cycle (it's in the pipeline now !!): */
  simulate_one_cycle();
  menu();

  /* instruct the Xbar to move the result to register write port 0: */
  xbar_W0_nr = 0x07; /* =ASU_out */
  simulate_one_cycle();
  menu();
  xbar_W0_nr = 0x00;

  /* instruct the registers to save this in register 0x32: */
  REG_nr_W0 = 0x32;
  simulate_one_cycle();
  menu();
  REG_nr_W0 = 0x00;



}
