/* 
  f-cpu/c/registers/eu_asu.c - registers for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Sat Jul 13 22:22:00 CEST 2002 : first test

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
--
--   /---------- REG_nr_W0   > 1..63
--   | /-------- REG_nr_W1   > 1..63
--   | | /------ REG_nr_R0   > 0..63
--   | | | /---- REG_nr_R1   > 0..63
--   | | | | /-- REG_nr_R2   > 0..63
--   | | | | |
--   | | | | |                                  REG_W0  REG_W1
--   | | | | |                                    |       |
--   v v v v v                                    v       v
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %%                        registers stage                           %%
-- %%                                                                  %%
-- %%                                                                  %%
-- %%                                                                  %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--                                                  |       |       |
--                                                  v       v       v
--                                                REG_R0  REG_R1  REG_R2 
--
*/

/* defines the constants, inputs and outputs : */
#include <registers.h>

static inline void cycle_registers (void) {

  if (REG_nr_W0) { register_value[REG_nr_W0] = REG_W0; }
  if (REG_nr_W1) { register_value[REG_nr_W1] = REG_W1; }

  if (REG_nr_R0) { REG_R0 = register_value[REG_nr_R0]; } else { REG_R0 = 0; }
  if (REG_nr_R1) { REG_R1 = register_value[REG_nr_R1]; } else { REG_R1 = 0; }
  if (REG_nr_R2) { REG_R2 = register_value[REG_nr_R2]; } else { REG_R2 = 0; }

  /* reading and writing the same register should be prevented by  */
  /* the scheduler. (it's done on the Xbar)                        */
  /* zero detection is also done by an other unit ?              */

  /* Ok. now, where is the catch? it can't be that easy...*/

}
