/*
  f-cpu/c/eu_inc/eu_inc.h - INC Execution Unit ports for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Sat Jul 13 14:39:00 CEST 2002 : first test

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef EU_INC_H
#define EU_INC_H

#include <f-cpu_config.h>

/* (def of consts is has to be moved somwhere else (f-cpu_config.h?) ) */
#define SIMD_MAX 0 /* move this to configure ! */
#define SIMD_32  1
#define SIMD_16  2
#define SIMD_8   3
#define true     1
#define false    0

/* inputs and outputs : */

/* external FF of ASI EU: */
UMAX INC_in;     /* the operand */
UMAX INC_out;    /* the result */
bool INC_INC;
bool INC_DEC;
bool INC_ABS;
bool INC_NEG;
bool INC_LSB0;
bool INC_LSB1;
bool INC_simd;
u8   INC_size;

/* internal FF between stages: */
UMAX tmp_INC_in;
UMAX tmp_INC_out;
bool tmp_INC_INC;
bool tmp_INC_DEC;
bool tmp_INC_ABS;
bool tmp_INC_NEG;
bool tmp_INC_LSB0;
bool tmp_INC_LSB1;
bool tmp_INC_simd;
u8   tmp_INC_size;
 
/* problem : they should be enums !! */

static inline void cycle_inc (void);

#endif /* EU_INC_H */
