/* 
  f-cpu/c/eu_inc/eu_inc.c - INC Execution Unit for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Sat Jul 13 14:39:00 CEST 2002 : first test

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
--
--   /---------------- INC_INC     > std_ulogic
--   | /-------------- INC_DEC     > std_ulogic
--   | | /------------ INC_ABS     > std_ulogic
--   | | | /---------- INC_NEG     > std_ulogic
--   | | | | /-------- INC_LSB0    > std_ulogic
--   | | | | | /------ INC_LSB1    > std_ulogic
--   | | | | | | /---- INC_simd    > std_ulogic
--   | | | | | | | /-- INC_size    > SIMD_8 / SIMD_16 / SIMD_32 / SIMD_MAX 
--   | | | | | | | |
--   v v v v v v v v
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %%                           Xbar stage                             %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--   | | | | | | | |   tmp_INC_INC
--   | | | | | | | |   tmp_INC_DEC
--   | | | | | | | |   tmp_INC_ABS
--   | | | | | | | |   tmp_INC_NEG
--   | | | | | | | |   tmp_INC_LSB0
--   | | | | | | | |   tmp_INC_LSB1                         INC_in
--   | | | | | | | |   tmp_INC_simd                            |
--   v v v v v v v v   tmp_INC_size                            v
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %%                           INC EU stage                           %%
-- %%            do: INC / DEC / ABS / NEG / LSB0 / LSB1               %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--                                                             |
--                                                             v
--                                                          INC_out
--
*/

/* defines the constants, inputs and outputs : */
#include <eu_inc.h>

static inline void cycle_inc (void) {

  UMAX INC_result; 

  /* INC EU stage (run this BEFORE the Xbar stage !) */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if (tmp_INC_INC){
    INC_result = tmp_INC_in + 1;
  }else{

    if (tmp_INC_DEC){
      INC_result = tmp_INC_in - 1;
    }else{

      if (tmp_INC_ABS){
        if (tmp_INC_in & 0x1000000000000000LL) {
          INC_result =  ( ~tmp_INC_in ) + 1; 
        }else{
          INC_result =     tmp_INC_in;
        }
      }else{

        if (tmp_INC_NEG){
          INC_result = ~tmp_INC_in;
        }else{

          if (tmp_INC_LSB0){
            INC_result = tmp_INC_in & 0x0000000000000001LL;
          }else{

            if (tmp_INC_LSB1){
              if (tmp_INC_in & 0x0000000000000010LL) {
                INC_result = 0x0000000000000001LL;
              }
            }

          }
        }
      }
    }
  }
  /* SIMD version not yet implemented !! */
  /* wrap around on inc/dec ? */
  INC_out = INC_result;

  /* Xbar stage */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  /* needed to lower fanout of NEG signal, witch we don't simulate */
  tmp_INC_INC  = INC_INC;
  tmp_INC_DEC  = INC_DEC;
  tmp_INC_ABS  = INC_ABS;
  tmp_INC_NEG  = INC_NEG;
  tmp_INC_LSB0 = INC_LSB0;
  tmp_INC_LSB1 = INC_LSB1;
  tmp_INC_simd = INC_simd;
  tmp_INC_size = INC_size;

}
