(define_insn "umindi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (umin:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "min%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*umin_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(umin (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "min%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "uminsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (umin:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "min%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "uminhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (umin:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "min%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "uminqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (umin:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "min%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "umaxdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (umax:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "max%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*umax_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(umax (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "max%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "umaxsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (umax:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "max%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "umaxhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (umax:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "max%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "umaxqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (umax:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "max%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smindi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (smin:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8s_operand" "ri")))]
  ""
  "mins%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*smin_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(smin (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8s_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "mins%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "sminsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (smin:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8s_operand" "ri")))]
  ""
  "mins%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "sminhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (smin:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8s_operand" "ri")))]
  ""
  "mins%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "sminqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (smin:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8s_operand" "ri")))]
  ""
  "mins%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smaxdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (smax:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8s_operand" "ri")))]
  ""
  "maxs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*smax_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(smax (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8s_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "maxs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smaxsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (smax:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8s_operand" "ri")))]
  ""
  "maxs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smaxhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (smax:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8s_operand" "ri")))]
  ""
  "maxs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smaxqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (smax:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8s_operand" "ri")))]
  ""
  "maxs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "negdi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (neg:DI (match_operand:DI 1 "register_operand" "r")))]
  ""
  "neg.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "*neg_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 2 "unary_operator" [(neg (match_operand 1 "register_operand" "r"))]))]
  "zero_extend_insn_ok(operands,2,0)"
  "neg.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "negsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (neg:SI (match_operand:SI 1 "register_operand" "r")))]
  ""
  "neg.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "neghi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (neg:HI (match_operand:HI 1 "register_operand" "r")))]
  ""
  "neg.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "negqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (neg:QI (match_operand:QI 1 "register_operand" "r")))]
  ""
  "neg.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "absdi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (abs:DI (match_operand:DI 1 "register_operand" "r")))]
  ""
  "abs.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "*abs_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 2 "unary_operator" [(abs (match_operand 1 "register_operand" "r"))]))]
  "zero_extend_insn_ok(operands,2,0)"
  "abs.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "abssi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (abs:SI (match_operand:SI 1 "register_operand" "r")))]
  ""
  "abs.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "abshi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (abs:HI (match_operand:HI 1 "register_operand" "r")))]
  ""
  "abs.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "absqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (abs:QI (match_operand:QI 1 "register_operand" "r")))]
  ""
  "abs.%s1 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "one_cmpldi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (not:DI (match_operand:DI 1 "register_operand" "r")))]
  ""
  "nor.%s1 r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "*one_cmpl_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 2 "unary_operator" [(not (match_operand 1 "register_operand" "r"))]))]
  "zero_extend_insn_ok(operands,2,0)"
  "nor.%s1 r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (not:SI (match_operand:SI 1 "register_operand" "r")))]
  ""
  "nor.%s1 r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (not:HI (match_operand:HI 1 "register_operand" "r")))]
  ""
  "nor.%s1 r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "one_cmplqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (not:QI (match_operand:QI 1 "register_operand" "r")))]
  ""
  "nor.%s1 r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "ffsdi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (ffs:DI (match_operand:DI 1 "register_operand" "r")))]
  ""
  "lsb1.%s1 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "*ffs_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 2 "unary_operator" [(ffs (match_operand 1 "register_operand" "r"))]))]
  "zero_extend_insn_ok(operands,2,0)"
  "lsb1.%s1 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "ffssi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (ffs:SI (match_operand:SI 1 "register_operand" "r")))]
  ""
  "lsb1.%s1 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "ffshi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (ffs:HI (match_operand:HI 1 "register_operand" "r")))]
  ""
  "lsb1.%s1 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "ffsqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (ffs:QI (match_operand:QI 1 "register_operand" "r")))]
  ""
  "lsb1.%s1 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "*ashlmuldi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (mult:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0 && zero_extend_insn_ok(operands,0,0)" 
  "shiftli.%s1 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "**ashlmul_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(mult (match_operand 1 "register_operand" "r")
		  (match_operand 2 "bitable_operand" "i"))]))]
  "exact_log2(INTVAL(operands[2]))>=0 && zero_extend_insn_ok(operands,3,0)" 
  "shiftli.%s1 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*ashlmulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (mult:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0 && zero_extend_insn_ok(operands,0,0)" 
  "shiftli.%s1 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*ashlmulhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (mult:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0 && zero_extend_insn_ok(operands,0,0)" 
  "shiftli.%s1 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*ashlmulqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (mult:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0 && zero_extend_insn_ok(operands,0,0)" 
  "shiftli.%s1 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashldi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (ashift:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*ashl_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(ashift (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "shiftl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (ashift:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (ashift:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashlqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (ashift:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashrdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (ashiftrt:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftra%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*ashr_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(ashiftrt (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "shiftra%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (ashiftrt:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftra%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (ashiftrt:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftra%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashrqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (ashiftrt:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftra%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "lshrdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (lshiftrt:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*lshr_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(lshiftrt (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "shiftr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (lshiftrt:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "lshrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (lshiftrt:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "lshrqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (lshiftrt:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "shiftr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotldi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (rotate:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "rotl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*rotl_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(rotate (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "rotl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (rotate:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "rotl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotlhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (rotate:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "rotl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotlqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (rotate:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "rotl%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotrdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (rotatert:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "rotr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*rotr_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(rotatert (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "rotr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (rotatert:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "rotr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (rotatert:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "rotr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotrqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (rotatert:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "rotr%i2.%s1 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "anddi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (and:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm9s_operand" "ri")))]
  ""
  "and%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "*and_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(and (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm9s_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "and%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "andsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (and:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm9s_operand" "ri")))]
  ""
  "and%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "andhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (and:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm9s_operand" "ri")))]
  ""
  "and%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "andqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (and:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm9s_operand" "ri")))]
  ""
  "and%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "iordi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (ior:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm9s_operand" "ri")))]
  ""
  "or%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "*ior_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(ior (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm9s_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "or%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (ior:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm9s_operand" "ri")))]
  ""
  "or%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (ior:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm9s_operand" "ri")))]
  ""
  "or%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "iorqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (ior:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm9s_operand" "ri")))]
  ""
  "or%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "xordi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (xor:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm9s_operand" "ri")))]
  ""
  "xor%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "*xor_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(xor (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm9s_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "xor%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (xor:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm9s_operand" "ri")))]
  ""
  "xor%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "xorhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (xor:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm9s_operand" "ri")))]
  ""
  "xor%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "xorqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (xor:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm9s_operand" "ri")))]
  ""
  "xor%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])


;; We need to be able to handle many immediates here. We can generate
;; addi,subi,inc and dec depending on imm value. Failing to provide
;; this leads to loading unnecessary constants to registers especially
;; during strength reduce. devik.
(define_insn "adddi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (plus:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm9x_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add.%s1 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.%s1 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.%s1 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.%s1 $%n2,%1,%0";
  return "addi.%s1 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "*add_zext"
  [(set (match_operand 0 "register_operand" "=r,r")
	 (match_operator 3 "unary_operator" [(plus (match_operand 1 "register_operand" "r,r")
		  (match_operand 2 "regimm9x_operand" "r,i"))]))]
  "zero_extend_insn_ok(operands,3,2)" {
  if (which_alternative == 0) return "add.%s1 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.%s1 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.%s1 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.%s1 $%n2,%1,%0";
  return "addi.%s1 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (plus:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm9x_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add.%s1 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.%s1 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.%s1 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.%s1 $%n2,%1,%0";
  return "addi.%s1 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "addhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (plus:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm9x_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add.%s1 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.%s1 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.%s1 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.%s1 $%n2,%1,%0";
  return "addi.%s1 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "addqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (plus:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm9x_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add.%s1 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.%s1 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.%s1 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.%s1 $%n2,%1,%0";
  return "addi.%s1 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "subdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (minus:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "sub%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*sub_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(minus (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "sub%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (minus:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "sub%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "subhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (minus:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "sub%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "subqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (minus:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "sub%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*addusdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (us_plus:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "adds%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "**addus_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(us_plus (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "adds%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*addussi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (us_plus:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "adds%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*addushi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (us_plus:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "adds%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*addusqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (us_plus:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "adds%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*subusdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (us_minus:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "subs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "**subus_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(us_minus (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "subs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*subussi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (us_minus:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "subs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*subushi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (us_minus:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "subs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*subusqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (us_minus:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "subs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*gtudi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (gtu:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "cmpg%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "**gtu_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(gtu (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "cmpg%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtusi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (gtu:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "cmpg%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtuhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (gtu:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "cmpg%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtuqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (gtu:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "cmpg%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leudi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (leu:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8u_operand" "ri")))]
  ""
  "cmple%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "**leu_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(leu (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8u_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "cmple%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leusi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (leu:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8u_operand" "ri")))]
  ""
  "cmple%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leuhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (leu:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8u_operand" "ri")))]
  ""
  "cmple%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leuqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (leu:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8u_operand" "ri")))]
  ""
  "cmple%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (gt:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8s_operand" "ri")))]
  ""
  "cmpgs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "**gt_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(gt (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8s_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "cmpgs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (gt:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8s_operand" "ri")))]
  ""
  "cmpgs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gthi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (gt:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8s_operand" "ri")))]
  ""
  "cmpgs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (gt:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8s_operand" "ri")))]
  ""
  "cmpgs%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*ledi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (le:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "regimm8s_operand" "ri")))]
  ""
  "cmples%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "**le_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(le (match_operand 1 "register_operand" "r")
		  (match_operand 2 "regimm8s_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "cmples%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*lesi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (le:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "regimm8s_operand" "ri")))]
  ""
  "cmples%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*lehi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (le:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "regimm8s_operand" "ri")))]
  ""
  "cmples%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (le:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "regimm8s_operand" "ri")))]
  ""
  "cmples%i2.%s1 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "muldi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (mult:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8s_operand" "r,i")))]
  "" "@
  muls.%s1 %2,%1,%0
  muli.%s1 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "*mul_zext"
  [(set (match_operand 0 "register_operand" "=r,r")
	 (match_operator 3 "unary_operator" [(mult (match_operand 1 "register_operand" "r,r")
		  (match_operand 2 "regimm8s_operand" "r,i"))]))]
  "zero_extend_insn_ok(operands,3,2)" "@
  muls.%s1 %2,%1,%0
  muli.%s1 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (mult:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8s_operand" "r,i")))]
  "" "@
  muls.%s1 %2,%1,%0
  muli.%s1 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "mulhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (mult:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8s_operand" "r,i")))]
  "" "@
  muls.%s1 %2,%1,%0
  muli.%s1 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "mulqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (mult:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8s_operand" "r,i")))]
  "" "@
  muls.%s1 %2,%1,%0
  muli.%s1 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "divdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (div:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8s_operand" "r,i")))]
  "" "@
  divs.%s1 %2,%1,%0
  divi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "*div_zext"
  [(set (match_operand 0 "register_operand" "=r,r")
	 (match_operator 3 "unary_operator" [(div (match_operand 1 "register_operand" "r,r")
		  (match_operand 2 "regimm8s_operand" "r,i"))]))]
  "zero_extend_insn_ok(operands,3,2)" "@
  divs.%s1 %2,%1,%0
  divi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "divsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (div:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8s_operand" "r,i")))]
  "" "@
  divs.%s1 %2,%1,%0
  divi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "divhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (div:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8s_operand" "r,i")))]
  "" "@
  divs.%s1 %2,%1,%0
  divi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "divqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (div:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8s_operand" "r,i")))]
  "" "@
  divs.%s1 %2,%1,%0
  divi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "moddi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (mod:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8s_operand" "r,i")))]
  "" "@
  rems.%s1 %2,%1,%0
  remi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "*mod_zext"
  [(set (match_operand 0 "register_operand" "=r,r")
	 (match_operator 3 "unary_operator" [(mod (match_operand 1 "register_operand" "r,r")
		  (match_operand 2 "regimm8s_operand" "r,i"))]))]
  "zero_extend_insn_ok(operands,3,2)" "@
  rems.%s1 %2,%1,%0
  remi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "modsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (mod:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8s_operand" "r,i")))]
  "" "@
  rems.%s1 %2,%1,%0
  remi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "modhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (mod:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8s_operand" "r,i")))]
  "" "@
  rems.%s1 %2,%1,%0
  remi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "modqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (mod:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8s_operand" "r,i")))]
  "" "@
  rems.%s1 %2,%1,%0
  remi.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "udivdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (udiv:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "register_operand" "ri")))]
  ""
  "div%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "*udiv_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(udiv (match_operand 1 "register_operand" "r")
		  (match_operand 2 "register_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "div%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "udivsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (udiv:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "register_operand" "ri")))]
  ""
  "div%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "udivhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (udiv:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "register_operand" "ri")))]
  ""
  "div%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "udivqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (udiv:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "register_operand" "ri")))]
  ""
  "div%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "umoddi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (umod:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "register_operand" "ri")))]
  ""
  "rem%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "*umod_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(umod (match_operand 1 "register_operand" "r")
		  (match_operand 2 "register_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "rem%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "umodsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (umod:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "register_operand" "ri")))]
  ""
  "rem%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "umodhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (umod:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "register_operand" "ri")))]
  ""
  "rem%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "umodqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (umod:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "register_operand" "ri")))]
  ""
  "rem%i2.%s1 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "adddf3"
  [(set (match_operand:DF 0 "register_operand" "=r")
	 (plus:DF (match_operand:DF 1 "register_operand" "r")
		  (match_operand:DF 2 "register_operand" "ri")))]
  ""
  "fadd%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "*add_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(plus (match_operand 1 "register_operand" "r")
		  (match_operand 2 "register_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "fadd%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "addsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	 (plus:SF (match_operand:SF 1 "register_operand" "r")
		  (match_operand:SF 2 "register_operand" "ri")))]
  ""
  "fadd%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "subdf3"
  [(set (match_operand:DF 0 "register_operand" "=r")
	 (minus:DF (match_operand:DF 1 "register_operand" "r")
		  (match_operand:DF 2 "register_operand" "ri")))]
  ""
  "fsub%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "*sub_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(minus (match_operand 1 "register_operand" "r")
		  (match_operand 2 "register_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "fsub%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "subsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	 (minus:SF (match_operand:SF 1 "register_operand" "r")
		  (match_operand:SF 2 "register_operand" "ri")))]
  ""
  "fsub%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "muldf3"
  [(set (match_operand:DF 0 "register_operand" "=r")
	 (mult:DF (match_operand:DF 1 "register_operand" "r")
		  (match_operand:DF 2 "register_operand" "ri")))]
  ""
  "fmul%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "*mul_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(mult (match_operand 1 "register_operand" "r")
		  (match_operand 2 "register_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "fmul%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	 (mult:SF (match_operand:SF 1 "register_operand" "r")
		  (match_operand:SF 2 "register_operand" "ri")))]
  ""
  "fmul%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "divdf3"
  [(set (match_operand:DF 0 "register_operand" "=r")
	 (div:DF (match_operand:DF 1 "register_operand" "r")
		  (match_operand:DF 2 "register_operand" "ri")))]
  ""
  "fdiv%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "*div_zext"
  [(set (match_operand 0 "register_operand" "=r")
	 (match_operator 3 "unary_operator" [(div (match_operand 1 "register_operand" "r")
		  (match_operand 2 "register_operand" "ri"))]))]
  "zero_extend_insn_ok(operands,3,2)"
  "fdiv%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])

(define_insn "divsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	 (div:SF (match_operand:SF 1 "register_operand" "r")
		  (match_operand:SF 2 "register_operand" "ri")))]
  ""
  "fdiv%i2.%s1 %2,%1,%0"
  [(set_attr "type" "fpu")])


(define_expand "beq"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (EQ); }")
(define_expand "seq"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (EQ,operands); DONE; })

(define_expand "bne"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (NE); }")
(define_expand "sne"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (NE,operands); DONE; })

(define_expand "ble"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (LE); }")
(define_expand "sle"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (LE,operands); DONE; })

(define_expand "bleu"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (LEU); }")
(define_expand "sleu"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (LEU,operands); DONE; })

(define_expand "blt"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (LT); }")
(define_expand "slt"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (LT,operands); DONE; })

(define_expand "bltu"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (LTU); }")
(define_expand "sltu"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (LTU,operands); DONE; })

(define_expand "bgt"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (GT); }")
(define_expand "sgt"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (GT,operands); DONE; })

(define_expand "bgtu"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (GTU); }")
(define_expand "sgtu"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (GTU,operands); DONE; })

(define_expand "bge"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (GE); }")
(define_expand "sge"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (GE,operands); DONE; })

(define_expand "bgeu"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (GEU); }")
(define_expand "sgeu"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (GEU,operands); DONE; })

(define_expand "bordered"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (ORDERED); }")
(define_expand "sordered"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (ORDERED,operands); DONE; })

(define_expand "bunordered"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (UNORDERED); }")
(define_expand "sunordered"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (UNORDERED,operands); DONE; })

(define_insn "extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
               (sign_extend:DI (match_operand:SI 1 "register_operand" "r")))]
   "" "widen.32 %1,%0")
(define_insn "zero_extendsidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
                 (zero_extend:DI (match_operand:SI 1 "register_operand" "r")))]
   "" "move.32 %1,%0\t// zero_extend")

(define_insn "extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
               (sign_extend:DI (match_operand:HI 1 "register_operand" "r")))]
   "" "widen.16 %1,%0")
(define_insn "zero_extendhidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
                 (zero_extend:DI (match_operand:HI 1 "register_operand" "r")))]
   "" "move.16 %1,%0\t// zero_extend")

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
               (sign_extend:DI (match_operand:QI 1 "register_operand" "r")))]
   "" "widen.8 %1,%0")
(define_insn "zero_extendqidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
                 (zero_extend:DI (match_operand:QI 1 "register_operand" "r")))]
   "" "move.8 %1,%0\t// zero_extend")

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
               (sign_extend:SI (match_operand:HI 1 "register_operand" "r")))]
   "" "widen.16 %1,%0")
(define_insn "zero_extendhisi2"
   [(set (match_operand:SI 0 "register_operand" "=r")
                 (zero_extend:SI (match_operand:HI 1 "register_operand" "r")))]
   "" "move.16 %1,%0\t// zero_extend")

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
               (sign_extend:SI (match_operand:QI 1 "register_operand" "r")))]
   "" "widen.8 %1,%0")
(define_insn "zero_extendqisi2"
   [(set (match_operand:SI 0 "register_operand" "=r")
                 (zero_extend:SI (match_operand:QI 1 "register_operand" "r")))]
   "" "move.8 %1,%0\t// zero_extend")

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
               (sign_extend:HI (match_operand:QI 1 "register_operand" "r")))]
   "" "widen.8 %1,%0")
(define_insn "zero_extendqihi2"
   [(set (match_operand:HI 0 "register_operand" "=r")
                 (zero_extend:HI (match_operand:QI 1 "register_operand" "r")))]
   "" "move.8 %1,%0\t// zero_extend")

(define_insn "floatqisf2"
    [(set (match_operand:SF 0 "register_operand" "=r")
	(float:SF (match_operand:QI 1 "register_operand" "r")))]
    ""
    "int2f.%s1 %1,%0")
(define_insn "fixsfqi2"
    [(set (match_operand:QI 0 "register_operand" "=r")
	(fix:QI (match_operand:SF 1 "register_operand" "r")))]
    ""
    "f2int.%s0 %1,%0")

(define_insn "floathisf2"
    [(set (match_operand:SF 0 "register_operand" "=r")
	(float:SF (match_operand:HI 1 "register_operand" "r")))]
    ""
    "int2f.%s1 %1,%0")
(define_insn "fixsfhi2"
    [(set (match_operand:HI 0 "register_operand" "=r")
	(fix:HI (match_operand:SF 1 "register_operand" "r")))]
    ""
    "f2int.%s0 %1,%0")

(define_insn "floatsisf2"
    [(set (match_operand:SF 0 "register_operand" "=r")
	(float:SF (match_operand:SI 1 "register_operand" "r")))]
    ""
    "int2f.%s1 %1,%0")
(define_insn "fixsfsi2"
    [(set (match_operand:SI 0 "register_operand" "=r")
	(fix:SI (match_operand:SF 1 "register_operand" "r")))]
    ""
    "f2int.%s0 %1,%0")

(define_insn "floatdisf2"
    [(set (match_operand:SF 0 "register_operand" "=r")
	(float:SF (match_operand:DI 1 "register_operand" "r")))]
    ""
    "int2f.%s1 %1,%0")
(define_insn "fixsfdi2"
    [(set (match_operand:DI 0 "register_operand" "=r")
	(fix:DI (match_operand:SF 1 "register_operand" "r")))]
    ""
    "f2int.%s0 %1,%0")

(define_insn "floatqidf2"
    [(set (match_operand:DF 0 "register_operand" "=r")
	(float:DF (match_operand:QI 1 "register_operand" "r")))]
    ""
    "int2d.%s1 %1,%0")
(define_insn "fixdfqi2"
    [(set (match_operand:QI 0 "register_operand" "=r")
	(fix:QI (match_operand:DF 1 "register_operand" "r")))]
    ""
    "d2int.%s0 %1,%0")

(define_insn "floathidf2"
    [(set (match_operand:DF 0 "register_operand" "=r")
	(float:DF (match_operand:HI 1 "register_operand" "r")))]
    ""
    "int2d.%s1 %1,%0")
(define_insn "fixdfhi2"
    [(set (match_operand:HI 0 "register_operand" "=r")
	(fix:HI (match_operand:DF 1 "register_operand" "r")))]
    ""
    "d2int.%s0 %1,%0")

(define_insn "floatsidf2"
    [(set (match_operand:DF 0 "register_operand" "=r")
	(float:DF (match_operand:SI 1 "register_operand" "r")))]
    ""
    "int2d.%s1 %1,%0")
(define_insn "fixdfsi2"
    [(set (match_operand:SI 0 "register_operand" "=r")
	(fix:SI (match_operand:DF 1 "register_operand" "r")))]
    ""
    "d2int.%s0 %1,%0")

(define_insn "floatdidf2"
    [(set (match_operand:DF 0 "register_operand" "=r")
	(float:DF (match_operand:DI 1 "register_operand" "r")))]
    ""
    "int2d.%s1 %1,%0")
(define_insn "fixdfdi2"
    [(set (match_operand:DI 0 "register_operand" "=r")
	(fix:DI (match_operand:DF 1 "register_operand" "r")))]
    ""
    "d2int.%s0 %1,%0")

