(define_insn "umindi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (umin:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  min.64 %2,%1,%0
  mini.64 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "uminsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (umin:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  min.32 %2,%1,%0
  mini.32 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "uminhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (umin:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  min.16 %2,%1,%0
  mini.16 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "uminqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (umin:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  min.8 %2,%1,%0
  mini.8 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "umaxdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (umax:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  max.64 %2,%1,%0
  maxi.64 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "umaxsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (umax:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  max.32 %2,%1,%0
  maxi.32 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "umaxhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (umax:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  max.16 %2,%1,%0
  maxi.16 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "umaxqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (umax:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  max.8 %2,%1,%0
  maxi.8 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smindi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (smin:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  mins.64 %2,%1,%0
  minsi.64 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "sminsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (smin:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  mins.32 %2,%1,%0
  minsi.32 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "sminhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (smin:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  mins.16 %2,%1,%0
  minsi.16 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "sminqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (smin:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  mins.8 %2,%1,%0
  minsi.8 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smaxdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (smax:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  maxs.64 %2,%1,%0
  maxsi.64 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smaxsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (smax:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  maxs.32 %2,%1,%0
  maxsi.32 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smaxhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (smax:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  maxs.16 %2,%1,%0
  maxsi.16 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "smaxqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (smax:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  maxs.8 %2,%1,%0
  maxsi.8 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "negdi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (neg:DI (match_operand:DI 1 "register_operand" "r")))]
  "" "neg.64 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "negsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (neg:SI (match_operand:SI 1 "register_operand" "r")))]
  "" "neg.32 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "neghi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (neg:HI (match_operand:HI 1 "register_operand" "r")))]
  "" "neg.16 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "negqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (neg:QI (match_operand:QI 1 "register_operand" "r")))]
  "" "neg.8 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "absdi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (abs:DI (match_operand:DI 1 "register_operand" "r")))]
  "" "abs.64 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "abssi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (abs:SI (match_operand:SI 1 "register_operand" "r")))]
  "" "abs.32 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "abshi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (abs:HI (match_operand:HI 1 "register_operand" "r")))]
  "" "abs.16 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "absqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (abs:QI (match_operand:QI 1 "register_operand" "r")))]
  "" "abs.8 %1,%0"
  [(set_attr "type" "inc")])

(define_insn "one_cmpldi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (not:DI (match_operand:DI 1 "register_operand" "r")))]
  "" "nor r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (not:SI (match_operand:SI 1 "register_operand" "r")))]
  "" "nor r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (not:HI (match_operand:HI 1 "register_operand" "r")))]
  "" "nor r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "one_cmplqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (not:QI (match_operand:QI 1 "register_operand" "r")))]
  "" "nor r0,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "ffsdi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (ffs:DI (match_operand:DI 1 "register_operand" "r")))]
  "" "lsb1.64 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "ffssi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (ffs:SI (match_operand:SI 1 "register_operand" "r")))]
  "" "lsb1.32 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "ffshi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (ffs:HI (match_operand:HI 1 "register_operand" "r")))]
  "" "lsb1.16 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "ffsqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (ffs:QI (match_operand:QI 1 "register_operand" "r")))]
  "" "lsb1.8 %1,%0"
  [(set_attr "type" "logic")])

(define_insn "*ashlmuldi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	 (mult:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0" "shiftli.64 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*ashlmulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	 (mult:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0" "shiftli.32 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*ashlmulhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	 (mult:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0" "shiftli.16 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "*ashlmulqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	 (mult:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0" "shiftli.8 %b2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashldi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (ashift:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftl.64 %2,%1,%0
  shiftli.64 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (ashift:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftl.32 %2,%1,%0
  shiftli.32 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (ashift:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftl.16 %2,%1,%0
  shiftli.16 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashlqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (ashift:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftl.8 %2,%1,%0
  shiftli.8 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashrdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (ashiftrt:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftra.64 %2,%1,%0
  shiftrai.64 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (ashiftrt:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftra.32 %2,%1,%0
  shiftrai.32 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (ashiftrt:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftra.16 %2,%1,%0
  shiftrai.16 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "ashrqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (ashiftrt:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftra.8 %2,%1,%0
  shiftrai.8 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "lshrdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (lshiftrt:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftr.64 %2,%1,%0
  shiftri.64 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (lshiftrt:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftr.32 %2,%1,%0
  shiftri.32 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "lshrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (lshiftrt:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftr.16 %2,%1,%0
  shiftri.16 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "lshrqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (lshiftrt:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  shiftr.8 %2,%1,%0
  shiftri.8 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotldi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (rotate:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  rotl.64 %2,%1,%0
  rotli.64 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (rotate:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  rotl.32 %2,%1,%0
  rotli.32 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotlhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (rotate:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  rotl.16 %2,%1,%0
  rotli.16 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotlqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (rotate:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  rotl.8 %2,%1,%0
  rotli.8 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotrdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (rotatert:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  rotr.64 %2,%1,%0
  rotri.64 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (rotatert:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  rotr.32 %2,%1,%0
  rotri.32 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (rotatert:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  rotr.16 %2,%1,%0
  rotri.16 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "rotrqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (rotatert:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  rotr.8 %2,%1,%0
  rotri.8 %2,%1,%0"
  [(set_attr "type" "rot")])

(define_insn "anddi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (and:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  and %2,%1,%0
  andi %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "andsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (and:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  and %2,%1,%0
  andi %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "andhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (and:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  and %2,%1,%0
  andi %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "andqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (and:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  and %2,%1,%0
  andi %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "iordi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (ior:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  or %2,%1,%0
  ori %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (ior:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  or %2,%1,%0
  ori %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (ior:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  or %2,%1,%0
  ori %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "iorqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (ior:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  or %2,%1,%0
  ori %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "xordi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (xor:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  xor %2,%1,%0
  xori %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (xor:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  xor %2,%1,%0
  xori %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "xorhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (xor:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  xor %2,%1,%0
  xori %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "xorqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (xor:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  xor %2,%1,%0
  xori %2,%1,%0"
  [(set_attr "type" "logic")])


;; We need to be able to handle many immediates here. We can generate
;; addi,subi,inc and dec depending on imm value. Failing to provide
;; this leads to loading unnecessary constants to registers especially
;; during strength reduce. devik.
(define_insn "adddi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (plus:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm9x_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add.64 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.64 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.64 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.64 $%n2,%1,%0";
  return "addi.64 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (plus:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm9x_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add.32 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.32 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.32 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.32 $%n2,%1,%0";
  return "addi.32 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "addhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (plus:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm9x_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add.16 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.16 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.16 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.16 $%n2,%1,%0";
  return "addi.16 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "addqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (plus:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm9x_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add.8 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.8 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.8 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.8 $%n2,%1,%0";
  return "addi.8 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME

(define_insn "subdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (minus:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  sub.64 %2,%1,%0
  subi.64 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (minus:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  sub.32 %2,%1,%0
  subi.32 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "subhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (minus:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  sub.16 %2,%1,%0
  subi.16 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "subqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (minus:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  sub.8 %2,%1,%0
  subi.8 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*addusdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (us_plus:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  adds.64 %2,%1,%0
  addsi.64 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*addussi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (us_plus:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  adds.32 %2,%1,%0
  addsi.32 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*addushi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (us_plus:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  adds.16 %2,%1,%0
  addsi.16 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*addusqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (us_plus:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  adds.8 %2,%1,%0
  addsi.8 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*subusdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (us_minus:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  subs.64 %2,%1,%0
  subsi.64 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*subussi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (us_minus:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  subs.32 %2,%1,%0
  subsi.32 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*subushi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (us_minus:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  subs.16 %2,%1,%0
  subsi.16 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*subusqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (us_minus:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  subs.8 %2,%1,%0
  subsi.8 %2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "*gtdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (gt:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmpgs.64 %2,%1,%0
  cmpgsi.64 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (gt:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmpgs.32 %2,%1,%0
  cmpgsi.32 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gthi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (gt:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmpgs.16 %2,%1,%0
  cmpgsi.16 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (gt:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmpgs.8 %2,%1,%0
  cmpgsi.8 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtudi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (gtu:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmpg.64 %2,%1,%0
  cmpgi.64 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtusi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (gtu:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmpg.32 %2,%1,%0
  cmpgi.32 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtuhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (gtu:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmpg.16 %2,%1,%0
  cmpgi.16 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*gtuqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (gtu:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmpg.8 %2,%1,%0
  cmpgi.8 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*ledi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (le:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmples.64 %2,%1,%0
  cmplesi.64 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*lesi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (le:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmples.32 %2,%1,%0
  cmplesi.32 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*lehi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (le:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmples.16 %2,%1,%0
  cmplesi.16 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (le:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmples.8 %2,%1,%0
  cmplesi.8 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leudi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (leu:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmple.64 %2,%1,%0
  cmplei.64 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leusi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (leu:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmple.32 %2,%1,%0
  cmplei.32 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leuhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (leu:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmple.16 %2,%1,%0
  cmplei.16 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "*leuqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (leu:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  cmple.8 %2,%1,%0
  cmplei.8 %2,%1,%0"
  [(set_attr "type" "inc")])

(define_insn "muldi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (mult:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  mul.64 %2,%1,%0
  muli.64 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (mult:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  mul.32 %2,%1,%0
  muli.32 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "mulhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (mult:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  mul.16 %2,%1,%0
  muli.16 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "mulqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (mult:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  mul.8 %2,%1,%0
  muli.8 %2,%1,%0"
  [(set_attr "type" "mul")])

(define_insn "divdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (div:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  divs.64 %2,%1,%0
  divsi.64 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "divsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (div:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  divs.32 %2,%1,%0
  divsi.32 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "divhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (div:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  divs.16 %2,%1,%0
  divsi.16 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "divqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (div:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  divs.8 %2,%1,%0
  divsi.8 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "udivdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (udiv:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  "" "@
  div.64 %2,%1,%0
  divi.64 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "udivsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (udiv:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  "" "@
  div.32 %2,%1,%0
  divi.32 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "udivhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (udiv:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  "" "@
  div.16 %2,%1,%0
  divi.16 %2,%1,%0"
  [(set_attr "type" "div")])

(define_insn "udivqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 (udiv:QI (match_operand:QI 1 "register_operand" "r,r")
		  (match_operand:QI 2 "regimm8_operand" "r,i")))]
  "" "@
  div.8 %2,%1,%0
  divi.8 %2,%1,%0"
  [(set_attr "type" "div")])


(define_expand "beq"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (EQ); }")
(define_expand "seq"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (EQ,operands); DONE; })

(define_expand "bne"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (NE); }")
(define_expand "sne"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (NE,operands); DONE; })

(define_expand "ble"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (LE); }")
(define_expand "sle"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (LE,operands); DONE; })

(define_expand "bleu"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (LEU); }")
(define_expand "sleu"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (LEU,operands); DONE; })

(define_expand "blt"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (LT); }")
(define_expand "slt"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (LT,operands); DONE; })

(define_expand "bltu"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (LTU); }")
(define_expand "sltu"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (LTU,operands); DONE; })

(define_expand "bgt"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (GT); }")
(define_expand "sgt"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (GT,operands); DONE; })

(define_expand "bgtu"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (GTU); }")
(define_expand "sgtu"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (GTU,operands); DONE; })

(define_expand "bge"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (GE); }")
(define_expand "sge"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (GE,operands); DONE; })

(define_expand "bgeu"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (GEU); }")
(define_expand "sgeu"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (GEU,operands); DONE; })

(define_expand "bordered"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (ORDERED); }")
(define_expand "sordered"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (ORDERED,operands); DONE; })

(define_expand "bunordered"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (UNORDERED); }")
(define_expand "sunordered"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (UNORDERED,operands); DONE; })

(define_insn "extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
               (sign_extend:DI (match_operand:SI 1 "register_operand" "r")))]
   "" "widen.32 %1,%0")
(define_insn "zero_extendsidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
                 (zero_extend:DI (match_operand:SI 1 "register_operand" "r")))]
   "" "move.32 %1,%0\t// zero_extend")

(define_insn "extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
               (sign_extend:DI (match_operand:HI 1 "register_operand" "r")))]
   "" "widen.16 %1,%0")
(define_insn "zero_extendhidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
                 (zero_extend:DI (match_operand:HI 1 "register_operand" "r")))]
   "" "move.16 %1,%0\t// zero_extend")

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
               (sign_extend:DI (match_operand:QI 1 "register_operand" "r")))]
   "" "widen.8 %1,%0")
(define_insn "zero_extendqidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
                 (zero_extend:DI (match_operand:QI 1 "register_operand" "r")))]
   "" "move.8 %1,%0\t// zero_extend")

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
               (sign_extend:SI (match_operand:HI 1 "register_operand" "r")))]
   "" "widen.16 %1,%0")
(define_insn "zero_extendhisi2"
   [(set (match_operand:SI 0 "register_operand" "=r")
                 (zero_extend:SI (match_operand:HI 1 "register_operand" "r")))]
   "" "move.16 %1,%0\t// zero_extend")

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
               (sign_extend:SI (match_operand:QI 1 "register_operand" "r")))]
   "" "widen.8 %1,%0")
(define_insn "zero_extendqisi2"
   [(set (match_operand:SI 0 "register_operand" "=r")
                 (zero_extend:SI (match_operand:QI 1 "register_operand" "r")))]
   "" "move.8 %1,%0\t// zero_extend")

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
               (sign_extend:HI (match_operand:QI 1 "register_operand" "r")))]
   "" "widen.8 %1,%0")
(define_insn "zero_extendqihi2"
   [(set (match_operand:HI 0 "register_operand" "=r")
                 (zero_extend:HI (match_operand:QI 1 "register_operand" "r")))]
   "" "move.8 %1,%0\t// zero_extend")

