;;- Machine description for GNU compiler, F-CPU, devik@cdi.cz


;;- Instruction patterns.  When multiple patterns apply,
;;- the first one in the file is chosen.
;;-
;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.
;;-
;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

(define_insn "movdi"
  [(set (match_operand:DI 0 "general_operand" "=r,m,r")
	(match_operand:DI 1 "general_operand" "r,r,m"))]
  ""
  "@
  move %1,%0
  store %0,%1
  load %1,%0")
(define_insn "movsi"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "register_operand" "r"))]
  ""
  "move.q %1,%0")
(define_insn "movhi"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(match_operand:HI 1 "register_operand" "r"))]
  ""
  "move.w %1,%0")
(define_insn "movqi"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(match_operand:QI 1 "register_operand" "r"))]
  ""
  "move.b %1,%0")

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "jmp %l0")

(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "register_operand" "r"))]
  ""
  "jmp %0")

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")

(define_insn "call"
  [(call (match_operand:QI 0 "general_operand" "m")
	 (match_operand:QI 1 "register_operand" "g"))]
  ""
  "call %r0")

(define_insn "call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:QI 1 "general_operand" "m")
	      (match_operand:QI 2 "register_operand" "g")))]
  ""
  "call %r0")
