divert(-1)
dnl binop_imm8(insn_name,mode,rtlop,asm,type,suff)
define(`binop_imm8',`(define_insn "$1"
  [(set (match_operand:$2 0 "register_operand" "=r,r")
	 ($3:$2 (match_operand:$2 1 "register_operand" "r,r")
		  (match_operand:$2 2 "regimm8_operand" "r,i")))]
  "" "@
  $4$6 %2,%1,%0
  $4i$6 %2,%1,%0"
  [(set_attr "type" "$5")])
')
define(`binopQI_imm8',`(define_insn "$1_qi"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	 ($3:QI (match_operand:$2 1 "register_operand" "r,r")
		  (match_operand:$2 2 "regimm8_operand" "r,i")))]
  "" "@
  $4$6 %2,%1,%0
  $4i$6 %2,%1,%0"
  [(set_attr "type" "$5")])
')
define(`unop',`(define_insn "$1"
  [(set (match_operand:$2 0 "register_operand" "=r")
	 ($3:$2 (match_operand:$2 1 "register_operand" "r")))]
  "" "$4$6 %1,%0"
  [(set_attr "type" "$5")])
')
dnl Like binop but specialized for plus op (convertible to add,sub,inc,dec)
define(`plusop',`(define_insn "$1"
  [(set (match_operand:$2 0 "register_operand" "=r,r")
	 (plus:$2 (match_operand:$2 1 "register_operand" "r,r")
		  (match_operand:$2 2 "regimm9_operand" "r,i")))]
  "" {
  if (which_alternative == 0) return "add$6 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc$6 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec$6 %1,%0";
  if (INTVAL(operands[2])<0) return "subi$6 $%n2,%1,%0";
  return "addi$6 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME
')
dnl Like binop but specialized for lshift as MULT
define(`lshop',`(define_insn "$1"
  [(set (match_operand:$2 0 "register_operand" "=r")
	 (mult:$2 (match_operand:$2 1 "register_operand" "r")
		  (match_operand:$2 2 "bitable_operand" "i")))]
  "exact_log2(INTVAL(operands[2]))>=0" "shiftli$6 %b2,%1,%0"
  [(set_attr "type" "rot")])
')
dnl conds(condition)
define(`conds',`(define_expand "b$1"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (translit(`$1', `a-z', `A-Z')); }")
(define_expand "s$1"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (translit(`$1', `a-z', `A-Z'),operands); DONE; })
')
dnl integer_extruncs(from,to,suff)
define(`int_extr',`(define_insn "extend`'translit(`$1',`A-Z',`a-z')`'translit(`$2',`A-Z',`a-z')2"
  [(set (match_operand:$2 0 "register_operand" "=r")
               (sign_extend:$2 (match_operand:$1 1 "register_operand" "r")))]
   "" "widen.$3 %1,%0")
(define_insn "zero_extend`'translit(`$1',`A-Z',`a-z')`'translit(`$2',`A-Z',`a-z')2"
   [(set (match_operand:$2 0 "register_operand" "=r")
                 (zero_extend:$2 (match_operand:$1 1 "register_operand" "r")))]
   "" "move.$3 %1,%0\t// zero_extend")
')

dnl for_modes(op,ipfx,isfx,rtlop,asm,type,[modes..])
	define(`for_modes',`dnl
		divert(0)indir($1,$2`'translit($7,`A-Z',`a-z')$3,$7,$4,$5,$6,$8)
divert(-1)ifelse($#,8, ,`for_modes(`$1',$2,$3,$4,$5,$6,dnl
			shift(shift(shift(shift(shift(shift(shift(shift($@)))))))))')')

define(`allmodes',`DI,.64,SI,.32,HI,.16,QI,.8')
define(`nonQmodes',`DI,.64,SI,.32,HI,.16')
# Standard arithmetic
for_modes(``binop_imm8'',umin,3,umin,min,inc,allmodes)
for_modes(``binop_imm8'',umax,3,umax,max,inc,allmodes)

for_modes(``unop'',neg,2,neg,neg,inc,allmodes)
for_modes(``unop'',abs,2,abs,abs,inc,allmodes)
for_modes(``unop'',one_cmpl,2,not,not,logic,allmodes)
for_modes(``unop'',ffs,2,ffs,lsb1,logic,allmodes)

for_modes(``lshop'',*ashlmul,3,dummy,dummy,dummy,allmodes)

for_modes(``binop_imm8'',ashl,3,ashift,shiftl,rot,allmodes)
for_modes(``binop_imm8'',ashr,3,ashiftrt,shiftra,rot,allmodes)
for_modes(``binop_imm8'',lshr,3,lshiftrt,shiftr,rot,allmodes)
for_modes(``binop_imm8'',rotl,3,rotate,rotl,rot,allmodes)
for_modes(``binop_imm8'',rotr,3,rotatert,rotr,rot,allmodes)

for_modes(``binop_imm8'',and,3,and,and,logic,allmodes)
for_modes(``binop_imm8'',ior,3,ior,or,logic,allmodes)
for_modes(``binop_imm8'',xor,3,xor,xor,logic,allmodes)

divert(0)
;; We need to be able to handle many immediates here. We can generate
;; addi,subi,inc and dec depending on imm value. Failing to provide
;; this leads to loading unnecessary constants to registers especially
;; during strength reduce. devik.
divert(-1)
for_modes(``plusop'',add,3,dummy,dummy,dummy,allmodes)
for_modes(``binop_imm8'',sub,3,minus,sub,add,allmodes)

# is F-CPU saturation unsigned ? YES
for_modes(``binop_imm8'',*addus,3,us_plus,adds,add,allmodes)
for_modes(``binop_imm8'',*subus,3,us_minus,subs,add,allmodes)

for_modes(``binop_imm8'',*gt,3,gt,cmpgs,inc,allmodes)
for_modes(``binop_imm8'',*gtu,3,gtu,cmpg,inc,allmodes)
for_modes(``binop_imm8'',*le,3,le,cmples,inc,allmodes)
for_modes(``binop_imm8'',*leu,3,leu,cmple,inc,allmodes)
dnl for_modes(``binop_imm8'',*eq,3,eq,xnor.and,logic2,allmodes)
dnl for_modes(``binop_imm8'',*ne,3,ne,xor.or,logic2,allmodes)

dnl for_modes(``binopQI_imm8'',*gt,3,lt,cmpgs,inc,nonQmodes)
dnl for_modes(``binopQI_imm8'',*gtu,3,ltu,cmpg,inc,nonQmodes)
dnl for_modes(``binopQI_imm8'',*le,3,le,cmples,inc,nonQmodes)
dnl for_modes(``binopQI_imm8'',*leu,3,leu,cmple,inc,nonQmodes)
dnl for_modes(``binopQI_imm8'',*eq,3,eq,xnor.and,logic2,nonQmodes)
dnl for_modes(``binopQI_imm8'',*ne,3,ne,xor.or,logic2,nonQmodes)

for_modes(``binop_imm8'',mul,3,mult,mul,mul,allmodes)
dnl for_modes(``binop_imm8'',div,3,div,divs,div,allmodes)
for_modes(``binop_imm8'',udiv,3,udiv,div,div,allmodes)

divert(0)
conds(eq)
conds(ne)
conds(le)
conds(leu)
conds(lt)
conds(ltu)
conds(gt)
conds(gtu)
conds(ge)
conds(geu)
conds(ordered)
conds(unordered)
int_extr(SI,DI,32)
int_extr(HI,DI,16)
int_extr(QI,DI,8)
int_extr(HI,SI,16)
int_extr(QI,SI,8)
int_extr(QI,HI,8)
