/*
 * error.c - error message handling
 * Copyright (C) 1995 - 2001 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

#include <common.h>
#include <elftools.h>
#include <stdio.h>
#include <stdarg.h>

static char *progname = NULL;

void
setprogname(const char *newname) {
	progname = xrealloc(progname, strlen(newname) + 1);
	strcpy(progname, newname);
}

static void
verror(const char *where, const char *what, const char *fmt, va_list ap) {
	fprintf(stderr, "%s: %s", where, what);
	vfprintf(stderr, fmt, ap);
	fprintf(stderr, "\n");
}

void
warn(const char *msg, ...) {
	va_list ap;

	va_start(ap, msg);
	verror(progname, "warning: ", msg, ap);
	va_end(ap);
}

void
file_warn(const char *fn, const char *msg, ...) {
	va_list ap;

	va_start(ap, msg);
	verror(fn, "warning: ", msg, ap);
	va_end(ap);
}

void
error(const char *msg, ...) {
	va_list ap;

	va_start(ap, msg);
	verror(progname, "", msg, ap);
	va_end(ap);
}

void
file_error(const char *fn, const char *msg, ...) {
	va_list ap;

	va_start(ap, msg);
	verror(fn, "", msg, ap);
	va_end(ap);
}

void
fatal(const char *msg, ...) {
	va_list ap;

	va_start(ap, msg);
	verror(progname, "fatal error: ", msg, ap);
	va_end(ap);
	abort();
}

void
file_fatal(const char *fn, const char *msg, ...) {
	va_list ap;

	va_start(ap, msg);
	verror(fn, "fatal error: ", msg, ap);
	va_end(ap);
	abort();
}
