/*
 * ldtarget.c -- ld target handling
 * Copyright (C) 2003 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

static const char rcsid[] = "@(#) $Id: ldtarget.c,v 1.2 2003/02/07 22:53:22 michael Exp $";

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <gelf.h>
#include <assert.h>

#include <ld/ld.h>
#include <ld/ldmisc.h>

#define PRIME	11u

static struct target *targets[PRIME];

struct target*
ld_select_target(const GElf_Ehdr *eh) {
	struct target *p;
	unsigned hash;

	hash = eh->e_machine;
	hash = (hash << 2) ^ eh->e_ident[EI_DATA];
	hash = (hash << 2) ^ eh->e_ident[EI_CLASS];
	for (p = targets[hash % PRIME]; p; p = p->next) {
		assert(p->name);
		if (p->machine == eh->e_machine
		 && p->class == eh->e_ident[EI_CLASS]
		 && p->data == eh->e_ident[EI_DATA]) {
			debug("using `%s' target", p->name);
			return p;
		}
	}
	return NULL;
}

void
ld_register_target(struct target *p) {
	unsigned hash;

	assert(p);
	assert(p->name);
	debug("registering `%s' target", p->name);
	hash = p->machine;
	hash = (hash << 2) ^ p->data;
	hash = (hash << 2) ^ p->class;
	p->next = targets[hash % PRIME];
	targets[hash % PRIME] = p;
}
