/*
 * ldmisc.h -- functions exported by ldmisc.c
 * Copyright (C) 2000 - 2003 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* @(#) $Id: ldmisc.h,v 1.2 2003/02/07 03:19:24 michael Exp $ */

extern void setprogname(const char *newname);

extern void debug(const char *fmt, ...);

extern void warn(const char *fmt, ...);
extern void error(const char *fmt, ...);
extern void fatal(const char *fmt, ...);
extern void file_warn(const char *fn, const char *fmt, ...);
extern void file_error(const char *fn, const char *fmt, ...);
extern void file_fatal(const char *fn, const char *fmt, ...);

extern void *xmalloc(size_t n);
extern void *xrealloc(void *p, size_t n);
extern char *xstrdup(const char *s);
extern void xfree(void *p);

extern int errors;
