/*
 * ld.h -- common definitions for ld(1)
 * Copyright (C) 2000 - 2003 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

/* @(#) $Id: ld.h,v 1.33 2003/02/08 13:07:01 michael Exp $ */

#include <ld/missing.h>

struct current {
	char *fn;			/* filename */
	Elf *elf;			/* ELF descriptor */
	GElf_Ehdr eh;		/* ELF header */
	struct section {	/* sections */
		GElf_Shdr sh;	/* section header */
		Elf_Scn *scn;	/* section descriptor */
		unsigned flags;
#define LDSF_NEEDED		0x0001	/* section must be copied */
		size_t off;		/* offset in output section */
		struct outscn *out;
	} *scns;
	size_t nscns;		/* number of sections */
	size_t shstrndx;	/* string table section index */
	GElf_Sym *syms;		/* .symtab */
	GElf_Word *shndx;	/* .symtab_shndx */
	size_t nsyms;		/* size of .symtab */
	size_t lsyms;		/* size of local part of .symtab */
	char *strs;			/* .strtab */
	char *names;		/* .shstrtab */
	size_t *stable;		/* symbol translation table */
	/* shared libs only */
	GElf_Dyn *dyns;		/* .dynamic */
	size_t ndyns;		/* size of .dynamic */
	char *dstrs;		/* .dynstr */
	size_t ndstrs;		/* size of .dynstr */
	char *soname;		/* SONAME */
};

extern struct current cur;

extern char *ld_opt_rpath;
extern char ld_opt_dynamic;
extern char ld_opt_ignore_libpath;
extern char ld_opt_no_size_warn;
extern char ld_opt_strip;
extern char ld_opt_weakextract;
extern char ld_opt_whole_archive;
extern char ld_opt_zdefs;
extern char ld_opt_zmuldefs;
extern int ld_target_type;		/* ET_REL, ET_DYN or ET_EXEC */

extern char *outfn;		/* output filename */

extern Elf *aelf;
extern GElf_Ehdr aeh;

#define SYMBOLS_MAX	0x1000000	/* Max. number of symbols for Elf32 */

struct gsym {
	GElf_Sym sym;
	GElf_Word chain;	/* hash table link */
	unsigned long hash;
	struct outscn *sect;
	GElf_Word shndx;
};
extern struct gsym *aglobals;
extern struct gsym *alocals;
extern size_t anglobs;
extern size_t anlocs;

extern Elf_Data ashstrtab;
extern Elf_Data astrtab;

extern Elf_Scn* ld_make_output_section(const char *__name, GElf_Shdr *__sh, int __makedata);
extern char *ld_symbol_name(size_t offset);
extern int ld_add_ar_members(const char *__fn, int __fd, Elf *__arf, int __islib, int __all);
extern int ld_add_elf_file(const char *__fn, size_t __noff, Elf *__elf);
extern int ld_add_elf_object(void);
extern int ld_add_elf_shlib(void);
extern int ld_add_file(const char *__fn, int __fd, Elf *__elf, int __islib);
extern int ld_add_shlib_dependency(const char *__fn, int __fd, Elf *__elf, Elf_Data *__dsym, size_t __num);
extern int ld_copy_data_sections(void);
extern int ld_copy_relocs(void);
extern int ld_copy_symbols(void);
extern int ld_file_type_match(void);
extern int ld_needed_sections(void);
extern int ld_output(const char *entry_point);
extern int ld_process_file(const char *__name, int __solibs_too);
extern int ld_reloc_deps(size_t __i, int *__found);
extern int ld_scan_file(const char *__fn, size_t __noff, Elf *__elf);
extern int ld_undefined_symbols(void);
extern size_t ld_add_string(Elf_Data *__data, const char *__str);
extern size_t ld_find_symbol(const char *__name, unsigned long __hash);
extern size_t ld_resolve_symbol(const char *fn, const char *name, const GElf_Sym *sym, struct outscn *sect);
extern size_t ld_section_symbol(size_t index);
extern size_t ld_undef_symbol(const char *__name);
extern void cleanup(int status);
extern void ld_add_libdir(const char *__dir);
extern void ld_init_libpath(void);
extern void ld_set_deflibpath(const char *s);
extern void ld_symbol_addr(struct gsym *gsym);
extern void ld_symbol_index(struct gsym *gsym);

struct outscn {
	struct outscn *next;
	const char *name;
	GElf_Shdr shdr;
	char *buf;
	GElf_Rela *rela;
	GElf_Rel *rel;
	size_t nrela;
	size_t nrel;
	Elf_Scn *scn;
};

struct segment {
	struct segment *next;
	struct outscn *scns;
	const char *name;
	GElf_Phdr phdr;
};

struct scnmap {
	struct scnmap *next;
	struct segment *seg;
	const char *name;
	GElf_Word type;
	GElf_Xword flags;
	GElf_Xword fmask;
	const char **files;
	size_t nfiles;
};

extern struct segment*
	ld_map_section(const char *fn, const char *name, const GElf_Shdr *sh);
extern struct outscn*
	ld_output_section(const char *fn, const char *name, const GElf_Shdr *sh);
extern struct outscn*
	ld_dummy_section(const char *name, GElf_Word type, GElf_Xword flags);

extern struct segment *segments;

extern struct segment *const text_segment;
extern struct segment *const data_segment;
extern struct segment *const note_segment;

struct target {
	struct target *next;
	const char *name;
	unsigned char class;
	unsigned char data;
	GElf_Half machine;
	GElf_Addr load_address;
	GElf_Addr page_size;
	GElf_Word rel_size;
	GElf_Word rela_size;
	int (*copy_rel)(struct target*, struct outscn*);
	int (*copy_rela)(struct target*, struct outscn*);
	int (*apply_rel)(struct target*, struct outscn*);
	int (*apply_rela)(struct target*, struct outscn*);
};

extern struct target *ld_select_target(const GElf_Ehdr *eh);
extern void ld_register_target(struct target *target);
extern int generic_copy_rel(struct target *tgt, struct outscn *sect);
extern int generic_copy_rela(struct target *tgt, struct outscn *sect);
extern GElf_Addr ld_get_data(const unsigned char *place, size_t size, int be);
extern void ld_put_data(unsigned char *place, size_t size, GElf_Addr value, int be);

extern struct target *target;
