/*
 * asstats.c -- print fcpu-as instruction statistics
 * Copyright (C) 2003 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

static const char rcsid[] = "@(#) $Id: asstats.c,v 1.1 2003/02/03 18:04:36 michael Exp $";

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <assert.h>

#include <as/eatypes.h>
#include <fcpu_opcodes/fcpu_opcodes.h>

int
main(int argc, char **argv) {
	const char *name;
	int fd;
	unsigned i;
	word_t *p;

	if (argc != 2) {
		fprintf(stderr, "usage: asstats infile\n");
		exit(1);
	}
	fd = open(argv[1], O_RDONLY);
	if (fd == -1) {
		perror(argv[1]);
		exit(1);
	}
	p = mmap(0, 258 * sizeof(*p), PROT_READ, MAP_SHARED, fd, 0);
	if (p == (word_t*)-1) {
		perror("mmap");
		close(fd);
		exit(1);
	}
	for (i = 0; i < 256; i++) {
		if (p[i]) {
			if ((name = fcpu_opcode_name(i << 24))) {
				printf("%8Lu\t%s\n", p[i], name);
			}
			else {
				fprintf(stderr, "can't decode opcode %u\n", i);
			}
		}
	}
	if (p[256]) printf("%8Lu\tjmp{cc}\n", p[256]);
	if (p[257]) printf("%8Lu\tmove{cc}\n", p[257]);
	exit(0);
}
