-- simple_sram.vhdl -- Dummy SRAM for F-CPU Register File Implementations
-- Copyright (C) 2003 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- @(#) $Id: simple_sram.vhdl,v 1.1 2003/06/16 01:43:23 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity SRAM is
	generic (
		LOG_LINES : integer := 3;	-- 8 lines
		WIDTH : integer := 8		-- 8 bits/line
	);
	port (
		RA : in std_ulogic_vector(LOG_LINES-1 downto 0);
		WA : in std_ulogic_vector(LOG_LINES-1 downto 0);
		RE : in std_ulogic;
		WE : in std_ulogic;
		WD : in std_ulogic_vector(WIDTH-1 downto 0);
	--
		RD : out std_ulogic_vector(WIDTH-1 downto 0)
	);
end SRAM;

architecture Behave of SRAM is
	constant LINES : integer := 2 ** LOG_LINES;
	subtype word is std_ulogic_vector(WIDTH-1 downto 0);
	type matrix is array(LINES-1 downto 0) of word;
	signal RAM : matrix;
begin
	-- write
	process (WA, WE, WD)
	begin
		if to_X01(WE) = '1' then
			RAM(to_integer(unsigned(WA))) <= WD;
		end if;
	end process;

	-- read
	process (RAM, RA, RE)
	begin
		if to_X01(RE) = '1' then
			RD <= RAM(to_integer(unsigned(RA)));
		else
			RD <= (others => 'Z');
		end if;
	end process;
end Behave;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
