-- regfile.vhdl -- F-CPU Register File Implementations
-- Copyright (C) 2003, 2004 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- @(#) $Id: regfile.vhdl,v 1.2 2004/02/15 16:38:33 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

use work.FCPU_config.all;

entity RegFile is
	port (
		-- write data
		WD0 : in F_VECTOR;
		WD1 : in F_VECTOR;
		-- write address
		WA0 : in std_ulogic_vector(5 downto 0);
		WA1 : in std_ulogic_vector(5 downto 0);
		-- write enable
		WE0 : in std_ulogic;
		WE1 : in std_ulogic;
		-- read address
		RA0 : in std_ulogic_vector(5 downto 0);
		RA1 : in std_ulogic_vector(5 downto 0);
		RA2 : in std_ulogic_vector(5 downto 0);
		-- read enable
		RE0 : in std_ulogic;
		RE1 : in std_ulogic;
		RE2 : in std_ulogic;
	--
		-- read data
		RD0 : out F_VECTOR;
		RD1 : out F_VECTOR;
		RD2 : out F_VECTOR
	);
end RegFile;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
