-- shl.vhdl - Bit-Shuffling Execution Unit for the F-CPU.
-- Copyright (C) 2000 - 2003 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- @(#) $Id: shl.vhdl,v 1.7 2003/04/18 17:03:59 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

use work.FCPU_config.all;

entity EU_SHL is
	port(
		-- operands
		Din_0            : in F_VECTOR;	-- shiftee
		Din_1            : in F_VECTOR;	-- shift count / alternate input
		-- Operating Mode (should be derived from opcode)
		CommonShiftCount : in std_ulogic;
		ShiftL           : in std_ulogic;
		ShiftR           : in std_ulogic;
		ShiftRA          : in std_ulogic;
		RotL             : in std_ulogic;
		RotR             : in std_ulogic;
		Bitrev           : in std_ulogic;
		Byterev          : in std_ulogic;
		Permute          : in std_ulogic;
		Mix              : in std_ulogic;
		Expand           : in std_ulogic;
		Cshift           : in std_ulogic;
		Widen            : in std_ulogic;
		-- flag bits (directly copied from instruction word)
		Flags            : in std_ulogic_vector(13 downto 8);
		-- SIMD mode bits (decoded)
		Size             : in std_ulogic_vector(LOGMAXSIZE-1 downto 0);
		-- clock/reset/enable inputs (unused)
		Clk              : in std_ulogic;
		Rst              : in std_ulogic;
		En               : in std_ulogic;
	--
		-- outputs
		Dout_0           : out F_VECTOR;	-- regular output
		Dout_1           : out F_VECTOR		-- alternate output
	);
end EU_SHL;

architecture Struct_1 of EU_SHL is
	component Shuffle64
		generic (
			WIDTH : natural := 64
		);
		port (
			A : in std_ulogic_vector(WIDTH-1 downto 0);
			B : in std_ulogic_vector(WIDTH-1 downto 0);
			CommonShiftCount : in std_ulogic;
			ShiftL : in std_ulogic;
			ShiftR : in std_ulogic;
			ShiftRA : in std_ulogic;
			RotL : in std_ulogic;
			RotR : in std_ulogic;
			Bitrev : in std_ulogic;
			Byterev : in std_ulogic;
			Permute : in std_ulogic;
			Mix : in std_ulogic;
			Expand : in std_ulogic;
			Cshift : in std_ulogic;
			Widen : in std_ulogic;
			U : in std_ulogic_vector(2 downto 0);
			Clk : in std_ulogic;
			Rst : in std_ulogic;
			En : in std_ulogic;
		--
			Y : out std_ulogic_vector(WIDTH-1 downto 0);
			Z : out std_ulogic_vector(WIDTH-1 downto 0)
		);
	end component;
begin
	instantiate : Shuffle64
		generic map (WIDTH => UMAX)
		port map (
			A => Din_0,
			B => Din_1,
			CommonShiftCount => CommonShiftCount,
			ShiftL => ShiftL,
			ShiftR => ShiftR,
			ShiftRA => ShiftRA,
			RotL => RotL,
			RotR => RotR,
			Bitrev => Bitrev,
			Byterev => Byterev,
			Permute => Permute,
			Mix => Mix,
			Expand => Expand,
			Cshift => Cshift,
			Widen => Widen,
			U => Size(2 downto 0),
			Clk => Clk,
			Rst => Rst,
			En => En,
			Y => Dout_0,
			Z => Dout_1
		);
end Struct_1;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
