-- misc.vhdl -- Miscelleanous stuff
-- Copyright (C) 2000, 2001 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- $Id: misc.vhdl,v 1.4 2001/08/22 13:49:36 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

package Misc is
	-- 3-input xor
	function xor3 (a, b, c : std_ulogic) return std_ulogic;
	function xor3 (a, b, c : std_ulogic_vector) return std_ulogic_vector;

	-- 2-of-3 majority gate
	function maj23 (a, b, c : std_ulogic) return std_ulogic;
	function maj23 (a, b, c : std_ulogic_vector) return std_ulogic_vector;

	-- integer logarithm (rounded up)
	function ilog (a : positive; base : natural := 2) return natural;
end Misc;

package body Misc is
	function xor3 (a, b, c : std_ulogic) return std_ulogic is
	begin
		return a xor b xor c;
	end xor3;

	function xor3 (a, b, c : std_ulogic_vector) return std_ulogic_vector is
	begin
		return a xor b xor c;
	end xor3;

	function maj23 (a, b, c : std_ulogic) return std_ulogic is
	begin
		return (a and b) or (b and c) or (c and a);
	end maj23;

	function maj23 (a, b, c : std_ulogic_vector) return std_ulogic_vector is
	begin
		return (a and b) or (b and c) or (c and a);
	end maj23;

	function ilog (a : positive; base : natural := 2) return natural is
		variable x, y : natural;
	begin
		x := a;
		for y in 1 to 32 loop
			if x <= base then
				return y;
			end if;
			x := x / base;
		end loop;
		-- overflow condition
		return 0;
	end ilog;
end Misc;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
