/* 
  f-cpu/c/toplevel/fcpusim.c
  view status and menu interface for F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

#include <fcpusim_view.h>

#include <fetcher_view.c>
#include <registers_view.c>
#include <xbar_view.c>
#include <eu_inc_view.c>
#include <eu_asu_view.c>

void g(void){
  /* if (use_colors){ */
  printf("%c[1;33;44m",0x1B);
}

void n(void){
  /* if (use_colors){ */
  printf("%c[0;37;40m",0x1B);
}

void status_view(void){
  printf("\n");
  printf("________________________________________");
  printf("_______________________________________\n");
  printf("status after cycle ");
  g(); printf("%d" , cycle_counter); n();
  printf(" :\n");
  if (view == "f"){ fetcher_view(); }
  if (view == "r"){ registers_view(); }
  if (view == "x"){ xbar_view(); }
  if (view == "a"){ eu_asu_view(); }
  if (view == "i"){ eu_inc_view(); }
}


void menu(void){
  int do_next_cycle;
  do {
    status_view();
    printf("f=fetcher r=registers x=xbar a=asu i=inc <enter>=next_cycle q=quit ");
    scanf("%c",&c);
    do_next_cycle = 0;
    if  (c==10 )           { do_next_cycle = 1; }
    if ((c=='f')|(c=='F')) { view = "f"; scanf("%c",&c);} /* fetcher */
    if ((c=='r')|(c=='R')) { view = "r"; scanf("%c",&c);} /* registers */
    if ((c=='x')|(c=='X')) { view = "x"; scanf("%c",&c);} /* xbar */
    if ((c=='a')|(c=='A')) { view = "a"; scanf("%c",&c);} /* asu */
    if ((c=='i')|(c=='I')) { view = "i"; scanf("%c",&c);} /* inc */
    if ((c=='q')|(c=='Q')) { quit_fcpusim = 1; do_next_cycle = 1; scanf("%c",&c);}
  } while (do_next_cycle==0);
}



