/*

YGTK.C : Whygee's dirty & small X11 library.

Big thanks to the 9wm guys, their source helped me a lot :-)))

   rev.2 : if (gc!=NULL)... 
   rev.3 : ifndef... pour eviter l'inclusion multiple, et aussi
    KeyPressMask pour gerer le clavier, MotionNotify pour la souris...
   rev 4 pour le F-CPU
   rev 5 : english...
   rev 6 : added min_size, position etc in xsh
   rev 7 : better font support, better windowing...
       and discovery of XMoveWindow, keysyms etc :-)
*/

#ifndef YGTK

#define YGTK

#include <string.h>
#include <stdio.h>

/* external files */
#include <X11/Xlib.h>
#include <X11/Xutil.h>

char *fontlist[] = {
 "-ADOBE-NEW CENTURY SCHOOLBOOK-MEDIUM-R-NORMAL--*-140-*-*-P-*",
 "lucm.latin1.9",
 "blit",
 "9x15bold",
 "lucidasanstypewriter-12",
 "fixed",
 "*",
 0,
};

/*
some scratchpad :

 dx = 0;
 for (n = 0; m->item[n]; n++) {
   wide = XTextWidth(font, m->item[n], strlen(m->item[n])) + 4;
   if (wide > dx)
     dx = wide;
 
void getmouse(x, y, s)
int *x; int *y;
ScreenInfo *s;
{
  Window dw1, dw2;
  int t1, t2;
  unsigned int t3;
  XQueryPointer(dpy, s->root, &dw1, &dw2, x, y, &t1, &t2, &t3);
}

void setmouse(x, y, s)
int x; int y; ScreenInfo *s;
{
  XWarpPointer(dpy, None, s->root, None, None, None, None, x, y);
}

*/

/*  Window attribute when creating it...  */
#define HIDDEN 1
#define SHOWN 0
#define TRUE 1
#define FALSE 0

/* color definition : */
char *color_table[] = {
 "dark slate blue",
 "light grey",
 "firebrick",
 "blue",
 "red",
 "green",
 "white",
 "black",
 "grey",
 "yellow",
 "orange",
 "sea green",
 "dim grey",
 "grey12",
 "grey25",
 "grey34",
 "grey40",
 "grey55" };
#define dark_slate_blue 0
#define light_grey 1
#define firebrick 2
#define blue 3
#define red 4
#define green 5
#define white 6
#define black 7
#define grey 8
#define yellow 9
#define orange 10
#define seagreen 11
#define dim_grey 12
#define grey18 13
#define grey25 14
#define grey34 15
#define grey40 16
#define grey55 17
/* for more colors, lookup /usr/X11/lib/X11/rgb.txt */

/* Some global variables that makes life a lot  easier :-) */

/*Font font;*/
int display_is_open=0;
XFontStruct *font;
Display *dpy;
Screen *screen;
XSetWindowAttributes xswa;
XSizeHints xsh;
XGCValues xgcv;

static void exitX ()
{
  XCloseDisplay (dpy);
}

/*
this part is avoided : dirty exit... and not much used...
void error(const char *str)
{
  fprintf(stderr,"\nerror: %s\n",str);
  exitX();
  exit(1);  
}
*/

/* to be called before any window is displayed */
static void init_X ()
{
  char *fname;
  int i=0;
  dpy = XOpenDisplay(0);
  if (!dpy) {
    printf ("Can't open display !\n");
    exit(2); /* error is not used, it core dumped all the time... */
  }
  display_is_open=1;
  screen = XDefaultScreenOfDisplay (dpy);
  XSynchronize (dpy, 1);

  for (;;) {
    fname = fontlist[i++];
    if (fname == 0) {
      fprintf(stderr, "warning: can't find a font\n");
      break;
    }
    font = XLoadQueryFont(dpy, fname);
    if (font != 0) {
      /* fprintf(stderr, "loaded font %s\n",fname);*/
      break;
    }
  }
  xgcv.font = font->fid;
  xgcv.line_width = 1;
  xgcv.line_style = LineSolid;
}

static int doDefineColor (int a)
{
  XColor exact_color, screen_color;
  char *colptr=color_table[a];
  if (XAllocNamedColor (dpy,XDefaultColormapOfScreen (screen),
    colptr, &screen_color, &exact_color))
    return screen_color.pixel;
  /* else : exit... */
  fprintf(stderr,"\nProblem with color %s",colptr);
  /*  error("Color not allocated. (lazy allocation)");*/
  return 0;
}

static void open_window (Window *win_, int win_x, int win_y, int win_width,
      int win_height, int min_width, int min_height,
      GC *gc, int win_foreground, int win_background, char *win_name, int hidden)
{
  xsh.x = win_x;
  xsh.y = win_y;
  xsh.width = win_width;
  xsh.height = win_height;
  xsh.min_width = min_width;
  xsh.min_height = min_height;
  xsh.flags = PPosition | PSize | PMinSize;
  xswa.event_mask = ButtonPressMask | ExposureMask | ResizeRedirectMask 
    | KeyPressMask | KeyReleaseMask | PointerMotionMask | ButtonReleaseMask ;
  xswa.background_pixel = doDefineColor(win_background);
  xgcv.background = xswa.background_pixel;
  xgcv.foreground = doDefineColor (win_foreground);
  *win_ = XCreateWindow( dpy,XRootWindowOfScreen (screen),
    win_x, win_y, win_width, win_height, 0, XDefaultDepthOfScreen (screen), InputOutput,
    XDefaultVisualOfScreen (screen), CWEventMask | CWBackPixel , &xswa);
  XStoreName (dpy, *win_,win_name);
  if (gc!=NULL)
    *gc = XCreateGC (dpy, *win_, GCForeground | GCBackground | GCFont
           | GCLineWidth | GCLineStyle, &xgcv);
  XSetNormalHints (dpy, *win_,&xsh);
  if (hidden!=HIDDEN)
    XMapWindow (dpy, *win_);
}

static void open_daughter_window (Window *win_,
   Window mother_win, int pos_x, int pos_y, int win_width, int win_height,
   GC *gc, int win_foreground, int win_background, int thickness)
{
  xsh.x = pos_x;
  xsh.y = pos_y;
  xsh.width = win_width;
  xsh.height = win_height;
  xsh.flags = PPosition | PSize;
  xswa.event_mask = ButtonPressMask | ExposureMask | KeyPressMask | KeyReleaseMask
    | PointerMotionMask | ButtonReleaseMask ;
  xswa.background_pixel = doDefineColor(win_background);
  xgcv.background = xswa.background_pixel;
  xgcv.foreground = doDefineColor(win_foreground);
  *win_ = XCreateWindow (dpy, mother_win, pos_x, pos_y, win_width,
     win_height, thickness,XDefaultDepthOfScreen(screen), InputOutput,
     XDefaultVisualOfScreen(screen),CWEventMask | CWBackPixel , &xswa);
  XMapWindow (dpy, *win_);
  XSetNormalHints (dpy, *win_, &xsh);
  if (gc!=NULL)
    *gc = XCreateGC (dpy, *win_,GCForeground | GCBackground | GCFont
           | GCLineWidth | GCLineStyle, &xgcv);
}

static void close_window (Window *win_)
{
  XUnmapWindow (dpy, *win_);
  XDestroyWindow (dpy, *win_);
}

#endif
