 /*

Whygee's GNL nodes file (C) Yann Guidon 29 mars 2000
This is free software ; see the GPL for copying conditions.
There is NO warranty, not even for MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.

whygee@f-cpu.org

 */


typedef struct struct_string_cell{
  void * next; /* void if last */
  int size; /* zero if none */
  /* the "data" is at the end of the cell descriptor */
}string_cell;

string_cell * last_string=NULL;

typedef struct struct_op_node {
  void * next; /* void if last */
  string_cell * comment;
  int number, type;
} op_node;


typedef struct struct_line_list {
  void * next; /* void if last */
  string_cell * comment;
  int xoffset;
  op_node *node;
} line_list;

typedef struct struct_cycle_list {
  void * next; /* void if last */
  int yoffset,xoffset;
  line_list *lines;
} cycle_list;

typedef struct struct_sheet_list {
  void * next; /* void if last */
  string_cell * comment, * date, * library;
  int number;
  cycle_list *cycles;
} sheet_list;

typedef struct struct_root_cell {
  int revision;
  string_cell * comment, *title, * copyright;
  op_node *opnode;
  sheet_list *sheets;
} type_root_cell;
type_root_cell root_cell;
