/*
<HTML><TITLE>Whygee's dirty Xlib'ed interface</TITLE><BODY BGCOLOR="#FFFFFF" FGCOLOR="#000000"><PRE>

 (C) mars 2000 by Yann Guidon, placed under GPL

Uses <A HREF="ygtk.c">ygtk.c</A>, includes <A HREF="view1.c">view1.c</A>, Xlib, events, etc...

One day, it will import and export VHDL, PostScript, HTML, C, Pascal, ADA,
and assembly langage from any CPU etc...

 */

/* home-brewed minimalistic X toolkit */
#include "ygtk.c"
/* for the keys */
#include <X11/keysym.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>


void error(int n, char *s); /* it is defined once exit_and_save_config is defined too */
#include "memory.c"
#include "nodes.c"

block_header *ll_warning=NULL; /* linked list root for the warning messages */
block_header *ll_filelist=NULL; /* linked list root for the file names (during brwosing) */
block_header *ll_string=NULL; /* linked list root for the strings (FLEX tokens) */


#include "flex_gnl.c"

#include "globals.c"

void change_message(char *c){
  bottom_message=c;
  msglength=strlen(c);
  XClearWindow(dpy,win_message);
  XDrawImageString(dpy,win_message,gc2,4,font->ascent+2,c,msglength);
}


#include "view1.c"

#include "win_geom.c"

#include "browse.c"

int read_int(void){
  int value=0;
  int c=fgetc(geom_file);
  /* remove spaces : */
  while ((c!=EOF)&&((c<'0')||(c>'9')))
    c=fgetc(geom_file);
  if (c==EOF)
    return 0;
  /* read decimal number without much overflow checkings... */
  while ((c!=EOF)&&((c>='0')&&(c<='9'))) {
    value=(value*10)+(c-'0');
    c=fgetc(geom_file);
  }
  ungetc(c,geom_file);
  return value;
}

void read_string(char *d){
  int i=0;
  int c;
  /* remove spaces : */
  do 
    c=fgetc(geom_file);
  while (c==' ');
  if (c==EOF)
    return;

  while ((c!=EOF)&&(c!='\n')) {
    d[i++]=c;
    c=fgetc(geom_file);
  }
  d[i]=0;
}

void exit_and_save_config(int exit_code){
  /* collect here the X geometry of the window and save it to a file */
  if (display_is_open) {
    geom_file=fopen(geom_file_name,"wb");
    if ((geom_file!=NULL)&&(resize==0)) {
      XGetGeometry(dpy,win_main,&wdumb,&main_xpos,&main_ypos,&main_xsize,&main_ysize,&dumb,&dumb);
      fprintf(geom_file,"%d %d %d %d %d %d %d\n",main_xsize,main_ysize,main_xpos,main_ypos,right_window_width,vmoving1,vmoving2);
      fclose(geom_file);
    }
    path_file=fopen(path_file_name,"wb");
    if (path_file) {
      fprintf(path_file,"%s\n%s\n",directory_load,current_file);
      fclose(path_file);
    }
    close_window(&win_main);
    exitX();
  }
  exit(exit_code);
}

/* fatal signals handler : */
void sighandler_general(int signum){
  fprintf(stderr,"\nexit on signal %d\n",signum);
  exit_and_save_config(signum);
}

void error(int n, char *s) {
  fprintf(stderr,s);
  exit_and_save_config(n);
}

int main(int argc, char **argv)
{
  /* signals are caught to prevent data loss... */
  signal(SIGSEGV, sighandler_general);  /* "count=*(int *)NULL;" */
  signal(SIGTERM, sighandler_general);  /* Ctrl+C */
  signal(SIGINT, sighandler_general);
  signal(SIGBUS, sighandler_general);
  signal(SIGHUP, sighandler_general);
  /* not all signals are handled yet. */

 /* signal(SIGALRM, sig_handler_ALRM);
  setitimer(ITIMER_REAL,&mytimer_RT,NULL);  for autosave etc, later...  */

  /* X11 */
  init_X();
  XGetGeometry(dpy,RootWindow(dpy,DefaultScreen(dpy)),
    &wdumb,&dumb,&dumb,&root_width,&root_height,&dumb,&bitdepth);
  main_xpos=50;
  main_ypos=50;
  main_xsize=root_width-100;
  main_ysize=root_height-100;
  right_window_width=main_xsize>>2;
  vmoving1=WINMINSIZE;
  vmoving2=main_ysize-(main_ysize/5);

  /* read the init file here, remember the window positions... if they are valid !*/
  if ((geom_file=fopen(geom_file_name,"rb"))!=NULL) {
    main_xsize=read_int();
    main_ysize=read_int();
    main_xpos=read_int();
    main_ypos=read_int();
    right_window_width=read_int();
    vmoving1=read_int();
    vmoving2=read_int();
    fclose(geom_file);
  }

  if ((main_xsize<min_xsize)||(main_xsize>root_width))
    main_xsize=root_width-100;
  if ((main_ysize<min_ysize)||(main_ysize>root_height))
    main_ysize=root_height-100;
  if (main_xpos>(root_width-main_xsize))
    main_xpos=(root_width-main_xsize)>>1;
  if (main_ypos>(root_height-main_ysize))
    main_ypos=(root_height-main_ysize)>>1;
  if ((right_window_width<WINMINSIZE)||(right_window_width>(main_xsize-WINMINSIZE)))
    right_window_width=main_xsize>>2;
  if ((vmoving1<WINMINSIZE)||(vmoving1>main_ysize-(2*WINMINSIZE)))
    vmoving1=main_ysize/5;
  if ((vmoving2<vmoving1+WINMINSIZE)||(vmoving2>main_ysize-WINMINSIZE))
    vmoving2=main_ysize-WINMINSIZE;

  if ((geom_file=fopen(path_file_name,"rb"))!=NULL) {
    read_string(directory_load);
    read_string(current_file);
    fclose(geom_file);
  }

  make_all_windows();

  if (argc > 1) /* skip over program name */
    memcpy(current_file,argv[1],strlen(argv[1])+1); /* override the  */

  if (current_file[0]) {
    fprintf(stderr,"scanning GNL file %s\n",current_file);
    if (scan_GNL(current_file)) {
      string_cell * p=first_warning;
      current_file[0]=0; /* clear the string */
      /* dump of the error messages : */
      while (p!=NULL) {
	fprintf(stderr,"%s\n",((char*)p)+sizeof(string_cell));
	p=p->next;
      }
    }
  }

  /* main loop */  
  do {
XLoop: /* i replaced all the "break;" by "goto XLoop;" because some breaks didn't completely break... */
    XNextEvent(dpy,&event);
    switch(event.type) {

      case ResizeRequest:
        if (event.xresizerequest.window!=win_main)
          goto XLoop;
resize_main:
        xswa.event_mask&= ~ResizeRedirectMask;
        XChangeWindowAttributes(dpy,win_main,CWEventMask, &xswa);
        XSync(dpy,0); /*<FONT COLOR=#C00000> very important, otherwise we loop endlessly ! </FONT>*/
        XResizeWindow(dpy, win_main,event.xresizerequest.width,event.xresizerequest.height);
        XSync(dpy,0); /*<FONT COLOR=#C00000> very important, otherwise we loop endlessly ! </FONT>*/
        xswa.event_mask|= ResizeRedirectMask;
        XChangeWindowAttributes(dpy,win_main,CWEventMask, &xswa);
        resize=1;
        XSync(dpy,0); /* another one, just in case... */
        goto redisplay;

      case Expose:
	if (event.xexpose.count|moving_button1|vmoving_button)
	  goto XLoop;

        if (event.xexpose.window==win_main){
redisplay:
          XGetGeometry(dpy,win_main,&wdumb,&dumb,&dumb,&main_xsize2,&main_ysize2,&dumb,&dumb);

          i=0;
          if (main_xsize2< min_xsize) {
            main_xsize2=min_xsize;
            i=1;
	  } 
	  if (main_ysize2< min_ysize) {
            main_ysize2=min_ysize;
            i=1;
          } 
          if (i) {
	    fprintf(stderr,"main window undersize detected, re-resize manually\n");
	    event.xresizerequest.width=main_xsize2;
	    event.xresizerequest.height=main_ysize2;
	    goto resize_main;
	  }

          if ((resize)||(main_xsize!=main_xsize2)||(main_ysize!=main_ysize2)) {
	    /* recompute the coordinates ! */

            /* this depends on the old coordinates : */
	    i=(right_window_width*main_xsize2)/main_xsize;
                  /* protected from /0 par min_xsize */
            vmoving1=(vmoving1*(main_ysize2-menuheight))/(main_ysize-menuheight);
            vmoving2=(vmoving2*(main_ysize2-menuheight))/(main_ysize-menuheight);

	    /* "validate" the new coordinates */
            main_xsize=main_xsize2;
	    main_ysize=main_ysize2;

	    /* this depends on the new coordinates : */
            XResizeWindow(dpy,win_menu,main_xsize,menuheight);

            hmoving1 = main_ysize-menuheight;

	    resize_move_button1(i,1); /* this triggers the resize of the rest of the windows */
            
	    resize=0;
	  }

	  goto XLoop;
	}

        if (event.xexpose.window==win_message) {
          XDrawImageString(dpy,win_message,gc2,4,font->ascent+2,bottom_message,msglength);
	  goto XLoop;
	}
        if (event.xexpose.window==win_menu){
	  /* horizontal fade */
          XDrawLine(dpy,win_menu,gcgrey2,0,menuheight-1,main_xsize,menuheight-1);
          XDrawLine(dpy,win_menu,gcgrey3,0,menuheight-2,main_xsize,menuheight-2);
          XDrawLine(dpy,win_menu,gcgrey4,0,menuheight-3,main_xsize,menuheight-3);
          /* button surrounding */
          XDrawSegments(dpy,win_menu,gcgrey3,menu_segments1,nb_but_menu*2);
          XDrawSegments(dpy,win_menu,gcgrey4,menu_segments2,nb_but_menu*2);
	  goto XLoop;
        }
        if (event.xexpose.window==win_bottom){
	  /* horizontal fade */
          XDrawLine(dpy,win_bottom,gcgrey2,0,0,main_xsize-right_window_width,0);
          XDrawLine(dpy,win_bottom,gcgrey3,0,1,main_xsize-right_window_width,1);
          XDrawLine(dpy,win_bottom,gcgrey4,0,2,main_xsize-right_window_width,2);
          XDrawSegments(dpy,win_bottom,gcgrey3,bottom_segments1,4);
	  XDrawSegments(dpy,win_bottom,gcgrey4,bottom_segments2,4);
          XDrawSegments(dpy,win_bottom,gcgrey6,bottom_segments3,2*nbottbutt);
          XDrawSegments(dpy,win_bottom,gcgrey7,bottom_segments4,2*nbottbutt);
	  goto XLoop;
	}
        if (event.xexpose.window==button_h_move1) {
          display_moving_button1(moving_button1);
	  goto XLoop;
	}
	if (event.xexpose.window==button_v_move1) {
          display_v_moving_button((vmoving_button&(16+8))==(16+8),button_v_move1);
	  goto XLoop;
	}
        if (event.xexpose.window==button_v_move2) {
          display_v_moving_button((vmoving_button&(16+8))==16,button_v_move2);
	  goto XLoop;
	}
        if (event.xexpose.window==win_work) {
	  display_work();
	  goto XLoop;
	}
        if (event.xexpose.window==win_quickview) {
	  display_view();
	  goto XLoop;
	}
/*
        if (event.xexpose.window==win_clipboard) {
          XDrawLine(dpy,win_clipboard,gc2,0,0,lright,hclip);
	  goto XLoop;
	}
*/
        if (event.xexpose.window==win_toolbar) {
          if (display_toolbar) {
            display_toolbar();
	  }
	  goto XLoop;
	}
        if (event.xexpose.window==win_browse) {
	  display_win_browse();
	  goto XLoop;
	}
        if (event.xexpose.window==win_scroll_browse) {
	  display_win_scroll_browse();
	  goto XLoop;
	}
        /* scan the menu buttons */
        for (i=0;i<nb_but_menu;i++) {
          if (event.xexpose.window==button_menu[i]) {
            XDrawImageString(dpy,button_menu[i],gc2,4,font->ascent+2,but_menu_txt[i],strlen(but_menu_txt[i]));
            if ((current_menu)&&(current_menu==i)) {
	      int m=font->ascent+2+hmenu, n=0;
	      /* XDrawLine(dpy,button_menu[i],gc2,0,hmenu,current_menu_width-1,hmenu); */
	      do {
		XDrawImageString(dpy,button_menu[i],gc2,4,m,ptr_menufiles[i][n], strlen(ptr_menufiles[i][n]));
		m+=hmenu;
		n++;
	      } while (ptr_menufiles[i][n]);
	      XDrawRectangle(dpy,button_menu[i],gc2,0,0,current_menu_width-1,current_menu_height-1);
	    }
	    goto XLoop;
	  }
        }
        /* scan the bottom buttons */
        for (i=0;i<nbottbutt;i++) {
          if (event.xexpose.window==win_bottom_button[i]) {
            XDrawImageString(dpy,win_bottom_button[i],gcbottbutt,(wbottbutt-functextwidth[i])>>1,font->ascent,functext[i],functextlength[i]);
            XDrawImageString(dpy,win_bottom_button[i],gcbottbutt,(wbottbutt-XTextWidth(font,functiontexts[i],strlen(functiontexts[i])))>>1,(1+font->ascent)<<1,functiontexts[i],strlen(functiontexts[i]));
	    goto XLoop;
	  }
        }

	goto XLoop;

      case ButtonPress:
	yclick=event.xbutton.y;
	xclick=event.xbutton.x;
	if (event.xbutton.button==1) {
	  buttonspressed|=1;
	  if (event.xbutton.window==win_quickview) {
	    /* we are drawing a zone on qv */
	    quick_scope.x=event.xbutton.x;
	    quick_scope.y=event.xbutton.y;
	    quick_scope.width=0;
	    quick_scope.height=0;
	    XClearWindow(dpy,win_quickview);
	    display_view();
	    goto XLoop;
	  }
	  if (alt_key &&(event.xbutton.window==win_work)) {
	    /* do nothing, action is on move */
	    goto XLoop;
	  }
	  if (event.xbutton.window==button_menu[0])
	    goto the_end; /* quit */
          for (i=1;i < nb_but_menu;i++)
  	    if (event.xbutton.window==button_menu[i]) {
	      int n=0,width;
	      current_menu_width=menu_widths[i];

	      /* context-sensitive : */
              if (i==1) {
		ptr_menufiles[1]=menufiles2;
		if (file_is_modified)
		  ptr_menufiles[1]=menufiles1;
	      }
	      /* setup the window */
	      current_menu=i;
	      do {
		width = XTextWidth(font, ptr_menufiles[i][n], strlen(ptr_menufiles[i][n])) + 8;
		if (width > current_menu_width)
		  current_menu_width = width;
		n++;
	      } while (ptr_menufiles[i][n]);

	      XRaiseWindow(dpy,button_menu[i]);
	      current_menu_height=hmenu*(n+1)+3;
	      XResizeWindow(dpy,button_menu[i],current_menu_width,current_menu_height);
              goto XLoop;  /* now this really break from the case() ! */
	    }
	  if (event.xbutton.window==button_h_move1){
            display_moving_button1(moving_button1=1);
	    goto XLoop;
	  }
	  if (event.xbutton.window==button_v_move1){
            display_v_moving_button(vmoving_button=8+16,button_v_move1);
	    goto XLoop;
	  }
	  if (event.xbutton.window==button_v_move2){
            display_v_moving_button(vmoving_button=16,button_v_move2);
	    goto XLoop;
	  }

	  if (event.xbutton.window==win_scroll_browse){
	    if (yclick<12)
              scroll_step=-1;
	    else {
	      if (yclick>browse_height-12)
		scroll_step=1;
	      else {
		goto XLoop;
/*
		if (yclick<12)
		  scroll_step=;
		else {                  [Yann at work]
		  if (yclick<12)
		    scroll_step=-1;
		  else {
  		    goto XLoop;  
		  }
		}
*/
	      }
	    }
    
	    mouse_static=1;
	    browse_scroll();
	    scroll_timer_RT.it_value.tv_usec=400000; /* 0.4 second before repeat */
	    signal(SIGALRM,scroll_sighandler);
	    setitimer(ITIMER_REAL,&scroll_timer_RT,NULL);
	    goto XLoop;
	    
	  }

	  if (event.xbutton.window==win_browse){
	    if ((yclick >= 0)&&(yclick < max_browse_menu))
	      click_on_browse();
	    goto XLoop;
	  }
	  goto XLoop;
	} /* button==1 */

	if (event.xbutton.button==2) {
	  buttonspressed|=2;
	  if (alt_key || (event.xbutton.window==win_quickview)) {
	    view_everything();
	    goto XLoop;
	  }

	}
	if (event.xbutton.button==3) {
	  buttonspressed|=4;
	  /* break folded */
	}
        goto XLoop;

      case ButtonRelease:
	if (event.xbutton.button==1) {
	  buttonspressed&=~1;
	  if (event.xbutton.window==win_quickview) {
	    xview=xmqvbbox+(((xclick+event.xbutton.x-lright)*qvscalediv)/(qvscalemul<<1));
	    yview=ymqvbbox+(((yclick+event.xbutton.y-hview)*qvscalediv)/(qvscalemul<<1));

	    /*have we  drawn a zone on qv ? */
	    if ((xclick!=event.xmotion.x)
	      &&(yclick!=event.xmotion.y)) {

	      /* zoom along x or y ? */
	      if ((quick_scope.width*hwork)>(quick_scope.height*wwork)) {
		zoom=((wwork << COORDSHIFT)*qvscalemul)/(quick_scope.width*qvscalediv);
	      }
	      else {
		zoom=((hwork << COORDSHIFT)*qvscalemul)/(quick_scope.height*qvscalediv);
	      }
	      if (zoom<1)
		zoom=1;   /* aaargh ! otherwise, div/0... */
	    }

	    refresh_view();
	    goto XLoop;
	  }

	  if (moving_button1) {
	    resize_move_button1(right_window_width,1);
	    display_moving_button1(moving_button1=0);
	    goto XLoop;
	  }
	  if (vmoving_button) {
	    resize_v_button(1);
	    display_v_moving_button(0,event.xbutton.window);
	    goto XLoop;
	  }
	  for (i=1;i < nb_but_menu;i++)
	    if (event.xbutton.window==button_menu[i]) {
	      XResizeWindow(dpy,button_menu[i],menu_widths[i],hmenu);
	      if (current_menu_line) {
		current_menu_line--;
	        if ((func_array[i]!=NULL)
                  &&(func_array[i][current_menu_line]!=NULL))
		     func_array[i][current_menu_line]();
		current_menu_line=0;
	      }
	      current_menu=0;
	      goto XLoop;
	    }
	}

	if (event.xbutton.button==2) {
	  buttonspressed&=~2;
          goto XLoop;
	}
	if (event.xbutton.button==3) {
	  buttonspressed&=~4;
	  /*goto XLoop; branch filding*/
	}

	/* (?) to my knowlege, the mouse buttons are released once at a time...
           does the X server handle the case otherwise ? */

        goto XLoop;

      case MotionNotify:
	mouse_static=0;
	if (alt_key) {
/* ALT key is being pressed -> something's going on on the work window */
	  if (event.xbutton.window==win_work){ /* we're playing with the working window */
	    if (buttonspressed & 1) {  /* scrolling */ 
	      xclick-=event.xmotion.x;  /* hey ! that's dumb, it's exactly */
	      yclick-=event.xmotion.y;  /* what we get from the mouse ! */
	      scroll(-xclick,-yclick);
	      xclick=event.xmotion.x;
	      yclick=event.xmotion.y;
	      goto XLoop;
	    }
	    if (buttonspressed & 4) {  /* zooming */
	      xclick-=event.xmotion.x;
	      yclick-=event.xmotion.y;
	      if (xclick+yclick<0)
		zoom_out();
	      else
		zoom_in();
	      xclick=event.xmotion.x;
	      yclick=event.xmotion.y;
	      goto XLoop;
	    }
	  }
	}
	if ((buttonspressed==1)&&(event.xbutton.window==win_quickview)) {
	  /* we are drawing a zone on qv */

	  /* some coords swapping (XLib only accepts positive rectangle widths) */
	  if (xclick < event.xmotion.x) {
	    quick_scope.width=event.xmotion.x-xclick;
	    quick_scope.x=xclick;
	  }
	  else {
	    quick_scope.width=xclick-event.xmotion.x;
	    quick_scope.x=event.xmotion.x;
	  }
	  if (yclick < event.xmotion.y) {
	    quick_scope.height=event.xmotion.y-yclick;
	    quick_scope.y=yclick;
	  }
	  else {
	    quick_scope.height=yclick-event.xmotion.y;
	    quick_scope.y=event.xmotion.y;
	  }
  
	  XClearWindow(dpy,win_quickview);
	  display_view();
	  goto XLoop;
	}
        if ((event.xmotion.window==button_h_move1)&&(moving_button1)) {
	  resize_move_button1(right_window_width-(event.xmotion.x-xclick),0);
          goto XLoop;
	}
        if (vmoving_button) {
          if (vmoving_button&8){ /* if v1 */
	    vmoving1+=event.xmotion.y-yclick;
	    vmoving_button|=1+16;
	    resize_v_button(0);
	    goto XLoop;
	  } /* else : v2 */
	  vmoving2+=event.xmotion.y-yclick;
	  vmoving_button|=2+32;
	  resize_v_button(0);
          goto XLoop;
	}

        /* the browse window : */
        if (event.xbutton.window==win_browse) {
	  if ((event.xmotion.y >= 0)&&(event.xmotion.y < max_browse_menu)){
	    int y;
	    current_browse_sel=event.xmotion.y/hmenu;
	    y=current_browse_sel*hmenu;
	    if (y!=current_browse_line){
	      if (current_browse_line>=0) { /* erase the lastest frame */
		XDrawRectangle(dpy,win_browse,gcgrey1,0,current_browse_line,browse_width-1,hmenu+2);
		XDrawRectangle(dpy,win_browse,gcgrey1,1,current_browse_line+1,browse_width-3,hmenu);
		XDrawRectangle(dpy,win_browse,gcgrey1,2,current_browse_line+2,browse_width-5,hmenu-2);
	      }
	      XDrawRectangle(dpy,win_browse,gcgrey6,0,y,browse_width-1,hmenu+2);
	      XDrawRectangle(dpy,win_browse,gcgrey5,1,y+1,browse_width-3,hmenu);
	      XDrawRectangle(dpy,win_browse,gcgrey3,2,y+2,browse_width-5,hmenu-2);
	      current_browse_line=y;
	    }
	  }
	  goto XLoop;
	}
        /* the menu buttons */
        if ((buttonspressed==1)&&(event.xbutton.window==button_menu[current_menu])) {
	  int new_line;
          if ((event.xmotion.y >= 0)&&(event.xmotion.y < (current_menu_height-3))) {
	    new_line=event.xmotion.y / hmenu;
            if (new_line!=current_menu_line){
              if (current_menu_line) {
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey1,
		   1,(current_menu_line*hmenu)-1,current_menu_width-3,hmenu+2);
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey1,
		   2,(current_menu_line*hmenu),current_menu_width-5,hmenu);
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey1,
		   3,(current_menu_line*hmenu)+1,current_menu_width-7,hmenu-2);
	      }
	      current_menu_line=new_line;
              if (current_menu_line) {
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey6,
	           1,(current_menu_line*hmenu)-1,current_menu_width-3,hmenu+2);
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey5,
	           2,(current_menu_line*hmenu),current_menu_width-5,hmenu);
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey3,
	           3,(current_menu_line*hmenu)+1,current_menu_width-7,hmenu-2);
	      }
	    }
	  }
	  /* goto XLoop;  branch folded */
        }

        goto XLoop;

      case KeyPress :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
        if ((car=='q')||(car=='Q'))
          goto the_end;
	switch(keysym) {
          case XK_Page_Up:
	    zoom_out();
	    goto XLoop;
          case XK_Page_Down:
	    zoom_in();
	    goto XLoop;
          case XK_Alt_L:
            alt_key|=1;
	    goto XLoop;
          case XK_Alt_R:
	    alt_key|=2;
	    goto XLoop;
          case XK_Home:
	    view_everything();
	    goto XLoop;
	  case XK_Left:
	    scroll(movestep,0);
	    goto XLoop;
	  case XK_Right:
            scroll(-movestep,0);
            goto XLoop;
	  case XK_Up:
	    scroll(0,-movestep);
	    goto XLoop;
	  case XK_Down:
            scroll(0,movestep);
            goto XLoop;
	}
        goto XLoop;

      case KeyRelease :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
	switch(keysym) {
          case XK_Alt_L:
            alt_key&= ~1;
	    goto XLoop;
          case XK_Alt_R:
            alt_key&= ~2;
	    goto XLoop;
	}        
        goto XLoop;
    }
  } while (1);

the_end:
  exit_and_save_config(0);
  return 0;
}
