/*
<HTML><TITLE>Whygee's dirty Xlib'ed interface (2)</TITLE><BODY BGCOLOR="#FFFFFF" FGCOLOR="#000000">
<PRE>

View.c (C) par Yann Guidon mars 2000

This module is in charge of displaying the data on the working window.

It is included as is from the <A HREF="gnl.c">main file</A> directly (no header file etc...).

What we use from the main file :
 win_work : <FONT COLOR=#0000C0>the window where we display stuffs</FONT>
 hwork : <FONT COLOR=#0000C0>height of the working window</FONT>
 wwork : <FONT COLOR=#0000C0>width of the working window</FONT>
 win_quickview : <FONT COLOR=#0000C0> the window where we display the zoom</FONT>
 hclip : <FONT COLOR=#0000C0>height of the quickview window</FONT>
 lright : <FONT COLOR=#0000C0>width of the quickview window</FONT>

*/

/* internal coordinates system : 1 box 'step' = 256 integer units, so we can place the boxes
at arbitrary coordinates. box "alignment" is therefore performed by clearing the MSBs. */
#define COORDSHIFT 8

/* so, a box can't be smaller than a pixel. the zoom factor can't seriously be below
COORDSHIFT. yet scaling is now a multiplication followed by a right shift,
and there is no real need to modify COORDSHIFT unless you need to display more
boxes than there are pixels on the screen. OTOH you can zoom in but in practice
it is limited to the definition of the boxes, 1/256. */

int
 bboxdisplayed=1,
 coordschanged=1,
 zoom=1, 

/* in the screen coordinates system : */
 quickview_scale,
 xminbbox,
 yminbbox,
 xmaxbbox,
 ymaxbbox,
 
 /* in the internal coordinates system : */
 xview=0,/*<FONT COLOR=#0000C0>coordinates of the center of the display </FONT>*/
 yview=0,
 coord_x1bbox,  /* bounding box of the segments we'll display */
 coord_y1bbox,
 coord_x2bbox,
 coord_y2bbox,
 coord_xmin=0<<COORDSHIFT,
 coord_xmax=5<<COORDSHIFT,
 coord_ymin=0<<COORDSHIFT,
 coord_ymax=10<<COORDSHIFT,
 coord_xdelta,
 coord_ydelta;

XRectangle quick_scope,quick_bbox;

/*
<FONT COLOR=#0000C0> the viewing part : </FONT>
*/

void compute_quickview() {

}

void display_work(void) {
  /* that's where we'll fork... */
  if (coordschanged) {
    coordschanged=0;
     /* recompute the segment lists */

    /* compute the internal coordinates */
    coord_xdelta=coord_xmax-coord_xmin;
    coord_ydelta=coord_ymax-coord_ymin;

    xminbbox=(wwork>>1)+(((coord_xmin-xview)*zoom)>>COORDSHIFT);
    yminbbox=(hwork>>1)+(((coord_ymin-yview)*zoom)>>COORDSHIFT);
    xmaxbbox=(coord_xdelta*zoom)>>COORDSHIFT;
    ymaxbbox=(coord_ydelta*zoom)>>COORDSHIFT;

    /* check if we have to display the bbox */
    if (((xmaxbbox+xminbbox)<0)
      ||((ymaxbbox+yminbbox)<0)
       ||(xminbbox>wwork)
       ||(yminbbox>hwork)){
      bboxdisplayed=0;
      return;
    }
    bboxdisplayed=1;

    /* ok but now, we still have to clip... */

    if (xminbbox<0) {
      xmaxbbox+=xminbbox;
      xminbbox=0;
    }

    if (yminbbox<0) {
      ymaxbbox+=yminbbox;
      yminbbox=0;
    }

    if ((xmaxbbox+xminbbox)>wwork) {
      xmaxbbox=wwork-xminbbox;
    }

    if ((ymaxbbox+yminbbox)>hwork) {
      ymaxbbox=hwork-yminbbox;
    }

    /*
         now that we have the displayed coordinates,
	 we have to translate them to the internal
	 coordinates system in order to clip them
	 with the scanning loop.
    compute :
 coord_x1bbox,
 coord_y1bbox,
 coord_x2bbox,
 coord_y2bbox,
    */

    /* recompute the quickview coordinates too !*/
    compute_quickview();
  }

  if (bboxdisplayed) {
    XFillRectangle(dpy,win_work,gcgrey1,xminbbox,yminbbox,xmaxbbox,ymaxbbox);
  }
}

void display_view(void) {
  /*  XDrawLine(dpy,win_quickview,gc2,0,0,lright,hview); */
}

void refresh_view(){
  coordschanged=1;
  XClearWindow(dpy,win_quickview);
  XClearWindow(dpy,win_work);
  display_view(); /* win_quickview is simpler to draw so it should be displayed first  */
  display_work(); /* that's the heavy part */
}

void view_everything(void) {
  /* find max coords */
  coord_xdelta=coord_xmax-coord_xmin;
  coord_ydelta=coord_ymax-coord_ymin;
  /* adjust zoom with the height of the work screen
    formula : hwork = (coord_ydelta*zoom)>>COORDSHIFT so : */
  zoom=(hwork<<(COORDSHIFT+5))/(coord_ydelta+(coord_ydelta<<5));
  /* note that it is also adjusted with a ratio of 32/33... */

  /* find the middle of the view */
  xview=coord_xmin+(coord_xdelta>>1);
  yview=coord_ymin+(coord_ydelta>>1);
  /* compute the zoom */
  sprintf(GNLMessage,"zoom : %d, xview : %d, yview : %d",zoom,xview,yview);
  change_message(GNLMessage);
  refresh_view();  
}

void zoom_out() {
  if (zoom>1) { /* avoid blinking... */
    zoom=(zoom*7)>>3; /* 7/8=.875 */
    if (zoom<1)
      zoom=1;
    sprintf(GNLMessage,"zoom : %d",zoom);
    change_message(GNLMessage);
    refresh_view();
  }
}

void zoom_in() {
  if (zoom<100000) { /* avoid blinking... */
    zoom=((zoom*9)>>3)+1; /* 9/8=1.125  */
    if (zoom>100000)
      zoom=100000;
    sprintf(GNLMessage,"zoom : %d",zoom);
    change_message(GNLMessage);
    refresh_view();
  }
}

void scroll(int steph, int stepv) {
  yview-=(hwork*stepv)>>COORDSHIFT;
  xview-=(hwork*steph)>>COORDSHIFT;
  sprintf(GNLMessage,"xview : %d, yview : %d",xview,yview);
  change_message(GNLMessage);
  refresh_view();
}

void resize_view(void) {
  XMoveResizeWindow(dpy,win_quickview,xright,menuheight+vmoving2+10,lright,hview);
  compute_quickview();
}

void resize_work(void){
  coordschanged=1;
  hwork=main_ysize-hbottom-menuheight;
  wwork=main_xsize-right_window_width;
  XMoveResizeWindow(dpy,win_work,0,menuheight,wwork,hwork);
}
