/*
<HTML><TITLE>Whygee's dirty Xlib'ed interface</TITLE><BODY BGCOLOR="#FFFFFF" FGCOLOR="#000000">
<PRE>

 (C) mars 2000 by Yann Guidon, placed under GPL

Uses <A HREF="ygtk.c">ygtk.c</A>, includes <A HREF="view1.c">view1.c</A>, Xlib, events, etc...

One day, it will import and export VHDL, PostScript, HTML, C, Pascal, ADA,
and assembly langage from any CPU etc...

 */

#include "ygtk.c"
#include <X11/keysym.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>

/*<FONT COLOR=#0000C0> number of function buttons </FONT>*/
#define nbottbutt 12
/*<FONT COLOR=#0000C0> minimal width or height of a subwindow </FONT>*/
#define WINMINSIZE 30
/*<FONT COLOR=#0000C0> minimal size of the main window </FONT>*/
#define min_xsize 300
#define min_ysize 200

/*<FONT COLOR=#0000C0> X11 stuffs </FONT>*/

/*<FONT COLOR=#0000C0> main window </FONT>*/

int i,j,k,l,m, /*<FONT COLOR=#0000C0> some temporary variables </FONT>*/
 alt_key=0, /*<FONT COLOR=#0000C0> 1 if at least one ALT key is pressed </FONT>*/
 resize=1, /*<FONT COLOR=#0000C0> triggers the recomputation of all coordinates, and display </FONT>*/
 main_xsize, /*<FONT COLOR=#0000C0> size of the main window </FONT>*/
 main_ysize,
 main_xpos, /*<FONT COLOR=#0000C0> position of the main window </FONT>*/
 main_ypos,
 main_xsize2,  /*<FONT COLOR=#0000C0> temporary size of the main window </FONT>*/
 main_ysize2,
 movestep=100, /*<FONT COLOR=#0000C0> keyborad scrolling unit </FONT>*/ 
 hwork, /*<FONT COLOR=#0000C0> height of the working window </FONT>*/
 wwork,/*<FONT COLOR=#0000C0> width of the working window </FONT>*/
 xright,/*<FONT COLOR=#0000C0> x coord of the right windows (clip,view,tool) </FONT>*/
 lright, /*<FONT COLOR=#0000C0> actual width of the right windows </FONT>*/
 hclip, /*<FONT COLOR=#0000C0> height of the clipboard window </FONT>*/
 htoolbar, /*<FONT COLOR=#0000C0> height of the toolbar window </FONT>*/
 hview, /*<FONT COLOR=#0000C0> height of the quickview window </FONT>*/
 htools, /*<FONT COLOR=#0000C0> height of the tool window </FONT>*/
 hbottom,  /*<FONT COLOR=#0000C0> height of the bottom bar </FONT>*/
 ybottom_button, /*<FONT COLOR=#0000C0> y start of the (function) bottom windows </FONT>*/
 hbottom_button, /*<FONT COLOR=#0000C0> height thereof </FONT>*/
 wbottbutt, /*<FONT COLOR=#0000C0> width of the function buttons </FONT>*/
 hmenu, /*<FONT COLOR=#0000C0> height of the menu buttons </FONT>*/
 menuheight, /*<FONT COLOR=#0000C0> height of the menu bar </FONT>*/
 right_window_width=70, /*<FONT COLOR=#0000C0> width of the right window </FONT>*/
 top_height=40,
 moving_button1=0, /*<FONT COLOR=#0000C0> flag saying that we're moving the vertical bar </FONT>*/
 vmoving_button=0,
 /*<FONT COLOR=#0000C0> bit 0: vmoving1 has changed,
    bit 1: vmoving2 has changed,
    bit 3: v1 is on focus if 1, v2 otherwise
    bit 4: moving one vertical bar,
    bit 5: vmoving1 has changed (sticky),
    bit 6: vmoving2 has changed (sticky) </FONT>*/
 hmoving1,/*<FONT COLOR=#0000C0> height of the vertical moving bar </FONT>*/
 vmoving1=50, /*<FONT COLOR=#0000C0> Y of the high horizontal bar </FONT>*/
 vmoving2=100, /*<FONT COLOR=#0000C0> Y of the second (low) horizontal bar </FONT>*/
 xclick, /* coordinates of the point where we have clicked, */
 yclick, /* this makes the interface run more smoothly for the user */
 buttonspressed=0;


#define nb_but_menu 6
char *but_menu_txt[nb_but_menu]={
 "Quit",
 "Files",
 "Sheets",
 "Configure",
 "Tools", 
 "Help",
};

char *functiontexts[]={
  "Unselect",
  "Save",
  "Load",
  "Copy",
  "Paste",
  "Del",
  "Move",
  "Undo",
  "Redo",
  "Viewsel",
  "ViewAll",
  "ZoomIn",
  "Zoomout",
};

/*<FONT COLOR=#0000C0> window hierarchy : </FONT>*/
Window
 win_main,
  win_menu,
   button_menu[nb_but_menu],
   win_popup,
  win_work,
  win_right,
   win_clipboard,
   win_toolbar,
   win_quickview,
  win_bottom,
   win_message,
   win_status,
   win_bottom_button[nbottbutt],
 button_h_move1,
 button_v_move1,
 button_v_move2
;

char functext[nbottbutt][3]; /*<FONT COLOR=#0000C0> function key name </FONT>*/
int functextwidth[nbottbutt]; /*<FONT COLOR=#0000C0> width (pixel) thereof </FONT>*/
int functextlength[nbottbutt]; /*<FONT COLOR=#0000C0> length thereof </FONT>*/

XSegment bottom_segments1[4],bottom_segments2[4], /*<FONT COLOR=#0000C0> segments displayed on the bottom bar</FONT>*/
  bottom_segments3[2*nbottbutt],bottom_segments4[2*nbottbutt];
XSegment menu_segments1[nb_but_menu*2],
  menu_segments2[nb_but_menu*2]; /*<FONT COLOR=#0000C0> segments for the menu bar (underlines the buttons) </FONT>*/
GC gc_main,gc_menu, gc1,gc2,gcbottbutt, gcwork,/*<FONT COLOR=#0000C0> some graphic contexts... </FONT>*/
 gcgrey1,gcgrey2,gcgrey3,gcgrey4,gcgrey5,gcgrey6,gcgrey7;
Pixmap pixmap;
#define grey_width 8
#define grey_height 4
static char background_tile[grey_height]= { 0x00, 0x00, 0x22, 0x44 };
XEvent event;
/*<FONT COLOR=#0000C0> key code conversion </FONT>*/
KeySym keysym;
char car;

/*<FONT COLOR=#0000C0> for the message window : </FONT>*/
int msglength=54;
char GNLMessage[]="GNL is NOT a Langage... (C) march 2000 by Yann Guidon";
char *bottom_message=GNLMessage;

/*<FONT COLOR=#0000C0> to save and restore the window position and size </FONT>*/
FILE *geom_file;
char geom_file_name[]=".gnl_geometry";

/*<FONT COLOR=#0000C0> for the unuseful XGetGeometry results</FONT>*/
int dumb;
Window wdumb;

void change_message(char *c){
  bottom_message=c;
  msglength=strlen(c);
  XClearWindow(dpy,win_message);
  XDrawImageString(dpy,win_message,gc2,4,font->ascent+2,c,msglength);
}


#include "view1.c"



void resize_clipboard(void) {
  XMoveResizeWindow(dpy,win_clipboard,xright,menuheight,lright,hclip);
}

void resize_toolbar(void) {
  XMoveResizeWindow(dpy,win_toolbar,xright,menuheight+vmoving1+10,lright,htoolbar);
}

void resize_bottom_bar(void) {
  int l,k,j,i=(main_xsize-right_window_width)-8;
  bottom_segments1[0].x1=bottom_segments1[2].x2=bottom_segments1[3].x1=bottom_segments1[3].x2=5;
  bottom_segments1[0].y1=bottom_segments1[0].y2=bottom_segments1[1].y1=bottom_segments1[3].y2=7;     
  bottom_segments1[0].x2=bottom_segments1[1].x1=bottom_segments1[1].x2=bottom_segments1[2].x1=5+i+1;  
  bottom_segments1[1].y2=bottom_segments1[2].y1=bottom_segments1[2].y2=bottom_segments1[3].y1=7+hmenu+1;
  bottom_segments2[0].x1=bottom_segments2[2].x2=bottom_segments2[3].x1=bottom_segments2[3].x2=4;
  bottom_segments2[0].y1=bottom_segments2[0].y2=bottom_segments2[1].y1=bottom_segments2[3].y2=6;     
  bottom_segments2[0].x2=bottom_segments2[1].x1=bottom_segments2[1].x2=bottom_segments2[2].x1=4+i+2+1;  
  bottom_segments2[1].y2=bottom_segments2[2].y1=bottom_segments2[2].y2=bottom_segments2[3].y1=6+hmenu+2+1;

  XMoveResizeWindow(dpy,win_bottom,0,main_ysize-hbottom,main_xsize-right_window_width,hbottom);
  XMoveResizeWindow(dpy,win_message,6,8,(main_xsize-right_window_width)-8,hmenu);

  j=3+hbottom_button+3;
  wbottbutt=(main_xsize-right_window_width-j-(4*nbottbutt));
  if (wbottbutt>(nbottbutt*5)){
    wbottbutt/=nbottbutt;
    k=0; l=1;
    for (i=0;i< nbottbutt;i++) {
      bottom_segments3[k].x1=bottom_segments3[k].x2=j++;
      bottom_segments4[l].x1=bottom_segments4[l].x2=j++;
      bottom_segments4[k].x1=bottom_segments4[k].x2=j++;
      bottom_segments3[l].x1=bottom_segments3[l].x2=j++;
      bottom_segments3[k].y1=bottom_segments3[l].y1=ybottom_button-2;
      bottom_segments4[l].y1=bottom_segments4[k].y1=ybottom_button-3;
      bottom_segments3[k].y2=bottom_segments3[l].y2=
	bottom_segments4[l].y2=bottom_segments4[k].y2=hbottom;
      k+=2;
      l+=2;
      XMoveResizeWindow(dpy,win_bottom_button[i],j,ybottom_button,wbottbutt,hbottom_button);
      j+=wbottbutt;
    }
  }
}

void display_v_moving_button (int moving,Window win) {
  int h=right_window_width-10;
  if (moving) {
    XDrawLine(dpy,win,gcgrey2,2,0,h,0);
    XDrawLine(dpy,win,gcgrey4,4,1,h,1);
    XDrawLine(dpy,win,gcgrey5,6,2,h,2);
    XDrawLine(dpy,win,gcgrey6,8,3,h,3);
    XDrawLine(dpy,win,gcgrey7,10,4,h,4);
    XDrawLine(dpy,win,gcgrey7,10,5,h,5);
    XDrawLine(dpy,win,gcgrey6,8,6,h,6);
    XDrawLine(dpy,win,gcgrey5,6,7,h,7);
    XDrawLine(dpy,win,gcgrey4,4,8,h,8);
    XDrawLine(dpy,win,gcgrey2,2,9,h,9);
  } else {
    XDrawLine(dpy,win,gcgrey2,2,0,h,0);
    XDrawLine(dpy,win,gcgrey3,4,1,h,1);
    XDrawLine(dpy,win,gcgrey3,6,2,h,2);
    XDrawLine(dpy,win,gcgrey4,8,3,h,3);
    XDrawLine(dpy,win,gcgrey5,10,4,h,4);
    XDrawLine(dpy,win,gcgrey5,10,5,h,5);
    XDrawLine(dpy,win,gcgrey4,8,6,h,6);
    XDrawLine(dpy,win,gcgrey3,6,7,h,7);
    XDrawLine(dpy,win,gcgrey3,4,8,h,8);
    XDrawLine(dpy,win,gcgrey2,2,9,h,9);
  }
}

void resize_v_button(int redisplay_other_windows){
  int i,j;

  /*<FONT COLOR=#0000C0> problem between v1 and v2 </FONT>*/
  i=vmoving2-WINMINSIZE;
  if (vmoving1>i) {
    /*<FONT COLOR=#0000C0> who pushes who ? </FONT>*/
    if (vmoving_button&8) { /*<FONT COLOR=#0000C0> v1 in focus </FONT>*/
      vmoving_button|=2+32;
      vmoving2=vmoving1+WINMINSIZE;
    }
    else {
      vmoving_button|=1+16;
      vmoving1=i;
    }
  }

  /*<FONT COLOR=#0000C0> lower bound for v2 </FONT>*/
  if (vmoving2 < WINMINSIZE*2) {
  /*<FONT COLOR=#0000C0> push v1 </FONT>*/
    vmoving_button|=1+2+16+32;
    vmoving1=WINMINSIZE; 
    vmoving2=WINMINSIZE*2;
  } else {
    /*<FONT COLOR=#0000C0> lower bound for v1 </FONT>*/
    if (vmoving1 < WINMINSIZE) {
      vmoving_button|=1+16;
      vmoving1=WINMINSIZE; 
    }
  }

  /*<FONT COLOR=#0000C0> upper bound for v1 </FONT>*/
  i=(main_ysize-menuheight)-(WINMINSIZE*2);
  j=(main_ysize-menuheight)-WINMINSIZE;
  if (vmoving1 >i) {
  /*<FONT COLOR=#0000C0> push v2 </FONT>*/
    vmoving_button|=1+2+16+32;
    vmoving1=i; 
    vmoving2=j; 
  } else {
    /*<FONT COLOR=#0000C0> upper bound for v2 </FONT>*/
    if (vmoving2 >j) {
      vmoving_button|=2+32;
      vmoving2=j; 
    }
  }

  if (vmoving_button&1)
    XMoveResizeWindow(dpy,button_v_move1,main_xsize-right_window_width+10,menuheight+vmoving1,right_window_width-10,10);
  if (vmoving_button&2)
    XMoveResizeWindow(dpy,button_v_move2,main_xsize-right_window_width+10,menuheight+vmoving2,right_window_width-10,10);
  vmoving_button&= ~3;

  if (redisplay_other_windows) {
    if (vmoving_button&16) {
      hclip=vmoving1;
      resize_clipboard();
    }
    if (vmoving_button&48) { /*<FONT COLOR=#0000C0> at least v1 or v2 has changed </FONT>*/
      htoolbar=vmoving2-vmoving1-10;
      resize_toolbar();
    }
    if (vmoving_button&32) {
      hview=main_ysize-menuheight-vmoving2-10;
      resize_view();
    }
   
    vmoving_button=0;
  }
}


void display_moving_button1 (int moving) {
  int h=main_ysize-menuheight;
  if (moving) {
    XDrawLine(dpy,button_h_move1,gcgrey2,0,2,0,h-hbottom+1);
    XDrawLine(dpy,button_h_move1,gcgrey4,1,4,1,h-hbottom+3);
    XDrawLine(dpy,button_h_move1,gcgrey5,2,6,2,h);
    XDrawLine(dpy,button_h_move1,gcgrey6,3,8,3,h);
    XDrawLine(dpy,button_h_move1,gcgrey7,4,10,4,h);
    XDrawLine(dpy,button_h_move1,gcgrey7,5,10,5,h);
    XDrawLine(dpy,button_h_move1,gcgrey6,6,8,6,h);
    XDrawLine(dpy,button_h_move1,gcgrey5,7,6,7,h);
    XDrawLine(dpy,button_h_move1,gcgrey4,8,4,8,h);
    XDrawLine(dpy,button_h_move1,gcgrey2,9,2,9,h);
  } else {
    XDrawLine(dpy,button_h_move1,gcgrey2,0,2,0,h-hbottom);
    XDrawLine(dpy,button_h_move1,gcgrey3,1,4,1,h-hbottom+1);
    XDrawLine(dpy,button_h_move1,gcgrey3,2,6,2,h-hbottom+1);
    XDrawLine(dpy,button_h_move1,gcgrey4,3,8,3,h-hbottom+2);
    XDrawLine(dpy,button_h_move1,gcgrey5,4,10,4,h);
    XDrawLine(dpy,button_h_move1,gcgrey5,5,10,5,h);
    XDrawLine(dpy,button_h_move1,gcgrey4,6,8,6,h);
    XDrawLine(dpy,button_h_move1,gcgrey3,7,6,7,h);
    XDrawLine(dpy,button_h_move1,gcgrey3,8,4,8,h);
    XDrawLine(dpy,button_h_move1,gcgrey2,9,2,9,h);
  }
}

void resize_move_button1(int new_width, int redisplay_other_windows){
  if (new_width < WINMINSIZE) {
    right_window_width=WINMINSIZE;
  } else {
    if (main_xsize-new_width < WINMINSIZE) {
      right_window_width=main_xsize-WINMINSIZE;
    } else {
      right_window_width=new_width;
    }
  }
  xright=main_xsize-right_window_width+10;
  lright=right_window_width-10;

  XMoveResizeWindow(dpy,button_h_move1,main_xsize-right_window_width,menuheight,10,hmoving1);
  if (redisplay_other_windows) {
    vmoving_button=1+2+16+32; /*<FONT COLOR=#0000C0> forces redisplay </FONT>*/
    resize_v_button(1);
    resize_bottom_bar();
    resize_work();
  }
}

int read_int(void){
  int value=0;
  int c=fgetc(geom_file);
  /*<FONT COLOR=#0000C0> remove spaces : </FONT>*/
  while ((c!=EOF)&&((c<'0')||(c>'9')))
    c=fgetc(geom_file);
  if (c==EOF)
    return 0;
  /*<FONT COLOR=#0000C0> read decimal number without much overflow checkings... </FONT>*/
  while ((c!=EOF)&&((c>='0')&&(c<='9'))) {
    value=(value*10)+(c-'0');
    c=fgetc(geom_file);
  }
  ungetc(c,geom_file);
  return value;
}

void exit_and_save_config(int exit_code){
  /*<FONT COLOR=#0000C0> collect here the X geometry of the window and save it to a file </FONT>*/
  geom_file=fopen(geom_file_name,"wb");
  if ((geom_file!=NULL)&&(resize==0)) {
    XGetGeometry(dpy,win_main,&wdumb,&main_xpos,&main_ypos,&main_xsize,&main_ysize,&dumb,&dumb);
    fprintf(geom_file,"%d %d %d %d %d %d %d\n",main_xsize,main_ysize,main_xpos,main_ypos,right_window_width,vmoving1,vmoving2);
    fclose(geom_file);
  }
  close_window(&win_main);
  exitX();
  exit(exit_code);
}

/*<FONT COLOR=#0000C0> fatal signals handler : </FONT>*/
void sighandler_general(int signum){
  fprintf(stderr,"\nexit on signal %d\n",signum);
  exit_and_save_config(signum);
}

int main(int argc, char **argv)
{

  /*<FONT COLOR=#0000C0> signals are caught to prevent data loss... </FONT>*/
  signal(SIGSEGV, sighandler_general);  /*<FONT COLOR=#0000C0> "count=*(int *)NULL;" </FONT>*/
  signal(SIGTERM, sighandler_general);  /*<FONT COLOR=#0000C0> Ctrl+C </FONT>*/
  signal(SIGINT, sighandler_general);
  signal(SIGBUS, sighandler_general);
  signal(SIGHUP, sighandler_general);

 /*<FONT COLOR=#0000C0> signal(SIGALRM, sig_handler_ALRM);
  setitimer(ITIMER_REAL,&mytimer_RT,NULL); </FONT>*/

  /*<FONT COLOR=#0000C0> X11 </FONT>*/
  init_X();

  /*<FONT COLOR=#0000C0> read the init file here, remember the window positions... </FONT>*/
  geom_file=fopen(geom_file_name,"rb");
  if (geom_file!=NULL) {
    if (!(main_xsize=read_int())) goto default_size;
    if (!(main_ysize=read_int())) goto default_size;
    if (!(main_xpos=read_int())) goto default_size;
    if (!(main_ypos=read_int())) goto default_size;
    right_window_width=read_int();
    vmoving1=read_int();
    vmoving2=read_int();
  }
  else {
default_size:
    XGetGeometry(dpy,RootWindow(dpy,DefaultScreen(dpy)),
      &wdumb,&dumb,&dumb,&main_xsize,&main_ysize,&dumb,&dumb);
    main_xpos=50;
    main_ypos=50;
    main_xsize=main_xsize-100;
    main_ysize=main_ysize-100;
  }


  /*<FONT COLOR=#0000C0> create all the windows : </FONT>*/
  open_window(&win_main,main_xpos,main_ypos,main_xsize,main_ysize,min_xsize,min_ysize,&gc_main,dim_grey,light_grey,"GNL",SHOWN);

  xgcv.foreground = doDefineColor (light_grey);
  gcgrey1 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.foreground = doDefineColor (grey);
  gcgrey2 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.foreground = doDefineColor (grey55);
  gcgrey3 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.foreground = doDefineColor (grey40);
  gcgrey4 = XCreateGC (dpy, win_main, GCForeground , &xgcv);

  xgcv.foreground = doDefineColor (grey34);
  gcgrey5 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.background = xgcv.foreground;

  xgcv.foreground = doDefineColor (grey25);
  gcgrey6 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.foreground = doDefineColor (grey18);
  gcgrey7 = XCreateGC (dpy, win_main, GCForeground , &xgcv);

  xgcv.foreground = doDefineColor (black);
  /*<FONT COLOR=#0000C0>  xgcv.background = doDefineColor (grey34); </FONT>*/
  gcbottbutt = XCreateGC (dpy, win_main, GCForeground|GCBackground|GCFont , &xgcv);

  xgcv.background = doDefineColor (light_grey);
  gc2 = XCreateGC (dpy, win_main,GCForeground | GCBackground | GCFont
           | GCLineWidth | GCLineStyle, &xgcv);

  hmenu = font->ascent + font->descent + 3;
  menuheight = 4 + hmenu+ 10 ; 
  hmoving1 = main_ysize-menuheight;

  /*<FONT COLOR=#0000C0> top bar : </FONT>*/
  open_daughter_window(&win_menu, win_main, 0,0, main_xsize, menuheight, &gc_menu, dim_grey,grey34,0);
  j=4; k=0;
  for (i=0;i< nb_but_menu;i++) {
    l=7+XTextWidth(font,but_menu_txt[i],strlen(but_menu_txt[i]));
    open_daughter_window (&button_menu[i], win_menu, j, 4,l, hmenu, NULL, black, light_grey, 0);

    /*<FONT COLOR=#0000C0> underlines the buttons : </FONT>*/
    menu_segments1[k+0].x1=menu_segments2[k+0].x1=j;
    j+=l;
    menu_segments1[k+0].x2=menu_segments1[k+1].x1=menu_segments1[k+1].x2=j;
    menu_segments2[k+0].x2=menu_segments2[k+1].x1=menu_segments2[k+1].x2=j+1;
    menu_segments1[k+0].y1=menu_segments1[k+0].y2=menu_segments1[k+1].y1=4+hmenu;
    menu_segments2[k+0].y1=menu_segments2[k+0].y2=menu_segments2[k+1].y1=4+hmenu+1;
    menu_segments1[k+1].y2=4;
    menu_segments2[k+1].y2=4+1;
    j+=6;
    k+=2;
  }

  /*<FONT COLOR=#0000C0> add the other windows here...  </FONT>*/
  ybottom_button=8+hmenu+6; /*<FONT COLOR=#0000C0> y start of the windows </FONT>*/
  hbottom_button=font->ascent+3+font->ascent+font->descent;
  hbottom=ybottom_button+hbottom_button+3;
  wbottbutt=(main_xsize-right_window_width-3-hbottom_button-3-(4*nbottbutt))/nbottbutt;

  hwork=main_ysize-hbottom-menuheight;
  wwork=main_xsize-right_window_width;

  /* this is an online rewrite of open_daughter_window that includes a background pixmap */
  xgcv.foreground = doDefineColor(white);
  xgcv.background = xswa.background_pixel =  doDefineColor(light_grey);
  win_work = XCreateWindow (dpy, win_main, 0, menuheight, wwork,
     hwork, 0,XDefaultDepthOfScreen(screen), InputOutput,
     XDefaultVisualOfScreen(screen),CWEventMask | CWBackPixel | CWBackPixmap, &xswa);
  XSetNormalHints (dpy, win_work, &xsh);
  gcwork = XCreateGC (dpy, win_work,GCForeground | GCBackground, &xgcv);
  pixmap =  XCreatePixmapFromBitmapData(dpy,win_work, background_tile,
    grey_width, grey_height, xgcv.foreground, xgcv.background,
    DefaultDepth(dpy, 0));  /*<FONT COLOR=#F00000>possible problem here </FONT>*/
  XSetWindowBackgroundPixmap(dpy,win_work,pixmap);
  XMapWindow (dpy, win_work);

  xright=main_xsize-right_window_width+10;
  lright=right_window_width-10;
  hclip=vmoving1;
  open_daughter_window(&win_clipboard,win_main,xright,menuheight,lright,hclip,NULL,black,light_grey,0);
  htoolbar=vmoving2-vmoving1-10;
  open_daughter_window(&win_toolbar,win_main,xright,menuheight+vmoving1+10,lright,htoolbar,NULL,black,light_grey,0);
  hview=main_ysize-menuheight-vmoving2-10;
  open_daughter_window(&win_quickview,win_main,xright,menuheight+vmoving2+10,lright,hview,NULL,black,light_grey,0); 

  open_daughter_window(&win_bottom, win_main, 0,main_ysize-hbottom,main_xsize-right_window_width ,hbottom,NULL, dim_grey,grey34,0);
  open_daughter_window (&win_message,win_bottom,6,8,(main_xsize-right_window_width)-9,hmenu,NULL, black, light_grey, 0 );
  open_daughter_window (&win_status,win_bottom,3,ybottom_button,hbottom_button,hbottom_button,NULL, dim_grey,red,0);

  j=3+hbottom_button+3+4; /*<FONT COLOR=#0000C0> cf above </FONT>*/
  for (i=0;i< nbottbutt;i++) {
    open_daughter_window(&win_bottom_button[i],win_bottom,j,ybottom_button,wbottbutt,hbottom_button,NULL, dim_grey,grey34,0);
    j+=wbottbutt+4;
    functext[i][0]='F';
    if (i<9) {/*<FONT COLOR=#0000C0> one digit </FONT>*/
      functextlength[i]=2;
      functext[i][1]=i+'1';
      functextwidth[i]=XTextWidth(font,functext[i],2);
    } else { /*<FONT COLOR=#0000C0> two digits </FONT>*/
      functextlength[i]=3;
      functext[i][1]=((i+1)/10)+'0';
      functext[i][2]=((i+1)%10)+'0';
      functextwidth[i]=XTextWidth(font,functext[i],3);
    }
  }

  /*<FONT COLOR=#0000C0> resize window 3: </FONT>*/
  open_daughter_window(&button_v_move2, win_main, main_xsize-right_window_width+10,menuheight+vmoving2,right_window_width-10, 10,NULL, dim_grey,grey34,0);
  /*<FONT COLOR=#0000C0> resize window 2: </FONT>*/
  open_daughter_window(&button_v_move1, win_main, main_xsize-right_window_width+10,menuheight+vmoving1,right_window_width-10, 10,NULL, dim_grey,grey34,0);
  /*<FONT COLOR=#0000C0> resize window 1: </FONT>*/
  open_daughter_window(&button_h_move1, win_main, main_xsize-right_window_width,menuheight, 10,hmoving1,NULL, dim_grey,grey34,0);

  /*  view_everything();*/

  /*<FONT COLOR=#0000C0> main loop </FONT>*/  
  do {
    XNextEvent(dpy,&event);
    switch(event.type) {

      case ResizeRequest:
        if (event.xresizerequest.window!=win_main)
          break;
resize_main:
        xswa.event_mask&= ~ResizeRedirectMask;
        XChangeWindowAttributes(dpy,win_main,CWEventMask, &xswa);
        XSync(dpy,0); /*<FONT COLOR=#C00000> very important, otherwise we loop endlessly ! </FONT>*/

        XResizeWindow(dpy, win_main,event.xresizerequest.width,event.xresizerequest.height);

        XSync(dpy,0); /*<FONT COLOR=#C00000> very important, otherwise we loop endlessly ! </FONT>*/

        xswa.event_mask|= ResizeRedirectMask;
        XChangeWindowAttributes(dpy,win_main,CWEventMask, &xswa);
        resize=1;
        goto redisplay;

      case Expose:
	if (event.xexpose.count|moving_button1|vmoving_button)
	  break;

        if (event.xexpose.window==win_main){
redisplay:
          XGetGeometry(dpy,win_main,&wdumb,&dumb,&dumb,&main_xsize2,&main_ysize2,&dumb,&dumb);

          i=0;
          if (main_xsize2< min_xsize) {
            main_xsize2=min_xsize;
            i=1;
	  } 
	  if (main_ysize2< min_ysize) {
            main_ysize2=min_ysize;
            i=1;
          } 
          if (i) {
	    printf("main window undersize detected, re-resize manually\n");
	    event.xresizerequest.width=main_xsize2;
	    event.xresizerequest.height=main_ysize2;
	    goto resize_main;
	  }


          if ((resize)||(main_xsize!=main_xsize2)||(main_ysize!=main_ysize2)) {
	    /*<FONT COLOR=#0000C0> recompute the coordinates ! </FONT>*/

            /*<FONT COLOR=#0000C0> this depends on the old coordinates : </FONT>*/
	    i=(right_window_width*main_xsize2)/main_xsize;
                  /*<FONT COLOR=#0000C0> protected from /0 par min_xsize </FONT>*/
            vmoving1=(vmoving1*(main_ysize2-menuheight))/(main_ysize-menuheight);
            vmoving2=(vmoving2*(main_ysize2-menuheight))/(main_ysize-menuheight);

	    /*<FONT COLOR=#0000C0> "validate" the new coordinates </FONT>*/
            main_xsize=main_xsize2;
	    main_ysize=main_ysize2;

	    /*<FONT COLOR=#0000C0> this depends on the new coordinates : </FONT>*/
            XResizeWindow(dpy,win_menu,main_xsize,menuheight);

            hmoving1 = main_ysize-menuheight;

	    resize_move_button1(i,1); /*<FONT COLOR=#0000C0> this triggers the resize of the rest of the windows </FONT>*/
            
	    resize=0;
	  }

	  break;
	}

        if (event.xexpose.window==win_message) {
          XDrawImageString(dpy,win_message,gc2,4,font->ascent+2,bottom_message,msglength);
	  break;
	}
        if (event.xexpose.window==win_menu){
	  /*<FONT COLOR=#0000C0> horizontal fade </FONT>*/
          XDrawLine(dpy,win_menu,gcgrey2,0,menuheight-1,main_xsize,menuheight-1);
          XDrawLine(dpy,win_menu,gcgrey3,0,menuheight-2,main_xsize,menuheight-2);
          XDrawLine(dpy,win_menu,gcgrey4,0,menuheight-3,main_xsize,menuheight-3);
          /*<FONT COLOR=#0000C0> button surrounding </FONT>*/
          XDrawSegments(dpy,win_menu,gcgrey3,menu_segments1,nb_but_menu*2);
          XDrawSegments(dpy,win_menu,gcgrey4,menu_segments2,nb_but_menu*2);
	  break;
        }
        if (event.xexpose.window==win_bottom){
	  /*<FONT COLOR=#0000C0> horizontal fade </FONT>*/
          XDrawLine(dpy,win_bottom,gcgrey2,0,0,main_xsize-right_window_width,0);
          XDrawLine(dpy,win_bottom,gcgrey3,0,1,main_xsize-right_window_width,1);
          XDrawLine(dpy,win_bottom,gcgrey4,0,2,main_xsize-right_window_width,2);
          XDrawSegments(dpy,win_bottom,gcgrey3,bottom_segments1,4);
	  XDrawSegments(dpy,win_bottom,gcgrey4,bottom_segments2,4);
          XDrawSegments(dpy,win_bottom,gcgrey6,bottom_segments3,2*nbottbutt);
          XDrawSegments(dpy,win_bottom,gcgrey7,bottom_segments4,2*nbottbutt);
	  break;
	}
        if (event.xexpose.window==button_h_move1) {
          display_moving_button1(moving_button1);
	  break;
	}
	if (event.xexpose.window==button_v_move1) {
          display_v_moving_button((vmoving_button&(16+8))==16+8,button_v_move1);
	  break;
	}
        if (event.xexpose.window==button_v_move2) {
          display_v_moving_button((vmoving_button&(16+8))==16,button_v_move2);
	  break;
	}
        if (event.xexpose.window==win_work) {
	  display_work();
	  break;
	}
        if (event.xexpose.window==win_quickview) {
	  display_view();
	  break;
	}
/*<FONT COLOR=#0000C0>
        if (event.xexpose.window==win_clipboard) {
          XDrawLine(dpy,win_clipboard,gc2,0,0,lright,hclip);
	  break;
	}
        if (event.xexpose.window==win_toolbar) {
          XDrawLine(dpy,win_toolbar,gc2,0,0,lright,htoolbar);
	  break;
	}
</FONT>*/
        /*<FONT COLOR=#0000C0> scan the menu buttons </FONT>*/
        for (i=0;i<nb_but_menu;i++) {
          if (event.xexpose.window==button_menu[i]) {
            XDrawImageString(dpy,button_menu[i],gc2,4,
              font->ascent+2,but_menu_txt[i],strlen(but_menu_txt[i]));
	    break;
	  }
        }
        /*<FONT COLOR=#0000C0> scan the bottom buttons </FONT>*/
        for (i=0;i<nbottbutt;i++) {
          if (event.xexpose.window==win_bottom_button[i]) {
            XDrawImageString(dpy,win_bottom_button[i],gcbottbutt,(wbottbutt-functextwidth[i])>>1,font->ascent,functext[i],functextlength[i]);
            XDrawImageString(dpy,win_bottom_button[i],gcbottbutt,(wbottbutt-XTextWidth(font,functiontexts[i],strlen(functiontexts[i])))>>1,(1+font->ascent)<<1,functiontexts[i],strlen(functiontexts[i]));
	    break;
	  }
        }

	break;

      case ButtonPress:
	yclick=event.xbutton.y;
	xclick=event.xbutton.x;
	if (event.xbutton.button==1) {
	  buttonspressed|=1;
	  if (alt_key &&(event.xbutton.window==win_work)) {
	    /*printf("click! %d\n",xclick);*/
	    break;
	  }
	  if (event.xbutton.window==button_menu[0])
	    goto the_end;
	  if (event.xbutton.window==button_h_move1){
            display_moving_button1(moving_button1=1);
	    break;
	  }
	  if (event.xbutton.window==button_v_move1){
            display_v_moving_button(vmoving_button=8+16,button_v_move1);
	    break;
	  }
	  if (event.xbutton.window==button_v_move2){
            display_v_moving_button(vmoving_button=16,button_v_move2);
	    break;
	  }
	}
	if (event.xbutton.button==2) {
	  buttonspressed|=2;
	  if (alt_key) {
	    view_everything();
	    break;
	  }
	}
	if (event.xbutton.button==3) {
	  buttonspressed|=4;
	}
        break;

      case ButtonRelease:
	if (event.xbutton.button==1) {
	  buttonspressed&=~1;
	  if (moving_button1) {
  	    resize_move_button1(right_window_width,1);
	    display_moving_button1(moving_button1=0);
	    break;
          }
	  if (vmoving_button) {
	    resize_v_button(1);
	    display_v_moving_button(0,event.xbutton.window);
	    break;
          }
        }
	if (event.xbutton.button==2) {
	  buttonspressed&=~2;
	}
	if (event.xbutton.button==3) {
	  buttonspressed&=~4;
	}
        break;

      case MotionNotify:
	if (alt_key) { /* ALT key is being pressed */
	  if (event.xbutton.window==win_work){ /* we're playing with the working window */
	    if (buttonspressed & 1) {  /* scrolling */ 
	      xclick-=event.xmotion.x;  /* hey ! that's dumb, it's exactly */
	      yclick-=event.xmotion.y;  /* what we get from the mouse ! */
	      scroll(-xclick,-yclick);
	      xclick=event.xmotion.x;
	      yclick=event.xmotion.y;
	      break;
	    }
	    if (buttonspressed & 4) {  /* zooming */
	      xclick-=event.xmotion.x;
	      yclick-=event.xmotion.y;
	      if (xclick+yclick<0)
		zoom_out();
	      else
		zoom_in();
	      xclick=event.xmotion.x;
	      yclick=event.xmotion.y;
	      break;
	    }
	  }
	}
        if ((event.xmotion.window==button_h_move1)&&(moving_button1)) {
	  resize_move_button1(right_window_width-(event.xmotion.x-xclick),0);
          break;
	}
        if (vmoving_button) {
          if (vmoving_button&8){ /*<FONT COLOR=#0000C0> if v1 </FONT>*/
	    vmoving1+=event.xmotion.y-yclick;
	    vmoving_button|=1+16;
	    resize_v_button(0);
	    break;
	  } /*<FONT COLOR=#0000C0> else : v2 </FONT>*/
	  vmoving2+=event.xmotion.y-yclick;
	  vmoving_button|=2+32;
	  resize_v_button(0);
	}
        break;

      case KeyRelease :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
	switch(keysym) {
          case XK_Alt_L:
            alt_key&= ~1;
	    break;
          case XK_Alt_R:
            alt_key&= ~2;
	    break;
	}        
        break;

      case KeyPress :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
        if ((car=='q')||(car=='Q'))
          goto the_end;
	switch(keysym) {
          case XK_Page_Up:
	    zoom_out();
	    break;
          case XK_Page_Down:
	    zoom_in();
	    break;
          case XK_Alt_L:
            alt_key|=1;
	    break;
          case XK_Alt_R:
	    alt_key|=2;
	    break;
          case XK_Home:
	    view_everything();
	    break;
	  case XK_Left:
	    scroll(movestep,0);
	    break;
	  case XK_Right:
            scroll(-movestep,0);
            break;
	  case XK_Up:
	    scroll(0,-movestep);
	    break;
	  case XK_Down:
            scroll(0,movestep);
            break;
	}

        break;
    }
  } while (1);

the_end:
  exit_and_save_config(0);
  return 0;
}
