#ifndef __FCPU_ASM_H__
#define __FCPU_ASM_H__

#define SIZE_B                   0 << 8  // byte (8bit)
#define SIZE_D                   1 << 8  // double byte (16bit)
#define SIZE_Q                   2 << 8  // quad byte (32bit)
#define SIZE_W                   3 << 8  // word (64bit)
#define SIZE_MASK                3 << 8  // word (64bit)

#define ARITHM_UNSIGNED          1 << 10  
#define ARITHM_SIMD              1 << 11
#define ARITHM_SUB               1 << 12   
#define ARITHM_MOD               1 << 12   

#define TEST_EQ                  0 << 10 // equal to
#define TEST_NQ                  1 << 10 // not equal to
#define TEST_GT                  2 << 10 // greater than
#define TEST_GE                  3 << 10 // greater than or equal
#define TEST_LT                  4 << 10 // less than
#define TEST_LE                  5 << 10 // less than or equal to
#define TEST_CF                  6 << 10 // carry flag set
#define TEST_CZ                  7 << 10 // zero flag set
#define TEST_MASK               15 << 10 

#define SHIFTROT_LEFT            0 << 11 // shift/rotate left
#define SHIFTROT_RIGHT           1 << 11 // shift/rotate right
#define SHIFTROT_DIRECTION       1 << 11
#define SHIFTROT_ARITHMETIC      1 << 10 // arithmetic shift/rotate

#define LOGIC_OR                 7 << 10 // 0111
#define LOGIC_AND                1 << 10 // 0001
#define LOGIC_XOR                6 << 10 // 0110
#define LOGIC_NOR                8 << 10 // 1000
#define LOGIC_NAND              14 << 10 // 1110
#define LOGIC_MASK              15 << 10 // 1111

#define FLOAT_DOUBLE             0 << 8  // double size float op
#define FLOAT_FLOAT              1 << 8  // float size float op
#define FLOAT_SIZE_MASK          3 << 8 // float size
#define FLOAT_NEGATE             1 << 10 // FP
#define FLOAT_SIMD               1 << 10 // SIMD float instruction
#define FLOAT_IEEE               0 << 11 // SIMD float instruction
#define FLOAT_NON_IEEE           1 << 11 // SIMD float instruction

#define FLOAT_INT2F              0 << 10 // int2float flag
#define FLOAT_F2INT              1 << 10 // float2int flag
#define FLOAT_DIRECTION          1 << 10 

#define FLOAT_ROUND_NEARES       0 << 10
#define FLOAT_ROUND_TOZERO       1 << 10
#define FLOAT_ROUND_AWZERO       2 << 10
#define FLOAT_ROUND_TOPLUSINFTY  3 << 10
#define FLOAT_ROUND_TOMINUSINFTY 4 << 10
#define FLOAT_ROUND_MASK         7 << 10

#define OP_ADD                  1
#define OP_SUB                  128
#define OP_MUL                  2
#define OP_DIV                  3
#define OP_MOD                  129
#define OP_LOGIC                4
#define OP_BITOP                5
#define OP_LOAD                 6
#define OP_STORE                7
#define OP_LOADCONS             8
#define OP_MOV                  9
#define OP_GET                  10
#define OP_PUT                  11
#define OP_PREFETCH             12
#define OP_SHIFT                13
#define OP_ROT                  14
#define OP_JMPA                 15
#define OP_LOOPENTRY            16
#define OP_LOOP                 17
#define OP_SYSCALL              18
#define OP_TRAP                 (OP_SYSCALL)

#define OP_FADD                 20
#define OP_FSUB                 21
#define OP_FMUL                 22
#define OP_FINV                 23
#define OP_FDIV                 24
#define OP_FSQRT                25
#define OP_FINVSQRT             26
/*
  #define OP_ADDI                 
  #define OP_SUBI                 (OP_ADDI | ARITHM_SUB)
  #define OP_MULI                 
  #define OP_DIVI                 
  #define OP_MODI                 (OP_DIVI | ARITHM_MOD)
  #define OP_FADD                 
  #define OP_FSUB                 (OP_FADD | FLOAT_NEGATE)
  #define OP_FMUL                 
  #define OP_FINV                 
  #define OP_FDIV                 
  #define OP_FSQRT                
  #define OP_FINVSQRT             
  #define OP_INT2F                
  #define OP_F2INT                (OP_INT2F | FLOAT_F2INT) 
  #define OP_GETI                 
  #define OP_PUTI                 
  #define OP_LOADI                
  #define OP_STOREI               
*/

#endif
