#ifndef REGISTER_HH
#define REGISTER_HH

typedef unsigned long long uint64;
typedef long long int64;
typedef unsigned int uint32;
typedef int int32;
typedef unsigned short uint16;
typedef short int16;
typedef unsigned char uint8;
typedef char int8;

class Register
{
private:
  union
  {
    uint64  ui64;
    uint32  ui32[2];
    uint16  ui16[4];
    uint8   ui8[8];
    int64   i64;
    int32   i32[2];
    int16   i16[4];
    int8    i8[8];
    double  fp64;
    float   fp32[2];
  } reg;

public:
  Register(uint64 l = 0) 
  {
    s_uint64(l);
  }

  bool operator < (uint64 l) 
  {
    return (reg.ui64 < l); 
  } 

  const Register &operator = (uint64 l) 
  { 
    reg.ui64 = l;
    return *this; 
  } 

  const uint64 r_uint64() 
  {
    return reg.ui64;
  } 

  const  int64 r_int64()  
  { 
    return reg.i64;
  } 
  
  const double r_fp64() 
  { 
    return reg.fp64;
  } 
  
  const uint32 r_uint32(int i) 
  {
    if((i<2)||(i>=0)) return reg.ui32[i];
  } 
  
  const  int32 r_int32(int i)
  {
    if((i<2)||(i>=0)) return reg.i32[i]; 
  }
  
  const  float r_fp32(int i)
  {
    if((i<2)||(i>=0)) return reg.fp32[i]; 
  }

  const uint16 r_uint16(int i) 
  { 
    if((i<4)||(i>=0)) return reg.ui16[i]; 
  } 

  const  int16 r_int16(int i)
  {
    if((i<4)||(i>=0)) return reg.i16[i];
  }
  const uint8 r_uint8(int i) 
  {
    if((i<8)||(i>=0)) return reg.ui8[i]; 
  } 
  const  int8 r_int8(int i)
  {
    if((i<8)||(i>=0)) return reg.i8[i]; 
  }

  const uint64 s_uint64(uint64 v) 
  {
    return reg.ui64=v;
  } 
  
  const  int64 s_int64(int64 v)  
  {
    return reg.i64=v; 
  }
  
  const  double s_fp64(double v) 
  {
    return reg.fp64=v; 
  }
  
  const uint32 s_uint32(int i, uint32 v)
  {
    if((i<2)||(i>=0)) return reg.ui32[i]=v; 
  }
 
  const  int32 s_int32(int i, int32 v)
  {
    if((i<2)||(i>=0)) return reg.i32[i]=v;
  }
  
  const  float s_fp32(int i, float v)
  {
    if((i<2)||(i>=0)) return reg.fp32[i]=v;
  }

  const uint16 s_uint16(int i, uint16 v) 
  { 
    if((i<4)||(i>=0)) return reg.ui16[i]=v; 
  }
 
  const  int16 s_int16(int i, int16 v)
  { 
    if((i<4)||(i>=0)) return reg.i16[i]=v;
  }
  
  const uint8 s_uint8(int i, uint8 v) 
  { 
    if((i<8)||(i>=0)) return reg.ui8[i]=v; 
  }
 
  const  int8 s_int8(int i, int8 v)
  { 
    if((i<8)||(i>=0)) return reg.i8[i]=v; 
  }

  void inc(uint64 i) 
  {
    reg.ui64 += i;
  }

  void set(Register r) 
  {
    reg = r.reg; 
  }
};

#endif
