#ifndef MEMORY_HH
#define MEMORY_HH

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "Register.hh"

class Memory
{
private:
  char *memory;
  uint64 max;

public:
  Memory(unsigned int size)
  {
    max = size;
    memory = new char[size];
  }
  
  Memory(char *file)
  {  
    struct stat st;
    int fd;
    unsigned int count;

    stat(file, &st);
    count = st.st_size;

    printf("%d\n", count);

    memory = new char[count];
    fd = open(file,O_RDONLY);
    max = count;

    if(fd>0)
      {
	count = read(fd, memory, max);
	if(max!=count) 
	  printf("Error loading file...");
	close(fd);
      }
  }

  ~Memory()
  {
    delete [] memory;
  }
  
  Register read_memory(Register p, char size = 8);
  void write_memory(Register p, Register data, char size = 8);
  void dump(FILE *f);

};

#endif
