#include "LogicUnit.hh"

void LogicUnit::tick()
{
}

void LogicUnit::launch_instruction(unsigned char op, Instruction inst,
					int reg_src[], int reg_dest[])
{
  uint64 r1, r2, r3 = 0, r4;

  switch(op)
    {
    case OP_LOGIC:

      r1 = regs().read_register(reg_src[0]).r_uint64();
      r2 = regs().read_register(reg_src[1]).r_uint64();

      if(inst.value() & 4) r3 |= (~r1 & ~r2); 
      if(inst.value() & 5) r3 |= ( r1 & ~r2); 
      if(inst.value() & 6) r3 |= (~r1 &  r2); 
      if(inst.value() & 7) r3 |= ( r1 &  r2); 

      regs().write_partial_register(reg_dest[0],  r3, (1<<inst.size()) );
      break;
    }
}
