#ifndef INSTRUCTION__H
#define INSTRUCTION__H

#include "Register.hh"

/*
  [14:17:21]      pixel| opcode  = 0..4
  [14:17:21]      pixel| format  = 5..6
  [14:17:21]      pixel| type    = 7..8
  [14:17:21]      pixel| packed  = 9
  [14:17:22]      pixel| extend  = 9..10
  [14:17:25]      pixel| direct  = 9
  [14:17:26]      pixel| hl      = 9
  [14:17:28]      pixel| endian  = 9
  [14:17:31]      pixel| sign    = 10
  [14:17:33]      pixel| subsel2 = 9..10
  [14:17:35]      pixel| subsel3 = 9..11
  [14:17:37]      pixel| subsel5 = 9..13
  [14:17:39]      pixel| neg2nd  = 11
*/

class Instruction
{

  uint32 instruction;

public:
  
  Instruction(uint32 inst) { instruction=inst; }
  uint8 op() { return (instruction % 256); }
  int reg1() { return ((instruction>>26) % 64);}
  int reg2() { return ((instruction>>20) % 64);}
  int reg3() { return ((instruction>>14) % 64);}
  char size() { return ((instruction>>8)% 4);}
  bool simd() { return ((instruction&(1<<11)!=0));}
  bool arith() { return ((instruction&(1<<11)!=0));}

  const uint32 value() { return instruction; }
  };

#endif
