#include "FloatingPointUnit.hh"

void FloatingPointUnit::tick()
{
}

void FloatingPointUnit::launch_instruction(unsigned char op, Instruction inst,
					int reg_src[], int reg_dest[])
{
  Register source1 = regs().read_register(reg_src[0]);
  Register source2 = regs().read_register(reg_src[1]);
  Register result;

  switch(op)
    {
    case OP_FADD:
      if (inst.simd())
	{
	  result.s_fp32(0,source1.r_fp32(0)+source2.r_fp32(0));
	  result.s_fp32(1,source1.r_fp32(1)+source2.r_fp32(1));
	}
      else 
	result.s_fp64(source1.r_fp64() + source2.r_fp64());
      break;

    case OP_FSUB:
      if (inst.simd())
	{
	  result.s_fp32(0,source1.r_fp32(0) - source2.r_fp32(0));
	  result.s_fp32(1,source1.r_fp32(1) - source2.r_fp32(1));
	}
      else 
	result.s_fp64(source1.r_fp64() - source2.r_fp64());
     break;

    case OP_FMUL:
      if (inst.simd())
	{
	  result.s_fp32(0,source1.r_fp32(0) * source2.r_fp32(0));
	  result.s_fp32(1,source1.r_fp32(1) * source2.r_fp32(1));
	}
      else 
	result.s_fp64(source1.r_fp64() * source2.r_fp64());
      break;

    case OP_FDIV:
      if (inst.simd())
	{
	  result.s_fp32(0,source1.r_fp32(0) / source2.r_fp32(0));
	  result.s_fp32(1,source1.r_fp32(1) / source2.r_fp32(1));
	}
      else 
	result.s_fp64(source1.r_fp64() / source2.r_fp64());
      break;

    default:
      return;
      break;
    }

  regs().write_register (reg_dest[0], result);

}
