#include <stdio.h>
#include "Decoder.hh"
#include "Processor.hh"

void Decoder::tick()
{
  Register *pc = PC();
  Memory *m = mem();
  Instruction inst(m->read_memory((*pc), 4).r_uint32(0));
  int tmp[2];
  int reg1, reg2, reg3;
  // Warning these regs are in reverse order...

  reg1 = inst.reg1();
  reg2 = inst.reg2();
  reg3 = inst.reg3();
 

  printf("Opcode %x\n", inst.op());
  printf("Address %llx\n", pc->r_uint64());
  printf("Instruction %x\n", inst.value());
  printf("Reg1: %d\n", reg1);
  printf("Reg2: %d\n", reg2);
  printf("Reg3: %d\n", reg3);

  pc->inc(4);

  switch (inst.op())
    {
    case OP_LOAD:
    case OP_STORE:
      p->LSU.launch_instruction(inst.op(), inst, &reg2, &reg1);
     
      break;
      
    case OP_ADD:
    case OP_SUB:
      tmp[0]=reg3;
      tmp[1]=reg2;
      p->AU.launch_instruction(inst.op(), inst, tmp, &reg1);
      break;

    case OP_LOOPENTRY:
      printf("Loopentry %llx", pc->r_uint64());
      regs().write_register(reg1, *pc);
      break;

    case OP_JMPA:
      tmp[0]=reg2;
      tmp[1]=reg1;
      p->BU.launch_instruction(inst.op(), inst, tmp, NULL);
      break;

    case OP_SHIFT:
    case OP_ROT:
      tmp[0]=reg3;
      tmp[1]=reg2;
      p->SU.launch_instruction(inst.op(), inst, tmp, &reg1);
      break;

    case OP_LOGIC:
      tmp[0]=reg3;
      tmp[1]=reg2;
      p->LU.launch_instruction(inst.op(), inst, tmp, &reg1);
      break;

    case OP_LOADCONS:
      printf("Loadcons %x to reg %d\n",(inst.value()>>10)%(1<<16),reg1);
      regs().write_register(reg1, (inst.value()>>10)%(1<<16));
      break;


    case OP_MOV:
      if((reg3==0)||(regs().read_register(reg3).r_uint64()!=0))
      regs().write_register(reg1, regs().read_register(reg2).r_uint64());

      //    case OP_HALT:

    default:
      break;
    }
}
