#include "IntUnit.hh"
#include "InstructionSet.hh"

void IntUnit::execute(Instruction i, Operand *o, int n, ProcessorData *data)
{
  switch(getOp(i))
    {
    case add: data->setRegister(getReg1(i),
				data->getRegister(getReg1(i))+
				data->getRegister(getReg2(i)));
    break;
    case neg: data->setRegister(getReg1(i),-data->getRegister(getReg1(i)));
      break;
    case mul: data->setRegister(getReg1(i),
				data->getRegister(getReg1(i))*
				data->getRegister(getReg2(i)));
    break;  
    case div: data->setRegister(getReg1(i),
				data->getRegister(getReg1(i))/
				data->getRegister(getReg2(i)));
    break;
    case shl:
      {
	RegType tmp = data->getRegister(getReg1(i));
	tmp = tmp << data->getRegister(getReg2(i));
	data->setRegister(getReg1(i), tmp);
      }
      break;
    case shr:
      {
	RegType tmp = data->getRegister(getReg1(i));
	tmp = tmp >> data->getRegister(getReg2(i));
	data->setRegister(getReg1(i), tmp);
      }
      break;
    case rol:
      {
	RegType tmp1 = data->getRegister(getReg1(i));
	RegType tmp2 = tmp1;
	RegType tmp3 = data->getRegister(getReg2(i));
	tmp1 = tmp1 << tmp3;
	tmp2 = tmp1 >> 64-tmp3;
	data->setRegister(getReg1(i), tmp1+tmp2);
      }
      break;
    case ror:
      {
	RegType tmp1 = data->getRegister(getReg1(i));
	RegType tmp2 = tmp1;
	RegType tmp3 = data->getRegister(getReg2(i));
	tmp1 = tmp1 >> tmp3;
	tmp2 = tmp1 << 64-tmp3;
	data->setRegister(getReg1(i), tmp1+tmp2);
      }
    }
}

