#ifndef MemoryUnit__HH
#define MemoryUnit__HH

#include "ProcessorSimulator.hh"
#include "ProcessorTypes.hh"
#include "ProcessorUnit.hh"
#include "MemoryUser.hh"

class MemoryUnit
{
public:

  virtual void Load(RegType p, MemoryUser *mu, int tag) = 0;
  virtual void Store(RegType p, RegType d, int size) = 0;

  virtual void LoadBlock(RegType p, MemoryUser *mu, int tag, int size, int count) = 0;
  virtual void StoreBlock(RegType p, RegType *d, int size, int count) = 0;

  virtual int getInstruction(RegType p) = 0;
};

#endif
