/*
<HTML><TITLE>Whygee's dirty Xlib'ed interface (2)</TITLE><BODY BGCOLOR="#FFFFFF" FGCOLOR="#000000">
<PRE>

View.c (C) par Yann Guidon mars 2000

This module is in charge of displaying the data on the working window.

It is included as is from the <A HREF="gnl.c">main file</A> directly (no header file etc...).

It only treats data on a "bounding box" (bbox) basis, it will be refined later.
Most important now is to setup the several coordinates systems.

What we use from the main file :
 win_work : <FONT COLOR=#0000C0>the window where we display stuffs</FONT>
 hwork : <FONT COLOR=#0000C0>height of the working window</FONT>
 wwork : <FONT COLOR=#0000C0>width of the working window</FONT>
 win_quickview : <FONT COLOR=#0000C0> the window where we display the zoom</FONT>
 hclip : <FONT COLOR=#0000C0>height of the quickview window</FONT>
 lright : <FONT COLOR=#0000C0>width of the quickview window</FONT>

*/

/* internal coordinates system : 1 box 'step' = 256 integer units, so we can place the boxes
at arbitrary coordinates. box "alignment" is therefore performed by clearing the 8 MSBs. */
#define COORDSHIFT 8

/* so, a box can't be smaller than a pixel. the zoom factor can't seriously be below
COORDSHIFT. yet scaling is now a multiplication followed by a right shift,
and there is no real need to modify COORDSHIFT unless you need to display more
boxes than there are pixels on the screen. OTOH you can zoom in but in practice
it is limited to the definition of the boxes, 1/256. */

int
 bboxdisplayed=1, /* flag */
 coordschanged=1, /* flag */
 zoom=30, /* ratio between screen and objects (modified by COORDSHIFT) */
 qvscalemul, /* ratio for the mapping between qv and other */
 qvscalediv,

/* in the screen coordinates system : */
 xminbbox, /* bounding box for the objects */
 yminbbox,
 xmaxbbox,
 ymaxbbox,
 xmqvbbox, /* coordinates of the center of the bounding box of everything */
 ymqvbbox,
 
 /* in the internal coordinates system : */
 xview=0,/*<FONT COLOR=#0000C0>coordinates of the center of the display </FONT>*/
 yview=0,
 coord_x1bbox,  /* bounding box of the segments we'll display */
 coord_y1bbox,
 coord_x2bbox,
 coord_y2bbox,
 coord_xmin=0<<COORDSHIFT,
 coord_xmax=5<<COORDSHIFT,
 coord_ymin=0<<COORDSHIFT,
 coord_ymax=10<<COORDSHIFT,
 coord_xdelta,
 coord_ydelta;

XRectangle quick_scope,quick_bbox;

/*
<FONT COLOR=#0000C0> the viewing part : </FONT>
*/

void display_view(void) {
  XFillRectangles(dpy,win_quickview,gcgrey4,&quick_bbox,1);
  XDrawRectangles(dpy,win_quickview,gcgrey7,&quick_scope,1);
}

void compute_quickview() {
  /* here, it is computed in the internal
     coordinates space, not the screen space. */
  int temp1,temp2,
    xminqvbbox,yminqvbbox,
    xmaxqvbbox,ymaxqvbbox,
    widthqvbbox,heightqvbbox;

 /* to display something in qv :
  (n*lright)/widthqvbbox or
  (n*hview)/heightqvbbox */

  /* maps the viewing scope on the internal space */
  temp1=((wwork>>1)<<COORDSHIFT)/zoom;
  temp2=((hwork>>1)<<COORDSHIFT)/zoom;
  xminqvbbox=xview-temp1;
  xmaxqvbbox=xview+temp1;
  yminqvbbox=yview-temp2;
  ymaxqvbbox=yview+temp2;

  /* find the absolute bbox : */
  if (xminqvbbox>coord_xmin)
    xminqvbbox=coord_xmin;
  if (yminqvbbox>coord_ymin)
    yminqvbbox=coord_ymin;
  if (xmaxqvbbox<coord_xmax)
    xmaxqvbbox=coord_xmax;
  if (ymaxqvbbox<coord_ymax)
    ymaxqvbbox=coord_ymax;

  /* bbox size */
  widthqvbbox=xmaxqvbbox-xminqvbbox;
  heightqvbbox=ymaxqvbbox-yminqvbbox;

  /* determine if we scale along x or y */
  if (((hview-1)*widthqvbbox)>(heightqvbbox*(lright-1))) {
    qvscalemul=(lright-1);
    qvscalediv=widthqvbbox;
  }
  else {
    qvscalemul=(hview-1);
    qvscalediv=heightqvbbox;
  }

  /* middle of the BBOX */
  xmqvbbox=xminqvbbox+(widthqvbbox>>1);
  ymqvbbox=yminqvbbox+(heightqvbbox>>1);

  /* computes the coordinates on qv (at last) */
  quick_scope.x=((lright-1)>>1)+((((xview-temp1)-xmqvbbox)*qvscalemul)/qvscalediv);
  quick_scope.width=(temp1*2*qvscalemul)/qvscalediv;
  quick_scope.y=((hview-1)>>1)+((((yview-temp2)-ymqvbbox)*qvscalemul)/qvscalediv);
  quick_scope.height=(temp2*2*qvscalemul)/qvscalediv;

  quick_bbox.x=((lright-1)>>1)+(((coord_xmin-xmqvbbox)*qvscalemul)/qvscalediv);
  quick_bbox.width=((coord_xmax-coord_xmin)*qvscalemul)/qvscalediv;
  quick_bbox.y=((hview-1)>>1)+(((coord_ymin-ymqvbbox)*qvscalemul)/qvscalediv);
  quick_bbox.height=((coord_ymax-coord_ymin)*qvscalemul)/qvscalediv;

  if (quick_bbox.width<1)
    quick_bbox.width=1;
  if (quick_bbox.height<1)
    quick_bbox.height=1;

  XClearWindow(dpy,win_quickview);
  display_view();
}

void display_work(void) {
  /* that's where we'll fork... */
  if (coordschanged) {
    coordschanged=0;

    /* recompute the quickview coordinates too !*/
    compute_quickview();

     /* recompute the segment lists */

    /* compute the internal coordinates */
    coord_xdelta=coord_xmax-coord_xmin;
    coord_ydelta=coord_ymax-coord_ymin;

    xminbbox=(wwork>>1)+(((coord_xmin-xview)*zoom)>>COORDSHIFT);
    yminbbox=(hwork>>1)+(((coord_ymin-yview)*zoom)>>COORDSHIFT);
    xmaxbbox=(coord_xdelta*zoom)>>COORDSHIFT;
    ymaxbbox=(coord_ydelta*zoom)>>COORDSHIFT;

    /* check if we have to display the bbox */
    if (((xmaxbbox+xminbbox)<0)
      ||((ymaxbbox+yminbbox)<0)
       ||(xminbbox>wwork)
       ||(yminbbox>hwork)){
      bboxdisplayed=0;
      return;
    }
    bboxdisplayed=1;

    /* ok but now, we still have to clip... */

    if (xminbbox<0) {
      xmaxbbox+=xminbbox;
      xminbbox=0;
    }

    if (yminbbox<0) {
      ymaxbbox+=yminbbox;
      yminbbox=0;
    }

    if ((xmaxbbox+xminbbox)>wwork) {
      xmaxbbox=wwork-xminbbox;
    }

    if ((ymaxbbox+yminbbox)>hwork) {
      ymaxbbox=hwork-yminbbox;
    }

    /*
         now that we have the displayed coordinates,
	 we have to translate them to the internal
	 coordinates system in order to clip them
	 with the scanning loop.
    compute :
 coord_x1bbox,
 coord_y1bbox,
 coord_x2bbox,
 coord_y2bbox,
    */

  }

  if (bboxdisplayed) {
    XFillRectangle(dpy,win_work,gcgrey1,xminbbox,yminbbox,xmaxbbox,ymaxbbox);
  }
}

void refresh_view(){
  coordschanged=1;
  XClearWindow(dpy,win_work);
  display_work(); /* that's the heavy part */
}

void view_everything(void) {
  /* find max coords */
  coord_xdelta=coord_xmax-coord_xmin;
  coord_ydelta=coord_ymax-coord_ymin;

  /* find if we must adjust the zoom on the height or the width */
  if ((coord_xdelta*hwork)<(coord_ydelta*wwork))

  /* adjust zoom with the height of the work screen
    formula : hwork = (coord_ydelta*zoom)>>COORDSHIFT so : */
  zoom=(hwork<<(COORDSHIFT+5))/(coord_ydelta+(coord_ydelta<<5));
  /* note that it is also adjusted with a ratio of 32/33... */

  else /* adjust zoom with the width of the work screen */
    zoom=(wwork<<(COORDSHIFT+5))/(coord_xdelta+(coord_xdelta<<5));

  if (zoom<1)
    zoom=1;

  /* find the middle of the view */
  xview=coord_xmin+(coord_xdelta>>1);
  yview=coord_ymin+(coord_ydelta>>1);
  refresh_view();  
}

void zoom_out() {
  if (zoom>1) { /* avoid blinking... */
    zoom=(zoom*7)>>3; /* 7/8=.875 */
    if (zoom<1)
      zoom=1;
    refresh_view();
  }
}

void zoom_in() {
  if (zoom<100000) { /* avoid blinking... */
    zoom=((zoom*9)>>3)+1; /* 9/8=1.125  */
    if (zoom>100000)
      zoom=100000;
    refresh_view();
  }
}

void scroll(int steph, int stepv) {
  yview-=(hwork*stepv)>>COORDSHIFT;
  xview-=(hwork*steph)>>COORDSHIFT;
  refresh_view();
}

void resize_view(void) {
  compute_quickview();
  XMoveResizeWindow(dpy,win_quickview,xright,menuheight+vmoving2+10,lright,hview);
}

void resize_work(void){
  coordschanged=1;
  hwork=main_ysize-hbottom-menuheight;
  wwork=main_xsize-right_window_width;
  XMoveResizeWindow(dpy,win_work,0,menuheight,wwork,hwork);
}
