/*
<HTML><TITLE>Whygee's dirty Xlib'ed interface</TITLE><BODY BGCOLOR="#FFFFFF" FGCOLOR="#000000"><PRE>

 (C) mars 2000 by Yann Guidon, placed under GPL

*/

/* for the directory listing : */
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <dirent.h>

#define PATHNAMELENGTH 300
char
 directory_load[PATHNAMELENGTH],
 directory_save[PATHNAMELENGTH],
 current_directory[PATHNAMELENGTH],
 current_file[PATHNAMELENGTH],
 *browse_path;
block_header *ll_browse=NULL; /* linked list of file names */
string_cell first_file_name, *first_browse_file;

int
 first_browse_file_count,
 can_display_file_count,
 max_browse_menu,
 current_browse_sel=-1, /* currently unused */
 current_browse_line=-1, /* currently unused */
 toolbar_in_use=0, /* ==1 if load, ==2 if save as */
 nb_fic=0;

int create_descriptors(char *c) {
  string_cell *p, *q;
  DIR *dir;
  struct direct *file;
  struct stat state;
  int i,len,oldlen;

  if (c[0]==0) {
    /* setup the default directory */
    if (getcwd(c,PATHNAMELENGTH)==NULL) {
      XBell(dpy,1);
      change_message("can't get current working directory");
      return 1;
    }
  }

  if (c!=current_directory)
    memcpy(current_directory,c,PATHNAMELENGTH); /* banzaii ! */

  if ((dir=opendir(current_directory))==NULL) {
    XBell(dpy,1);
    memcpy(error_msg,"can't open this directory : ",29);
    memcpy(error_msg+28,current_directory,51);
    error_msg[80]=0;
    change_message(error_msg);
    return 2;
  }

  /* free the list etc */
  if (ll_browse)
    ll_free(&ll_browse);
  len=strlen(current_directory);
  first_file_name.next=NULL;
  nb_fic=0;
  oldlen=len;
  if (len>1) {
    current_directory[len]='/';
    len++;
    current_directory[len]=0;
  }

  while ((file=readdir(dir))!=NULL) {  /* while there is a file */
    if (strcmp(".",file->d_name)) {   /* skip the unuseful "." entry */
      i=strlen(file->d_name);
      if (i+len< PATHNAMELENGTH) {
	memcpy(current_directory+len,file->d_name,i+1); /* make a full absolute file name */
	if (stat(current_directory,&state)==0) {
	  p=my_alloc(&ll_browse,sizeof(string_cell)+i+2);
	  c=sizeof(string_cell)+((char*)p);
	  memcpy(c,file->d_name,i+2);
	  if (S_ISDIR(state.st_mode)) {
	    c[i++]='/';
	    c[i]=0;
	  }
	  p->size=i;
	  nb_fic++;

	  q=&first_file_name;

	  while ((q->next)&&((i=strcmp(sizeof(string_cell)+((char*)q->next),
                                      sizeof(string_cell)+((char*)p)))<=0))
	    q=q->next;

	  p->next=q->next;  
	  q->next=p;	    
	}
      }
    }
  }

  current_directory[oldlen]=0; /* cleanup the '/' */

  closedir(dir);
  return 0;
}

void display_win_scroll_browse(void) {
  XDrawLine(dpy,win_scroll_browse,gcgrey7,0,8,0,browse_height-8);  
  XDrawLine(dpy,win_scroll_browse,gcgrey6,1,6,1,browse_height-6);  
  XDrawLine(dpy,win_scroll_browse,gcgrey5,2,4,2,browse_height-4);  
  XDrawLine(dpy,win_scroll_browse,gcgrey4,3,2,3,browse_height-2);  
  XDrawLine(dpy,win_scroll_browse,gcgrey3,4,0,4,browse_height);  
  XDrawLine(dpy,win_scroll_browse,gcgrey4,5,2,5,browse_height-2);  
  XDrawLine(dpy,win_scroll_browse,gcgrey5,6,4,6,browse_height-4);  
  XDrawLine(dpy,win_scroll_browse,gcgrey6,7,6,7,browse_height-6);  
  XDrawLine(dpy,win_scroll_browse,gcgrey7,8,8,8,browse_height-8);  

  XDrawLine(dpy,win_scroll_browse,gcgrey4,0,10,8,10);  
  XDrawLine(dpy,win_scroll_browse,gcgrey2,0,11,8,11);  
  XDrawLine(dpy,win_scroll_browse,gcgrey4,0,12,8,12);  

  XDrawLine(dpy,win_scroll_browse,gcgrey4,0,browse_height-10,8,browse_height-10);  
  XDrawLine(dpy,win_scroll_browse,gcgrey2,0,browse_height-11,8,browse_height-11);  
  XDrawLine(dpy,win_scroll_browse,gcgrey4,0,browse_height-12,8,browse_height-12);  
}

void display_win_browse(void) {
  string_cell * p=first_browse_file;
  int m=0;

  if (toolbar_in_use!=1)
    return;

  can_display_file_count=0;

loop:
  p=p->next;
  if ((p)&&(m<browse_height-hmenu)) {
    XDrawImageString(dpy,win_browse,gc2,4,m+font->ascent+2,sizeof(string_cell)+((char*)p),p->size);
    m+=hmenu;
    can_display_file_count++;
    goto loop;
  }
  max_browse_menu=m;

  if (can_display_file_count<nb_fic) { /* we need a scrollbar */
    browse_width=lright-9;
    XMapWindow(dpy,win_scroll_browse);
  }
  else {
    browse_width=lright;
    XUnmapWindow(dpy,win_scroll_browse);
  }

  if ((current_browse_line>=0)&&(current_browse_line<m)) {
    /* focus */
    XDrawRectangle(dpy,win_browse,gcgrey6,0,current_browse_line,browse_width-1,hmenu+2);
    XDrawRectangle(dpy,win_browse,gcgrey5,1,current_browse_line+1,browse_width-3,hmenu);
    XDrawRectangle(dpy,win_browse,gcgrey3,2,current_browse_line+2,browse_width-5,hmenu-2);
  }
}

void display_browse(void) {
  /* this could be enhanced to display a file or directory history */
  int m=hmenu;
  XDrawImageString(dpy,win_toolbar,gc2,4,font->ascent+2,current_directory,strlen(current_directory));
  XDrawLine(dpy,win_toolbar,gcgrey3,0,m,lright,m); m++;
  XDrawLine(dpy,win_toolbar,gcgrey5,0,m,lright,m); m++;
  XDrawLine(dpy,win_toolbar,gcgrey6,0,m,lright,m); m++;
  XDrawLine(dpy,win_toolbar,gcgrey5,0,m,lright,m); m++;
  XDrawLine(dpy,win_toolbar,gcgrey3,0,m,lright,m); m++;
}

void (*display_toolbar)(void)=NULL;

int (*browse_action)(int)=NULL;

int callback_load2(int i){
  /* save the current directory */
  memcpy(directory_load,current_directory,i+1);

  if (scan_GNL(current_file)) {
    string_cell * p=first_warning;
    while (p!=NULL) {
      fprintf(stderr,"%s\n",((char*)p)+sizeof(string_cell));
      p=p->next;
    }
    current_file[0]=0;
    change_message(((char*)last_warning)+sizeof(string_cell));
    return 1;
  }
  XUnmapWindow(dpy,win_browse);
  XUnmapWindow(dpy,win_scroll_browse);
  change_message(""); /* will change later */
  return 0;
}

void callback_load(){
  if (toolbar_in_use!=1) {
    toolbar_in_use=1;
    current_browse_line=-1;
    current_browse_sel=-1;
    first_browse_file_count=0;
    first_browse_file=&first_file_name;
    if (create_descriptors(directory_load)) {
      directory_load[0]='~';
      directory_load[1]=0;
      create_descriptors(directory_load);
    }
    display_toolbar=display_browse; /* change the function that displays the toolbar */
    browse_action=callback_load2;
    XClearWindow(dpy,win_toolbar);
    scroll_value=-1;
    display_browse();
    XMapWindow(dpy,win_browse);
    if (scroll_value>=0)
      XMapWindow(dpy,win_scroll_browse);
  }
}

void refresh_scrollbar(){
  XClearWindow(dpy,win_browse);
  display_win_browse();
  display_win_scroll_browse();
}

void browse_scroll_up(){
  if (first_browse_file_count<=0)
    return;

  /* decrement the first file */
  first_browse_file_count--;
  current_browse_sel++;
  current_browse_line+=hmenu;

  first_browse_file=&first_file_name;
  i=first_browse_file_count;
  while (i) {
    first_browse_file=first_browse_file->next;
    i--;
  } /* yes, i know, it's silly to rescan the whole list... but wait a bit... */
  refresh_scrollbar();
}

void browseup_sighandler(int i){
  if ((mouse_static)&&(buttonspressed&1)&&(first_browse_file_count>0)) {
    signal(SIGALRM, browseup_sighandler);
    browse_scroll_up();
  }
  else
    signal(SIGALRM, SIG_IGN);
}

void browse_scroll_down(){
  if (nb_fic-can_display_file_count<=first_browse_file_count)
    return;

  /* increment the first file */
  first_browse_file_count++;
  current_browse_sel--;
  current_browse_line-=hmenu;
  first_browse_file=first_browse_file->next;
  refresh_scrollbar();
}

void browsedown_sighandler(int i){
  if ((mouse_static)&&(buttonspressed&1)
   &&(nb_fic-can_display_file_count>first_browse_file_count)) {
    signal(SIGALRM, browsedown_sighandler);
    browse_scroll_down();
  }
  else
    signal(SIGALRM, SIG_IGN);
}

