#ifndef RamMemory__HH
#define RamMemory__HH

#include "ProcessorSimulator.hh"
#include "ProcessorTypes.hh"
#include "MemoryUnit.hh"

class RamMemory : public MemoryUnit
{
private:
  RegType *memory;
  int size;
  
public:
  RamMemory(int size) { memory = new RegType[size]; }
  ~RamMemory() { delete [] memory; }
  
  void Load(RegType p, MemoryUser *mu, int tag);
  void Store(RegType p, RegType d, int size);

  void LoadBlock(RegType p, MemoryUser *mu, int tag, int size, int count);
  void StoreBlock(RegType p, RegType *d, int size, int count);

  int getInstruction(RegType p);
};

#endif
