#ifndef ProcessorSimulator64__HH
#define ProcessorSimulator64__HH

#include "ProcessorSimulator.hh"
#include "ProcessorDecoder64.hh"
#include "LoadStoreUnit.hh"
#include "LogicUnit.hh"
#include "IntUnit.hh"


class ProcessorSimulator64: 
  public virtual ProcessorSimulator
{
private:
  MemoryUnit *memory;
  ProcessorData *data;
  ProcessorUnit **punits;
  ProcessingUnit **units;
  ProcessorDecoder *decoder;

public:
  ProcessorSimulator64(MemoryUnit *m); 
  ~ProcessorSimulator64();

  ProcessingUnit *getUnit(int i)
    { 
      if(i) return (ProcessingUnit*)(units[i-1]);
      else return (ProcessingUnit*) decoder;
    }
  void init();
  void tick();
};

#endif
