#include "ProcessorSimulator64.hh"
#include "ProcessorData64.hh"

ProcessorSimulator64::ProcessorSimulator64(MemoryUnit *m)
{
  memory=m;

  data = new ProcessorData64();
  data->setProcessorSimulator(this);
  decoder= new ProcessorDecoder64();
  decoder->initDecoder((ProcessorSimulator*)this, data,memory);

  LoadStoreUnit *lsu = new LoadStoreUnit();
  LogicUnit *lu = new LogicUnit();
  IntUnit *iu = new IntUnit();

  lsu->setMemory(memory);

  punits = new (ProcessorUnit*) [3];
  punits[0] = lsu;
  punits[1] = lu;
  punits[2] = iu;

  units = new (ProcessingUnit*) [3];
  units[0] = lsu;
  units[1] = lu;
  units[2] = iu;


}

ProcessorSimulator64::~ProcessorSimulator64()
{
  delete data;
}

void ProcessorSimulator64::init()
{
  data->init();
  for (int i=0;i<3;i++) punits[i]->init();
}

void ProcessorSimulator64::tick()
{
  ((ProcessorUnit*)decoder)->tick();
  for (int i=0;i<3;i++)
    ((ProcessorUnit*)units[i])->tick();
}
